/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fcrepo.common.lang.CheckedRunnable;
import org.fcrepo.common.metrics.MetricsHelper;
import org.fcrepo.persistence.api.exceptions.PersistentItemNotFoundException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflVersionInfo;
import org.fcrepo.storage.ocfl.ResourceContent;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.exception.NotFoundException;

public class FcrepoOcflObjectSessionWrapper
implements OcflObjectSession {
    private final OcflObjectSession inner;
    private static final String METRIC_NAME = "fcrepo.storage.ocfl.object";
    private static final String OPERATION = "operation";
    private static final Timer writeTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "write"});
    private static final Timer writeHeadersTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "writeHeaders"});
    private static final Timer deleteContentTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "deleteContent"});
    private static final Timer deleteResourceTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "deleteResource"});
    private static final Timer containsResourceTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "containsResource"});
    private static final Timer readHeadersTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "readHeaders"});
    private static final Timer readContentTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "readContent"});
    private static final Timer listVersionsTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "listVersions"});
    private static final Timer commitTimer = Metrics.timer((String)"fcrepo.storage.ocfl.object", (String[])new String[]{"operation", "commit"});

    public FcrepoOcflObjectSessionWrapper(OcflObjectSession inner) {
        this.inner = inner;
    }

    public String sessionId() {
        return this.inner.sessionId();
    }

    public String ocflObjectId() {
        return this.inner.ocflObjectId();
    }

    public ResourceHeaders writeResource(ResourceHeaders headers, InputStream content) {
        return (ResourceHeaders)MetricsHelper.time((Timer)writeTimer, () -> this.exec(() -> this.inner.writeResource(headers, content)));
    }

    public void writeHeaders(ResourceHeaders headers) {
        writeHeadersTimer.record(() -> this.exec(() -> this.inner.writeHeaders(headers)));
    }

    public void deleteContentFile(ResourceHeaders headers) {
        deleteContentTimer.record(() -> this.exec(() -> this.inner.deleteContentFile(headers)));
    }

    public void deleteResource(String resourceId) {
        deleteResourceTimer.record(() -> this.exec(() -> this.inner.deleteResource(resourceId)));
    }

    public boolean containsResource(String resourceId) {
        return (Boolean)MetricsHelper.time((Timer)containsResourceTimer, () -> this.exec(() -> this.inner.containsResource(resourceId)));
    }

    public ResourceHeaders readHeaders(String resourceId) {
        return (ResourceHeaders)MetricsHelper.time((Timer)readHeadersTimer, () -> this.exec(() -> this.inner.readHeaders(resourceId)));
    }

    public ResourceHeaders readHeaders(String resourceId, String versionNumber) {
        return (ResourceHeaders)MetricsHelper.time((Timer)readHeadersTimer, () -> this.exec(() -> this.inner.readHeaders(resourceId, versionNumber)));
    }

    public ResourceContent readContent(String resourceId) {
        return (ResourceContent)MetricsHelper.time((Timer)readContentTimer, () -> this.exec(() -> this.inner.readContent(resourceId)));
    }

    public ResourceContent readContent(String resourceId, String versionNumber) {
        return (ResourceContent)MetricsHelper.time((Timer)readContentTimer, () -> this.exec(() -> this.inner.readContent(resourceId, versionNumber)));
    }

    public List<OcflVersionInfo> listVersions(String resourceId) {
        return (List)MetricsHelper.time((Timer)listVersionsTimer, () -> this.exec(() -> this.inner.listVersions(resourceId)));
    }

    public Stream<ResourceHeaders> streamResourceHeaders() {
        return this.exec(() -> ((OcflObjectSession)this.inner).streamResourceHeaders());
    }

    public void versionCreationTimestamp(OffsetDateTime timestamp) {
        this.inner.versionCreationTimestamp(timestamp);
    }

    public void versionAuthor(String name, String address) {
        this.inner.versionAuthor(name, address);
    }

    public void versionMessage(String message) {
        this.inner.versionMessage(message);
    }

    public void commitType(CommitType commitType) {
        this.inner.commitType(commitType);
    }

    public void commit() {
        commitTimer.record(() -> this.exec(() -> ((OcflObjectSession)this.inner).commit()));
    }

    public void rollback() {
        this.exec(() -> ((OcflObjectSession)this.inner).rollback());
    }

    public void abort() {
        this.exec(() -> ((OcflObjectSession)this.inner).abort());
    }

    public boolean isOpen() {
        return this.inner.isOpen();
    }

    public void close() {
        this.exec(() -> ((OcflObjectSession)this.inner).close());
    }

    private <T> T exec(Callable<T> callable) throws PersistentStorageException {
        try {
            return callable.call();
        }
        catch (NotFoundException e) {
            throw new PersistentItemNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new PersistentStorageException(e.getMessage(), (Throwable)e);
        }
    }

    private void exec(CheckedRunnable runnable) throws PersistentStorageException {
        try {
            runnable.run();
        }
        catch (NotFoundException e) {
            throw new PersistentItemNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new PersistentStorageException(e.getMessage(), (Throwable)e);
        }
    }
}

