/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.NonRdfSourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.common.MultiDigestInputStreamWrapper;
import org.fcrepo.persistence.common.ResourceHeaderUtils;
import org.fcrepo.persistence.common.ResourceHeadersImpl;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.AbstractPersister;
import org.fcrepo.persistence.ocfl.impl.ResourceHeadersAdapter;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

abstract class AbstractNonRdfSourcePersister
extends AbstractPersister {
    private static final Logger log = LoggerFactory.getLogger(AbstractNonRdfSourcePersister.class);

    protected AbstractNonRdfSourcePersister(Class<? extends ResourceOperation> resourceOperation, ResourceOperationType resourceOperationType, FedoraToOcflObjectIndex index) {
        super(resourceOperation, resourceOperationType, index);
    }

    protected void persistNonRDFSource(ResourceOperation operation, OcflObjectSession objectSession, FedoraId rootIdentifier, boolean isArchivalPart) throws PersistentStorageException {
        FedoraId resourceId = operation.getResourceId();
        log.debug("persisting NonRDFSource {} to OCFL", (Object)resourceId);
        NonRdfSourceOperation nonRdfSourceOperation = (NonRdfSourceOperation)operation;
        ResourceHeadersAdapter headers = new ResourceHeadersAdapter(this.createHeaders(objectSession, nonRdfSourceOperation, resourceId.equals((Object)rootIdentifier), (FedoraId)(isArchivalPart ? rootIdentifier : null)));
        headers.setDeleted(false);
        if (this.forExternalBinary(nonRdfSourceOperation)) {
            objectSession.writeResource(headers.asStorageHeaders(), null);
        } else {
            Collection providedDigests = nonRdfSourceOperation.getContentDigests();
            MultiDigestInputStreamWrapper multiDigestWrapper = new MultiDigestInputStreamWrapper(nonRdfSourceOperation.getContentStream(), providedDigests, Collections.emptyList());
            InputStream contentStream = multiDigestWrapper.getInputStream();
            objectSession.writeResource(headers.asStorageHeaders(), (InputStream)new BufferedInputStream(contentStream));
            if (!CollectionUtils.isEmpty((Collection)providedDigests)) {
                multiDigestWrapper.checkFixity();
            }
        }
    }

    private ResourceHeadersImpl createHeaders(OcflObjectSession objSession, NonRdfSourceOperation op, boolean objectRoot, FedoraId archivalGroupId) throws PersistentStorageException {
        ResourceHeadersImpl headers = this.createCommonHeaders(objSession, (ResourceOperation)op, objectRoot, archivalGroupId);
        ResourceHeaderUtils.populateBinaryHeaders((ResourceHeadersImpl)headers, (String)op.getMimeType(), (String)op.getFilename(), (long)op.getContentSize(), (Collection)op.getContentDigests());
        if (this.forExternalBinary(op)) {
            headers.setContentPath(null);
            ResourceHeaderUtils.populateExternalBinaryHeaders((ResourceHeadersImpl)headers, (String)op.getContentUri().toString(), (String)op.getExternalHandling());
        } else if (!ResourceOperationType.CREATE.equals((Object)op.getType())) {
            headers.setExternalHandling(null);
            headers.setExternalUrl(null);
        }
        return headers;
    }

    protected boolean forExternalBinary(NonRdfSourceOperation op) {
        return op.getContentUri() != null && op.getExternalHandling() != null;
    }
}

