/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.fcrepo.common.db.DbPlatform;
import org.fcrepo.config.OcflPropsConfig;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.InvalidResourceIdentifierException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.persistence.ocfl.api.FedoraOcflMappingNotFoundException;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.FedoraOcflMapping;
import org.fcrepo.storage.ocfl.cache.CaffeineCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="ocflIndexImpl")
public class DbFedoraToOcflObjectIndex
implements FedoraToOcflObjectIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbFedoraToOcflObjectIndex.class);
    private static final String MAPPING_TABLE = "ocfl_id_map";
    private static final String FEDORA_ID_COLUMN = "fedora_id";
    private static final String FEDORA_ROOT_ID_COLUMN = "fedora_root_id";
    private static final String OCFL_ID_COLUMN = "ocfl_id";
    private static final String TRANSACTION_OPERATIONS_TABLE = "ocfl_id_map_session_operations";
    private static final String TRANSACTION_ID_COLUMN = "session_id";
    private static final String OPERATION_COLUMN = "operation";
    private static final String LOOKUP_MAPPING = "SELECT fedora_root_id, ocfl_id FROM ocfl_id_map WHERE fedora_id = :fedoraId";
    private static final String LOOKUP_MAPPING_IN_TRANSACTION = "SELECT x.fedora_root_id, x.ocfl_id FROM (SELECT fedora_root_id, ocfl_id FROM ocfl_id_map WHERE fedora_id = :fedoraId UNION SELECT fedora_root_id, ocfl_id FROM ocfl_id_map_session_operations WHERE fedora_id = :fedoraId AND session_id = :transactionId AND operation = 'add') x";
    private static final String UPSERT_MAPPING_TX_POSTGRESQL = "INSERT INTO ocfl_id_map_session_operations ( fedora_id, fedora_root_id, ocfl_id, session_id, operation) VALUES (:fedoraId, :fedoraRootId, :ocflId, :transactionId, :operation) ON CONFLICT (fedora_id, session_id) DO UPDATE SET fedora_root_id = EXCLUDED.fedora_root_id, ocfl_id = EXCLUDED.ocfl_id, operation = EXCLUDED.operation";
    private static final String UPSERT_MAPPING_TX_MYSQL_MARIA = "INSERT INTO ocfl_id_map_session_operations (fedora_id, fedora_root_id, ocfl_id, session_id, operation) VALUES (:fedoraId, :fedoraRootId, :ocflId, :transactionId, :operation) ON DUPLICATE KEY UPDATE fedora_root_id = VALUES(fedora_root_id), ocfl_id = VALUES(ocfl_id), operation = VALUES(operation)";
    private static final String UPSERT_MAPPING_TX_H2 = "MERGE INTO ocfl_id_map_session_operations (fedora_id, fedora_root_id, ocfl_id, session_id, operation) KEY (fedora_id, session_id) VALUES (:fedoraId, :fedoraRootId, :ocflId, :transactionId, :operation)";
    private static final String DIRECT_INSERT_MAPPING = "INSERT INTO ocfl_id_map (fedora_id, fedora_root_id, ocfl_id) VALUES (:fedoraId, :fedoraRootId, :ocflId)";
    private static final Map<DbPlatform, String> UPSERT_MAPPING_TX_MAP = Map.of(DbPlatform.MYSQL, "INSERT INTO ocfl_id_map_session_operations (fedora_id, fedora_root_id, ocfl_id, session_id, operation) VALUES (:fedoraId, :fedoraRootId, :ocflId, :transactionId, :operation) ON DUPLICATE KEY UPDATE fedora_root_id = VALUES(fedora_root_id), ocfl_id = VALUES(ocfl_id), operation = VALUES(operation)", DbPlatform.H2, "MERGE INTO ocfl_id_map_session_operations (fedora_id, fedora_root_id, ocfl_id, session_id, operation) KEY (fedora_id, session_id) VALUES (:fedoraId, :fedoraRootId, :ocflId, :transactionId, :operation)", DbPlatform.POSTGRESQL, "INSERT INTO ocfl_id_map_session_operations ( fedora_id, fedora_root_id, ocfl_id, session_id, operation) VALUES (:fedoraId, :fedoraRootId, :ocflId, :transactionId, :operation) ON CONFLICT (fedora_id, session_id) DO UPDATE SET fedora_root_id = EXCLUDED.fedora_root_id, ocfl_id = EXCLUDED.ocfl_id, operation = EXCLUDED.operation", DbPlatform.MARIADB, "INSERT INTO ocfl_id_map_session_operations (fedora_id, fedora_root_id, ocfl_id, session_id, operation) VALUES (:fedoraId, :fedoraRootId, :ocflId, :transactionId, :operation) ON DUPLICATE KEY UPDATE fedora_root_id = VALUES(fedora_root_id), ocfl_id = VALUES(ocfl_id), operation = VALUES(operation)");
    private static final String DIRECT_DELETE_MAPPING = "DELETE FROM ocfl_id_map WHERE fedora_id = :fedoraId";
    private static final String COMMIT_ADD_MAPPING_POSTGRESQL = "INSERT INTO ocfl_id_map ( fedora_id, fedora_root_id, ocfl_id) SELECT fedora_id, fedora_root_id, ocfl_id FROM ocfl_id_map_session_operations WHERE operation = 'add' AND session_id = :transactionId ON CONFLICT ( fedora_id ) DO UPDATE SET fedora_root_id = EXCLUDED.fedora_root_id, ocfl_id = EXCLUDED.ocfl_id";
    private static final String COMMIT_ADD_MAPPING_MYSQL_MARIA = "INSERT INTO ocfl_id_map (fedora_id, fedora_root_id, ocfl_id) SELECT fedora_id, fedora_root_id, ocfl_id FROM ocfl_id_map_session_operations WHERE operation = 'add' AND session_id = :transactionId ON DUPLICATE KEY UPDATE fedora_root_id = VALUES(fedora_root_id), ocfl_id = VALUES(ocfl_id)";
    private static final String COMMIT_ADD_MAPPING_H2 = "MERGE INTO ocfl_id_map (fedora_id, fedora_root_id, ocfl_id) SELECT fedora_id, fedora_root_id, ocfl_id FROM ocfl_id_map_session_operations WHERE operation = 'add'";
    private static final Map<DbPlatform, String> COMMIT_ADD_MAPPING_MAP = Map.of(DbPlatform.MYSQL, "INSERT INTO ocfl_id_map (fedora_id, fedora_root_id, ocfl_id) SELECT fedora_id, fedora_root_id, ocfl_id FROM ocfl_id_map_session_operations WHERE operation = 'add' AND session_id = :transactionId ON DUPLICATE KEY UPDATE fedora_root_id = VALUES(fedora_root_id), ocfl_id = VALUES(ocfl_id)", DbPlatform.H2, "MERGE INTO ocfl_id_map (fedora_id, fedora_root_id, ocfl_id) SELECT fedora_id, fedora_root_id, ocfl_id FROM ocfl_id_map_session_operations WHERE operation = 'add'", DbPlatform.POSTGRESQL, "INSERT INTO ocfl_id_map ( fedora_id, fedora_root_id, ocfl_id) SELECT fedora_id, fedora_root_id, ocfl_id FROM ocfl_id_map_session_operations WHERE operation = 'add' AND session_id = :transactionId ON CONFLICT ( fedora_id ) DO UPDATE SET fedora_root_id = EXCLUDED.fedora_root_id, ocfl_id = EXCLUDED.ocfl_id", DbPlatform.MARIADB, "INSERT INTO ocfl_id_map (fedora_id, fedora_root_id, ocfl_id) SELECT fedora_id, fedora_root_id, ocfl_id FROM ocfl_id_map_session_operations WHERE operation = 'add' AND session_id = :transactionId ON DUPLICATE KEY UPDATE fedora_root_id = VALUES(fedora_root_id), ocfl_id = VALUES(ocfl_id)");
    private static final String COMMIT_DELETE_RECORDS = "DELETE FROM ocfl_id_map WHERE EXISTS (SELECT * FROM ocfl_id_map_session_operations WHERE session_id = :transactionId AND operation = 'delete' AND ocfl_id_map.fedora_id = ocfl_id_map_session_operations.fedora_id)";
    private static final String GET_DELETE_IDS = "SELECT fedora_id FROM ocfl_id_map_session_operations WHERE session_id = :transactionId AND operation = 'delete'";
    private static final String TRUNCATE_MAPPINGS = "TRUNCATE TABLE ocfl_id_map";
    private static final String TRUNCATE_TRANSACTIONS = "TRUNCATE TABLE ocfl_id_map_session_operations";
    private static final String DELETE_ENTIRE_TRANSACTION = "DELETE FROM ocfl_id_map_session_operations WHERE session_id = :transactionId";
    private static final RowMapper<FedoraOcflMapping> GET_MAPPING_ROW_MAPPER = (resultSet, i) -> new FedoraOcflMapping(FedoraId.create((String[])new String[]{resultSet.getString(1)}), resultSet.getString(2));
    private org.fcrepo.storage.ocfl.cache.Cache<String, FedoraOcflMapping> mappingCache;
    private final DataSource dataSource;
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private DbPlatform dbPlatform;
    @Inject
    private OcflPropsConfig ocflPropsConfig;

    public DbFedoraToOcflObjectIndex(@Autowired DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    @PostConstruct
    public void setup() {
        this.dbPlatform = DbPlatform.fromDataSource((DataSource)this.dataSource);
        Cache cache = Caffeine.newBuilder().maximumSize(this.ocflPropsConfig.getFedoraToOcflCacheSize()).expireAfterAccess(this.ocflPropsConfig.getFedoraToOcflCacheTimeout(), TimeUnit.MINUTES).build();
        this.mappingCache = new CaffeineCache(cache);
    }

    @Override
    public FedoraOcflMapping getMapping(Transaction transaction, FedoraId fedoraId) throws FedoraOcflMappingNotFoundException {
        try {
            if (transaction.isOpenLongRunning()) {
                MapSqlParameterSource parameterSource = new MapSqlParameterSource();
                parameterSource.addValue("fedoraId", (Object)fedoraId.getResourceId());
                parameterSource.addValue("transactionId", (Object)transaction.getId());
                return (FedoraOcflMapping)this.jdbcTemplate.queryForObject(LOOKUP_MAPPING_IN_TRANSACTION, (SqlParameterSource)parameterSource, GET_MAPPING_ROW_MAPPER);
            }
            return (FedoraOcflMapping)this.mappingCache.get((Object)fedoraId.getResourceId(), key -> (FedoraOcflMapping)this.jdbcTemplate.queryForObject(LOOKUP_MAPPING, Map.of("fedoraId", key), GET_MAPPING_ROW_MAPPER));
        }
        catch (EmptyResultDataAccessException e) {
            throw new FedoraOcflMappingNotFoundException("No OCFL mapping found for " + fedoraId);
        }
    }

    @Override
    public FedoraOcflMapping addMapping(@Nonnull Transaction transaction, FedoraId fedoraId, FedoraId fedoraRootId, String ocflId) {
        transaction.doInTx(() -> {
            if (!transaction.isShortLived()) {
                this.upsert(transaction, fedoraId, "add", fedoraRootId, ocflId);
            } else {
                this.directInsert(fedoraId, fedoraRootId, ocflId);
            }
        });
        return new FedoraOcflMapping(fedoraRootId, ocflId);
    }

    @Override
    public void removeMapping(@Nonnull Transaction transaction, FedoraId fedoraId) {
        transaction.doInTx(() -> {
            if (!transaction.isShortLived()) {
                this.upsert(transaction, fedoraId, "delete");
            } else {
                MapSqlParameterSource parameterSource = new MapSqlParameterSource();
                parameterSource.addValue("fedoraId", (Object)fedoraId.getResourceId());
                this.jdbcTemplate.update(DIRECT_DELETE_MAPPING, (SqlParameterSource)parameterSource);
                this.mappingCache.invalidate((Object)fedoraId.getResourceId());
            }
        });
    }

    private void upsert(Transaction transaction, FedoraId fedoraId, String operation) {
        this.upsert(transaction, fedoraId, operation, null, null);
    }

    private void upsert(Transaction transaction, FedoraId fedoraId, String operation, FedoraId fedoraRootId, String ocflId) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("fedoraId", (Object)fedoraId.getResourceId());
        parameterSource.addValue("fedoraRootId", (Object)(fedoraRootId == null ? null : fedoraRootId.getResourceId()));
        parameterSource.addValue("ocflId", (Object)ocflId);
        parameterSource.addValue("transactionId", (Object)transaction.getId());
        parameterSource.addValue(OPERATION_COLUMN, (Object)operation);
        try {
            this.jdbcTemplate.update(UPSERT_MAPPING_TX_MAP.get(this.dbPlatform), (SqlParameterSource)parameterSource);
        }
        catch (DataIntegrityViolationException | BadSqlGrammarException e) {
            this.handleInsertException(fedoraId, (Exception)e);
        }
    }

    private void directInsert(FedoraId fedoraId, FedoraId fedoraRootId, String ocflId) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("fedoraId", (Object)fedoraId.getResourceId());
        parameterSource.addValue("fedoraRootId", (Object)(fedoraRootId == null ? null : fedoraRootId.getResourceId()));
        parameterSource.addValue("ocflId", (Object)ocflId);
        try {
            this.jdbcTemplate.update(DIRECT_INSERT_MAPPING, (SqlParameterSource)parameterSource);
        }
        catch (DataIntegrityViolationException | BadSqlGrammarException e) {
            this.handleInsertException(fedoraId, (Exception)e);
        }
    }

    @Override
    public void reset() {
        try {
            this.jdbcTemplate.update(TRUNCATE_MAPPINGS, Collections.emptyMap());
            this.jdbcTemplate.update(TRUNCATE_TRANSACTIONS, Collections.emptyMap());
            this.mappingCache.invalidateAll();
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException("Failed to truncate FedoraToOcfl index tables", (Throwable)e);
        }
    }

    @Override
    public void commit(@Nonnull Transaction transaction) {
        if (!transaction.isShortLived()) {
            transaction.ensureCommitting();
            LOGGER.debug("Committing FedoraToOcfl index changes from transaction {}", (Object)transaction.getId());
            Map<String, String> map = Map.of("transactionId", transaction.getId());
            try {
                List deleteIds = this.jdbcTemplate.queryForList(GET_DELETE_IDS, map, String.class);
                this.jdbcTemplate.update(COMMIT_DELETE_RECORDS, map);
                this.jdbcTemplate.update(COMMIT_ADD_MAPPING_MAP.get(this.dbPlatform), map);
                this.jdbcTemplate.update(DELETE_ENTIRE_TRANSACTION, map);
                this.mappingCache.invalidateAll((Iterable)deleteIds);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to commit FedoraToOcfl index transaction {}: {}", (Object)transaction, (Object)e.getMessage());
                throw new RepositoryRuntimeException("Unable to commit FedoraToOcfl index transaction", (Throwable)e);
            }
        }
    }

    @Override
    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void rollback(@Nonnull Transaction transaction) {
        if (!transaction.isShortLived()) {
            this.jdbcTemplate.update(DELETE_ENTIRE_TRANSACTION, Map.of("transactionId", transaction.getId()));
        }
    }

    private void handleInsertException(FedoraId fedoraId, Exception e) {
        if (e.getMessage().contains("too long for")) {
            throw new InvalidResourceIdentifierException("Database error - Fedora ID path too long", e);
        }
        if (e instanceof DuplicateKeyException) {
            throw new RepositoryRuntimeException("Database error - primary key already exists for Fedora ID: " + fedoraId, (Throwable)e);
        }
        throw new RepositoryRuntimeException("Database error - error during upsert", (Throwable)e);
    }
}

