/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.AbstractPersister;
import org.fcrepo.persistence.ocfl.impl.FedoraOcflMapping;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSession;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PurgeResourcePersister
extends AbstractPersister {
    private static final Logger log = LoggerFactory.getLogger(PurgeResourcePersister.class);

    protected PurgeResourcePersister(FedoraToOcflObjectIndex fedoraOcflIndex) {
        super(ResourceOperation.class, ResourceOperationType.PURGE, fedoraOcflIndex);
    }

    @Override
    public void persist(OcflPersistentStorageSession session, ResourceOperation operation) throws PersistentStorageException {
        FedoraOcflMapping mapping = this.getMapping(operation.getTransaction(), operation.getResourceId());
        FedoraId resourceId = operation.getResourceId();
        OcflObjectSession objectSession = session.findOrCreateSession(mapping.getOcflObjectId());
        log.debug("Deleting {} from {}", (Object)resourceId, (Object)mapping.getOcflObjectId());
        try {
            objectSession.deleteResource(resourceId.getResourceId());
        }
        catch (RuntimeException e) {
            throw new PersistentStorageException(String.format("Purge resource %s failed", resourceId), (Throwable)e);
        }
        this.ocflIndex.removeMapping(operation.getTransaction(), resourceId.asResourceId());
    }
}

