/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.NonRdfSourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.AbstractNonRdfSourcePersister;
import org.fcrepo.persistence.ocfl.impl.FedoraOcflMapping;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSession;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateNonRdfSourcePersister
extends AbstractNonRdfSourcePersister {
    private static final Logger log = LoggerFactory.getLogger(UpdateNonRdfSourcePersister.class);

    protected UpdateNonRdfSourcePersister(FedoraToOcflObjectIndex index) {
        super(NonRdfSourceOperation.class, ResourceOperationType.UPDATE, index);
    }

    @Override
    public void persist(OcflPersistentStorageSession session, ResourceOperation operation) throws PersistentStorageException {
        ResourceHeaders headers;
        FedoraId resourceId = operation.getResourceId();
        log.debug("persisting {} to {}", (Object)resourceId, (Object)session);
        FedoraOcflMapping mapping = this.getMapping(operation.getTransaction(), resourceId);
        FedoraId rootIdentifier = mapping.getRootObjectIdentifier();
        log.debug("retrieved mapping: {}", (Object)mapping);
        OcflObjectSession objSession = session.findOrCreateSession(mapping.getOcflObjectId());
        if (this.forExternalBinary((NonRdfSourceOperation)operation) && (headers = objSession.readHeaders(resourceId.getResourceId())).getExternalUrl() == null) {
            objSession.deleteContentFile(ResourceHeaders.builder((ResourceHeaders)headers).withDeleted(true).build());
        }
        this.persistNonRDFSource(operation, objSession, rootIdentifier, false);
    }
}

