/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWriter;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.RdfSourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.common.ResourceHeadersImpl;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.AbstractPersister;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageUtils;
import org.fcrepo.persistence.ocfl.impl.ResourceHeadersAdapter;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRdfSourcePersister
extends AbstractPersister {
    private static final Logger log = LoggerFactory.getLogger(AbstractRdfSourcePersister.class);

    protected AbstractRdfSourcePersister(Class<? extends ResourceOperation> resourceOperation, ResourceOperationType resourceOperationType, FedoraToOcflObjectIndex index) {
        super(resourceOperation, resourceOperationType, index);
    }

    protected void persistRDF(OcflObjectSession objectSession, ResourceOperation operation, FedoraId rootId, boolean isArchivalPart) throws PersistentStorageException {
        RdfSourceOperation rdfSourceOp = (RdfSourceOperation)operation;
        log.debug("persisting RDFSource ({}) to OCFL", (Object)operation.getResourceId());
        ResourceHeadersImpl headers = this.createHeaders(objectSession, rdfSourceOp, operation.getResourceId().equals((Object)rootId), (FedoraId)(isArchivalPart ? rootId : null));
        this.writeRdf(objectSession, headers, rdfSourceOp.getTriples());
    }

    private ResourceHeadersImpl createHeaders(OcflObjectSession objSession, RdfSourceOperation operation, boolean objectRoot, FedoraId archivalGroupId) throws PersistentStorageException {
        ResourceHeadersImpl headers = this.createCommonHeaders(objSession, (ResourceOperation)operation, objectRoot, archivalGroupId);
        this.overrideRelaxedProperties(headers, operation);
        return headers;
    }

    private void overrideRelaxedProperties(ResourceHeadersImpl headers, RdfSourceOperation operation) {
        if (operation.getLastModifiedBy() != null) {
            headers.setLastModifiedBy(operation.getLastModifiedBy());
        }
        if (operation.getLastModifiedDate() != null) {
            headers.setLastModifiedDate(operation.getLastModifiedDate());
        }
        if (operation.getCreatedBy() != null) {
            headers.setCreatedBy(operation.getCreatedBy());
        }
        if (operation.getCreatedDate() != null) {
            headers.setCreatedDate(operation.getCreatedDate());
        }
    }

    private void writeRdf(OcflObjectSession session, ResourceHeadersImpl headers, RdfStream triples) throws PersistentStorageException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            StreamRDF streamRDF = StreamRDFWriter.getWriterStream((OutputStream)os, (Lang)OcflPersistentStorageUtils.getRdfFormat().getLang());
            streamRDF.start();
            if (triples != null) {
                triples.forEach(arg_0 -> ((StreamRDF)streamRDF).triple(arg_0));
            }
            streamRDF.finish();
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            session.writeResource(new ResourceHeadersAdapter(headers).asStorageHeaders(), (InputStream)is);
            log.debug("wrote {} to {}", (Object)headers.getId().getFullId(), (Object)session.sessionId());
        }
        catch (IOException ex) {
            throw new PersistentStorageException(String.format("failed to write %s in %s", headers.getId().getFullId(), session.sessionId()), (Throwable)ex);
        }
    }
}

