/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.exceptions.PersistentItemNotFoundException;
import org.fcrepo.persistence.api.exceptions.PersistentSessionClosedException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.ocfl.api.FedoraOcflMappingNotFoundException;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.api.Persister;
import org.fcrepo.persistence.ocfl.impl.CreateNonRdfSourcePersister;
import org.fcrepo.persistence.ocfl.impl.CreateRdfSourcePersister;
import org.fcrepo.persistence.ocfl.impl.CreateVersionPersister;
import org.fcrepo.persistence.ocfl.impl.DeleteResourcePersister;
import org.fcrepo.persistence.ocfl.impl.FcrepoOcflObjectSessionWrapper;
import org.fcrepo.persistence.ocfl.impl.FedoraOcflMapping;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageUtils;
import org.fcrepo.persistence.ocfl.impl.PurgeResourcePersister;
import org.fcrepo.persistence.ocfl.impl.ReindexResourcePersister;
import org.fcrepo.persistence.ocfl.impl.ReindexService;
import org.fcrepo.persistence.ocfl.impl.ResourceHeadersAdapter;
import org.fcrepo.persistence.ocfl.impl.UpdateNonRdfSourceHeadersPersister;
import org.fcrepo.persistence.ocfl.impl.UpdateNonRdfSourcePersister;
import org.fcrepo.persistence.ocfl.impl.UpdateRdfSourcePersister;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.OcflVersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcflPersistentStorageSession
implements PersistentStorageSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcflPersistentStorageSession.class);
    private static final long AWAIT_TIMEOUT = 30000L;
    private final Transaction transaction;
    private final FedoraToOcflObjectIndex fedoraOcflIndex;
    private final Map<String, OcflObjectSession> sessionMap;
    private final ReindexService reindexSerivce;
    private Map<String, OcflObjectSession> sessionsToRollback;
    private final Phaser phaser = new Phaser();
    private final List<Persister> persisterList = new ArrayList<Persister>();
    private State state = State.COMMIT_NOT_STARTED;
    private final OcflObjectSessionFactory objectSessionFactory;

    protected OcflPersistentStorageSession(Transaction tx, FedoraToOcflObjectIndex fedoraOcflIndex, OcflObjectSessionFactory objectSessionFactory, ReindexService reindexService) {
        this.transaction = tx;
        this.fedoraOcflIndex = fedoraOcflIndex;
        this.objectSessionFactory = objectSessionFactory;
        this.reindexSerivce = reindexService;
        this.sessionsToRollback = new HashMap<String, OcflObjectSession>();
        this.sessionMap = !tx.isReadOnly() ? new ConcurrentHashMap<String, OcflObjectSession>() : Caffeine.newBuilder().maximumSize(512L).expireAfterAccess(10L, TimeUnit.MINUTES).build().asMap();
        this.persisterList.add(new CreateRdfSourcePersister(this.fedoraOcflIndex));
        this.persisterList.add(new UpdateRdfSourcePersister(this.fedoraOcflIndex));
        this.persisterList.add(new UpdateNonRdfSourceHeadersPersister(this.fedoraOcflIndex));
        this.persisterList.add(new CreateNonRdfSourcePersister(this.fedoraOcflIndex));
        this.persisterList.add(new UpdateNonRdfSourcePersister(this.fedoraOcflIndex));
        this.persisterList.add(new DeleteResourcePersister(this.fedoraOcflIndex));
        this.persisterList.add(new CreateVersionPersister(this.fedoraOcflIndex));
        this.persisterList.add(new PurgeResourcePersister(this.fedoraOcflIndex));
        this.persisterList.add(new ReindexResourcePersister(this.reindexSerivce));
    }

    public String getId() {
        return this.transaction.getId();
    }

    public void persist(ResourceOperation operation) throws PersistentStorageException {
        this.actionNeedsWrite();
        this.ensureCommitNotStarted();
        try {
            this.phaser.register();
            Persister persister = this.persisterList.stream().filter(p -> p.handle(operation)).findFirst().orElse(null);
            if (persister == null) {
                throw new UnsupportedOperationException(String.format("The %s is not yet supported", operation.getClass()));
            }
            persister.persist(this, operation);
        }
        finally {
            this.phaser.arriveAndDeregister();
        }
    }

    private void ensureCommitNotStarted() throws PersistentSessionClosedException {
        if (!this.state.equals((Object)State.COMMIT_NOT_STARTED)) {
            throw new PersistentSessionClosedException(String.format("Storage session %s is already closed", this.transaction));
        }
    }

    private void ensurePrepared() throws PersistentSessionClosedException {
        if (!this.state.equals((Object)State.PREPARED)) {
            throw new PersistentStorageException(String.format("Storage session %s cannot be committed because it is not in the correct state: %s", new Object[]{this.transaction, this.state}));
        }
    }

    OcflObjectSession findOrCreateSession(String ocflId) {
        return this.sessionMap.computeIfAbsent(ocflId, key -> new FcrepoOcflObjectSessionWrapper(this.objectSessionFactory.newSession(key)));
    }

    public ResourceHeaders getHeaders(FedoraId identifier, Instant version) throws PersistentStorageException {
        this.ensureCommitNotStarted();
        FedoraOcflMapping mapping = this.getFedoraOcflMapping(identifier);
        OcflObjectSession objSession = this.findOrCreateSession(mapping.getOcflObjectId());
        String versionId = this.resolveVersionNumber(objSession, identifier, version);
        org.fcrepo.storage.ocfl.ResourceHeaders headers = objSession.readHeaders(identifier.getResourceId(), versionId);
        return new ResourceHeadersAdapter(headers).asKernelHeaders();
    }

    private FedoraOcflMapping getFedoraOcflMapping(FedoraId identifier) throws PersistentStorageException {
        try {
            return this.fedoraOcflIndex.getMapping(this.transaction, identifier);
        }
        catch (FedoraOcflMappingNotFoundException e) {
            throw new PersistentItemNotFoundException(String.format("Resource %s not found", identifier.getFullIdPath()), (Throwable)e);
        }
    }

    public RdfStream getTriples(FedoraId identifier, Instant version) throws PersistentStorageException {
        RdfStream rdfStream;
        block8: {
            this.ensureCommitNotStarted();
            LOGGER.debug("Getting triples for {} at {}", (Object)identifier, (Object)version);
            InputStream is = this.getBinaryContent(identifier, version);
            try {
                Model model = ModelFactory.createDefaultModel();
                RDFDataMgr.read((Model)model, (InputStream)is, (Lang)OcflPersistentStorageUtils.getRdfFormat().getLang());
                FedoraId topic = this.resolveTopic(identifier);
                rdfStream = DefaultRdfStream.fromModel((Node)NodeFactory.createURI((String)topic.getFullId()), (Model)model);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new PersistentStorageException(String.format("unable to read %s ;  version = %s", identifier, version), (Throwable)ex);
                }
            }
            is.close();
        }
        return rdfStream;
    }

    public List<Instant> listVersions(FedoraId fedoraIdentifier) throws PersistentStorageException {
        FedoraOcflMapping mapping = this.getFedoraOcflMapping(fedoraIdentifier);
        OcflObjectSession objSession = this.findOrCreateSession(mapping.getOcflObjectId());
        return objSession.listVersions(fedoraIdentifier.getResourceId()).stream().map(OcflVersionInfo::getCreated).collect(Collectors.toList());
    }

    public InputStream getBinaryContent(FedoraId identifier, Instant version) throws PersistentStorageException {
        this.ensureCommitNotStarted();
        FedoraOcflMapping mapping = this.getFedoraOcflMapping(identifier);
        OcflObjectSession objSession = this.findOrCreateSession(mapping.getOcflObjectId());
        String versionNumber = this.resolveVersionNumber(objSession, identifier, version);
        return (InputStream)objSession.readContent(identifier.getResourceId(), versionNumber).getContentStream().orElseThrow(() -> new PersistentItemNotFoundException("No binary content found for resource " + identifier.getFullId()));
    }

    public synchronized void prepare() {
        this.ensureCommitNotStarted();
        if (this.isReadOnly()) {
            return;
        }
        this.state = State.PREPARE_STARTED;
        LOGGER.debug("Starting storage session {} prepare for commit", (Object)this.transaction);
        if (this.phaser.getRegisteredParties() > 0) {
            this.phaser.awaitAdvance(0);
        }
        LOGGER.trace("All persisters are complete in session {}", (Object)this.transaction);
        try {
            this.fedoraOcflIndex.commit(this.transaction);
            this.state = State.PREPARED;
        }
        catch (RuntimeException e) {
            this.state = State.PREPARE_FAILED;
            throw new PersistentStorageException(String.format("Failed to prepare storage session <%s> for commit", this.transaction), (Throwable)e);
        }
    }

    public synchronized void commit() throws PersistentStorageException {
        this.ensurePrepared();
        if (this.isReadOnly()) {
            return;
        }
        this.state = State.COMMIT_STARTED;
        LOGGER.debug("Starting storage session {} commit", (Object)this.transaction);
        TreeMap<String, OcflObjectSession> sessions = new TreeMap<String, OcflObjectSession>(this.sessionMap);
        this.commitObjectSessions(sessions);
        LOGGER.debug("Committed storage session {}", (Object)this.transaction);
    }

    private void commitObjectSessions(Map<String, OcflObjectSession> sessions) throws PersistentStorageException {
        this.sessionsToRollback = new HashMap<String, OcflObjectSession>(this.sessionMap.size());
        for (Map.Entry<String, OcflObjectSession> entry : sessions.entrySet()) {
            String id = entry.getKey();
            OcflObjectSession session = entry.getValue();
            try {
                session.commit();
                this.sessionsToRollback.put(id, session);
            }
            catch (Exception e) {
                this.state = State.COMMIT_FAILED;
                throw new PersistentStorageException(String.format("Failed to commit object <%s> in session <%s>", id, this.transaction), (Throwable)e);
            }
        }
        this.state = State.COMMITTED;
    }

    public void rollback() throws PersistentStorageException {
        if (this.isReadOnly()) {
            return;
        }
        if (!this.state.rollbackAllowed) {
            throw new PersistentStorageException("This session cannot be rolled back in this state: " + this.state);
        }
        boolean commitWasStarted = this.state != State.COMMIT_NOT_STARTED;
        this.state = State.ROLLING_BACK;
        LOGGER.debug("Rolling back storage session {}", (Object)this.transaction);
        if (!commitWasStarted && this.phaser.getRegisteredParties() > 0) {
            try {
                this.phaser.awaitAdvanceInterruptibly(0, 30000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | TimeoutException e) {
                throw new PersistentStorageException("Waiting for operations to complete took too long, rollback failed");
            }
        }
        this.closeUncommittedSessions();
        if (commitWasStarted) {
            this.rollbackCommittedSessions();
        }
        this.state = State.ROLLED_BACK;
        LOGGER.trace("Successfully rolled back storage session {}", (Object)this.transaction);
    }

    private String resolveVersionNumber(OcflObjectSession objSession, FedoraId fedoraId, Instant version) throws PersistentStorageException {
        if (version != null) {
            List versions = objSession.listVersions(fedoraId.getResourceId());
            Collections.reverse(versions);
            return versions.stream().filter(vd -> vd.getCreated().equals(version)).map(OcflVersionInfo::getVersionNumber).findFirst().orElseThrow(() -> new PersistentItemNotFoundException(String.format("There is no version in %s with a created date matching %s", fedoraId, version)));
        }
        return null;
    }

    private void closeUncommittedSessions() {
        this.sessionMap.entrySet().stream().filter(entry -> !this.sessionsToRollback.containsKey(entry.getKey())).map(Map.Entry::getValue).forEach(OcflObjectSession::abort);
    }

    private void rollbackCommittedSessions() throws PersistentStorageException {
        ArrayList<String> rollbackFailures = new ArrayList<String>(this.sessionsToRollback.size());
        for (Map.Entry<String, OcflObjectSession> entry : this.sessionsToRollback.entrySet()) {
            String id = entry.getKey();
            OcflObjectSession session = entry.getValue();
            try {
                session.rollback();
            }
            catch (Exception e) {
                rollbackFailures.add(String.format("Failed to rollback object <%s> in session <%s>: %s", id, session.sessionId(), e.getMessage()));
            }
        }
        try {
            this.fedoraOcflIndex.rollback(this.transaction);
        }
        catch (Exception e) {
            rollbackFailures.add(String.format("Failed to rollback OCFL index updates in transaction <%s>: %s", this.transaction, e.getMessage()));
        }
        if (rollbackFailures.size() > 0) {
            this.state = State.ROLLBACK_FAILED;
            StringBuilder builder = new StringBuilder().append("Unable to rollback storage session ").append(this.transaction).append(" completely due to the following errors: \n");
            for (String failures : rollbackFailures) {
                builder.append("\t").append(failures).append("\n");
            }
            throw new PersistentStorageException(builder.toString());
        }
    }

    private boolean isReadOnly() {
        return this.transaction.isReadOnly();
    }

    private void actionNeedsWrite() throws PersistentStorageException {
        if (this.isReadOnly()) {
            throw new PersistentStorageException("Session is read-only");
        }
    }

    private FedoraId resolveTopic(FedoraId fedoraIdentifier) {
        if (fedoraIdentifier.isDescription()) {
            return fedoraIdentifier.asBaseId();
        }
        return fedoraIdentifier;
    }

    public String toString() {
        return "OcflPersistentStorageSession{sessionId='" + this.transaction + "', state=" + this.state + "}";
    }

    private static enum State {
        COMMIT_NOT_STARTED(true),
        PREPARE_STARTED(false),
        PREPARED(true),
        PREPARE_FAILED(true),
        COMMIT_STARTED(false),
        COMMITTED(true),
        COMMIT_FAILED(true),
        ROLLING_BACK(false),
        ROLLED_BACK(false),
        ROLLBACK_FAILED(false);

        final boolean rollbackAllowed;

        private State(boolean rollbackAllowed) {
            this.rollbackAllowed = rollbackAllowed;
        }
    }
}

