/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import edu.wisc.library.ocfl.api.OcflRepository;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.services.MembershipService;
import org.fcrepo.kernel.api.services.ReferenceService;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageUtils;
import org.fcrepo.persistence.ocfl.impl.ResourceHeadersAdapter;
import org.fcrepo.search.api.Condition;
import org.fcrepo.search.api.InvalidQueryException;
import org.fcrepo.search.api.SearchIndex;
import org.fcrepo.search.api.SearchParameters;
import org.fcrepo.search.api.SearchResult;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.validation.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ReindexService {
    @Inject
    private PersistentStorageSessionManager persistentStorageSessionManager;
    @Inject
    private OcflObjectSessionFactory ocflObjectSessionFactory;
    @Autowired
    @Qualifier(value="ocflIndex")
    private FedoraToOcflObjectIndex ocflIndex;
    @Autowired
    private OcflRepository ocflRepository;
    @Autowired
    @Qualifier(value="containmentIndex")
    private ContainmentIndex containmentIndex;
    @Autowired
    @Qualifier(value="searchIndex")
    private SearchIndex searchIndex;
    @Autowired
    @Qualifier(value="referenceService")
    private ReferenceService referenceService;
    @Inject
    private MembershipService membershipService;
    @Inject
    private ObjectValidator objectValidator;
    @Inject
    private FedoraPropsConfig config;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReindexService.class);
    private int membershipPageSize = 500;

    public void indexOcflObject(Transaction tx, String ocflId) {
        LOGGER.debug("Indexing ocflId {} in transaction {}", (Object)ocflId, (Object)tx.getId());
        this.ocflRepository.invalidateCache(ocflId);
        if (this.config.isRebuildValidation()) {
            this.objectValidator.validate(ocflId, this.config.isRebuildFixityCheck());
        }
        try (OcflObjectSession session = this.ocflObjectSessionFactory.newSession(ocflId);){
            AtomicReference rootId = new AtomicReference();
            ArrayList<FedoraId> fedoraIds = new ArrayList<FedoraId>();
            ArrayList<ResourceHeaders> headersList = new ArrayList<ResourceHeaders>();
            session.invalidateCache(ocflId);
            session.streamResourceHeaders().forEach(storageHeaders -> {
                ResourceHeadersAdapter headers = new ResourceHeadersAdapter((org.fcrepo.storage.ocfl.ResourceHeaders)storageHeaders);
                FedoraId fedoraId = headers.getId();
                fedoraIds.add(fedoraId);
                if (headers.isArchivalGroup() || headers.isObjectRoot()) {
                    rootId.set(fedoraId);
                }
                if (!fedoraId.isRepositoryRoot()) {
                    FedoraId parentId = headers.getParent();
                    if (headers.getParent() == null) {
                        if (headers.isObjectRoot()) {
                            parentId = FedoraId.getRepositoryRootId();
                        } else {
                            throw new IllegalStateException(String.format("Resource %s must have a parent defined", fedoraId.getFullId()));
                        }
                    }
                    Instant created = headers.getCreatedDate();
                    if (!headers.isDeleted()) {
                        Optional content;
                        if (!headers.getInteractionModel().equals(RdfLexicon.NON_RDF_SOURCE.toString()) && (content = session.readContent(fedoraId.getFullId()).getContentStream()).isPresent()) {
                            try (InputStream stream = (InputStream)content.get();){
                                RdfStream rdf = ReindexService.parseRdf(fedoraId, stream);
                                this.referenceService.updateReferences(tx, fedoraId, null, rdf);
                            }
                            catch (IOException e) {
                                LOGGER.warn("Content stream for {} closed prematurely, inbound references skipped.", (Object)fedoraId.getFullId());
                                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
                            }
                        }
                        this.containmentIndex.addContainedBy(tx, parentId, fedoraId, created, null);
                        headersList.add((ResourceHeaders)headers.asKernelHeaders());
                    } else {
                        Instant deleted = headers.getLastModifiedDate();
                        this.containmentIndex.addContainedBy(tx, parentId, fedoraId, created, deleted);
                    }
                }
            });
            if (rootId.get() == null) {
                throw new IllegalStateException(String.format("Failed to find the root resource in object identified by %s. Please ensure that the object ID you are attempting to index refers to a corresponding valid Fedora-flavored object in the OCFL repository. Additionally be sure that the object ID corresponds with the object root resource (as opposed to child resources within the object).", ocflId));
            }
            fedoraIds.forEach(fedoraIdentifier -> {
                FedoraId rootFedoraIdentifier = (FedoraId)rootId.get();
                this.ocflIndex.addMapping(tx, (FedoraId)fedoraIdentifier, rootFedoraIdentifier, ocflId);
                LOGGER.debug("Rebuilt fedora-to-ocfl object index entry for {}", fedoraIdentifier);
            });
            headersList.forEach(headers -> {
                this.searchIndex.addUpdateIndex(tx, headers);
                LOGGER.debug("Rebuilt searchIndex for {}", (Object)headers.getId());
            });
        }
    }

    public void cleanupSession(String transactionId) {
        this.persistentStorageSessionManager.removeSession(transactionId);
    }

    public void setMembershipPageSize(int pageSize) {
        this.membershipPageSize = pageSize;
    }

    public void reset() {
        this.ocflIndex.reset();
        this.containmentIndex.reset();
        this.searchIndex.reset();
        this.referenceService.reset();
        this.membershipService.reset();
    }

    public void indexMembership(Transaction transaction) {
        LOGGER.debug("Starting indexMembership for transaction {}", (Object)transaction);
        List<Condition.Field> fields = List.of(Condition.Field.FEDORA_ID);
        List<Condition> conditions = List.of(Condition.fromEnums((Condition.Field)Condition.Field.RDF_TYPE, (Condition.Operator)Condition.Operator.EQ, (String)RdfLexicon.DIRECT_CONTAINER.getURI()));
        int offset = 0;
        try {
            int numResults;
            do {
                SearchParameters params = new SearchParameters(fields, conditions, this.membershipPageSize, offset, Condition.Field.FEDORA_ID, "asc", false);
                SearchResult searchResult = this.searchIndex.doSearch(params);
                List resultList = searchResult.getItems();
                numResults = resultList.size();
                resultList.stream().map(entry -> FedoraId.create((String[])new String[]{(String)entry.get(Condition.Field.FEDORA_ID.toString())})).forEach(containerId -> this.membershipService.populateMembershipHistory(transaction, containerId));
                offset += this.membershipPageSize;
            } while (numResults == this.membershipPageSize);
        }
        catch (InvalidQueryException e) {
            throw new RepositoryRuntimeException("Failed to repopulate membership history", (Throwable)e);
        }
        LOGGER.debug("Finished indexMembership for transaction {}", (Object)transaction);
    }

    public void rollbackMembership(@NotNull Transaction tx) {
        this.execQuietly("Failed to rollback membership index transaction " + tx.getId(), () -> {
            this.membershipService.rollbackTransaction(tx);
            return null;
        });
    }

    private void execQuietly(String failureMessage, Callable<Void> callable) {
        try {
            callable.call();
        }
        catch (Exception e) {
            LOGGER.error(failureMessage, (Throwable)e);
        }
    }

    private static RdfStream parseRdf(FedoraId fedoraIdentifier, InputStream inputStream) {
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)model, (InputStream)inputStream, (Lang)OcflPersistentStorageUtils.getRdfFormat().getLang());
        FedoraId topic = fedoraIdentifier.isDescription() ? fedoraIdentifier.asBaseId() : fedoraIdentifier;
        return DefaultRdfStream.fromModel((Node)NodeFactory.createURI((String)topic.getFullId()), (Model)model);
    }
}

