/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import edu.wisc.library.ocfl.api.OcflRepository;
import java.time.Duration;
import java.time.Instant;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.fcrepo.common.db.DbTransactionExecutor;
import org.fcrepo.config.FedoraPropsConfig;
import org.fcrepo.config.OcflPropsConfig;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.ReadOnlyTransaction;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.TransactionManager;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.persistence.ocfl.api.FedoraOcflMappingNotFoundException;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.api.IndexBuilder;
import org.fcrepo.persistence.ocfl.impl.ReindexManager;
import org.fcrepo.persistence.ocfl.impl.ReindexService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class IndexBuilderImpl
implements IndexBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexBuilderImpl.class);
    @Autowired
    @Qualifier(value="ocflIndex")
    private FedoraToOcflObjectIndex ocflIndex;
    @Autowired
    @Qualifier(value="containmentIndex")
    private ContainmentIndex containmentIndex;
    @Inject
    private OcflRepository ocflRepository;
    @Inject
    private ReindexService reindexService;
    @Inject
    private OcflPropsConfig ocflPropsConfig;
    @Inject
    private FedoraPropsConfig fedoraPropsConfig;
    @Inject
    private TransactionManager txManager;
    @Inject
    private DbTransactionExecutor dbTransactionExecutor;

    @Override
    public void rebuildIfNecessary() {
        if (this.shouldRebuild()) {
            this.rebuild();
        } else {
            LOGGER.debug("No index rebuild necessary");
        }
    }

    private void rebuild() {
        String logMessage = this.fedoraPropsConfig.isRebuildContinue() ? "Initiating partial index rebuild. This will add missing objects to the index." : "Initiating index rebuild.";
        LOGGER.info(logMessage + " This may take a while. Progress will be logged periodically.");
        if (!this.fedoraPropsConfig.isRebuildContinue()) {
            LOGGER.debug("Clearing all indexes");
            this.reindexService.reset();
        }
        try (Stream objectIds = this.ocflRepository.listObjectIds();){
            ReindexManager reindexManager = new ReindexManager(objectIds, this.reindexService, this.ocflPropsConfig, this.txManager, this.dbTransactionExecutor);
            LOGGER.debug("Reading object ids...");
            Instant startTime = Instant.now();
            try {
                reindexManager.start();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                reindexManager.shutdown();
            }
            Instant endTime = Instant.now();
            int count = reindexManager.getCompletedCount();
            int errors = reindexManager.getErrorCount();
            int skipped = reindexManager.getSkippedCount();
            if (this.fedoraPropsConfig.isRebuildContinue()) {
                LOGGER.info("Index rebuild completed {} objects successfully, {} objects skipped and {} objects had errors in {} ", new Object[]{count, skipped, errors, this.getDurationMessage(Duration.between(startTime, endTime))});
            } else {
                LOGGER.info("Index rebuild completed {} objects successfully and {} objects had errors in {} ", new Object[]{count, errors, this.getDurationMessage(Duration.between(startTime, endTime))});
            }
        }
    }

    private boolean shouldRebuild() {
        String repoRoot = this.getRepoRootMapping();
        if (this.fedoraPropsConfig.isRebuildOnStart() || this.fedoraPropsConfig.isRebuildContinue()) {
            return true;
        }
        if (repoRoot == null) {
            return true;
        }
        return !this.repoContainsRootObject(repoRoot);
    }

    private String getRepoRootMapping() {
        try {
            return this.ocflIndex.getMapping((Transaction)ReadOnlyTransaction.INSTANCE, FedoraId.getRepositoryRootId()).getOcflObjectId();
        }
        catch (FedoraOcflMappingNotFoundException e) {
            return null;
        }
    }

    private boolean repoContainsRootObject(String id) {
        return this.ocflRepository.containsObject(id);
    }

    private String getDurationMessage(Duration duration) {
        Object message = String.format("%d seconds", duration.toSecondsPart());
        if (duration.getSeconds() > 60L) {
            message = String.format("%d mins, ", duration.toMinutesPart()) + (String)message;
        }
        if (duration.getSeconds() > 3600L) {
            message = String.format("%d hours, ", duration.toHoursPart()) + (String)message;
        }
        return message;
    }
}

