/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import edu.wisc.library.ocfl.api.DigestAlgorithmRegistry;
import edu.wisc.library.ocfl.api.MutableOcflRepository;
import edu.wisc.library.ocfl.api.model.DigestAlgorithm;
import edu.wisc.library.ocfl.api.model.OcflVersion;
import edu.wisc.library.ocfl.aws.OcflS3Client;
import edu.wisc.library.ocfl.core.OcflRepositoryBuilder;
import edu.wisc.library.ocfl.core.extension.OcflExtensionConfig;
import edu.wisc.library.ocfl.core.extension.storage.layout.config.HashedNTupleLayoutConfig;
import edu.wisc.library.ocfl.core.path.constraint.ContentPathConstraints;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMapper;
import edu.wisc.library.ocfl.core.path.mapper.LogicalPathMappers;
import edu.wisc.library.ocfl.core.storage.OcflStorage;
import edu.wisc.library.ocfl.core.storage.OcflStorageBuilder;
import edu.wisc.library.ocfl.core.storage.cloud.CloudClient;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.impl.auth.UnsupportedDigestAlgorithmException;
import org.apache.jena.riot.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;

public class OcflPersistentStorageUtils {
    private static final Logger log = LoggerFactory.getLogger(OcflPersistentStorageUtils.class);
    private static final OcflVersion OCFL_VERSION = OcflVersion.OCFL_1_1;
    private static RDFFormat DEFAULT_RDF_FORMAT = RDFFormat.NTRIPLES;

    private OcflPersistentStorageUtils() {
    }

    public static RDFFormat getRdfFormat() {
        return DEFAULT_RDF_FORMAT;
    }

    public static String getRDFFileExtension() {
        return "." + (String)DEFAULT_RDF_FORMAT.getLang().getFileExtensions().get(0);
    }

    public static MutableOcflRepository createFilesystemRepository(Path ocflStorageRootDir, Path ocflWorkDir, org.fcrepo.config.DigestAlgorithm algorithm, boolean ocflUpgradeOnWrite, boolean verifyInventory) throws IOException {
        OcflPersistentStorageUtils.createDirectories(ocflStorageRootDir);
        OcflStorage storage = OcflStorageBuilder.builder().verifyInventoryDigest(verifyInventory).fileSystem(ocflStorageRootDir).build();
        return OcflPersistentStorageUtils.createRepository(ocflWorkDir, builder -> builder.storage(storage), algorithm, ocflUpgradeOnWrite);
    }

    public static MutableOcflRepository createS3Repository(DataSource dataSource, S3Client s3Client, String bucket, String prefix, Path ocflWorkDir, org.fcrepo.config.DigestAlgorithm algorithm, boolean withDb, boolean ocflUpgradeOnWrite, boolean verifyInventory) throws IOException {
        OcflPersistentStorageUtils.createDirectories(ocflWorkDir);
        OcflStorage storage = OcflStorageBuilder.builder().verifyInventoryDigest(verifyInventory).cloud((CloudClient)OcflS3Client.builder().s3Client(s3Client).bucket(bucket).repoPrefix(prefix).build()).build();
        return OcflPersistentStorageUtils.createRepository(ocflWorkDir, builder -> {
            builder.contentPathConstraints(ContentPathConstraints.cloud()).storage(storage);
            if (withDb) {
                builder.objectDetailsDb(db -> db.dataSource(dataSource));
            }
        }, algorithm, ocflUpgradeOnWrite);
    }

    private static MutableOcflRepository createRepository(Path ocflWorkDir, Consumer<OcflRepositoryBuilder> configurer, org.fcrepo.config.DigestAlgorithm algorithm, boolean ocflUpgradeOnWrite) throws IOException {
        OcflPersistentStorageUtils.createDirectories(ocflWorkDir);
        DigestAlgorithm ocflDigestAlg = OcflPersistentStorageUtils.translateFedoraDigestToOcfl(algorithm);
        if (ocflDigestAlg == null) {
            throw new UnsupportedDigestAlgorithmException("Unable to map Fedora default digest algorithm " + algorithm + " into OCFL");
        }
        LogicalPathMapper logicalPathMapper = SystemUtils.IS_OS_WINDOWS ? LogicalPathMappers.percentEncodingWindowsMapper() : LogicalPathMappers.percentEncodingLinuxMapper();
        OcflRepositoryBuilder builder = new OcflRepositoryBuilder().defaultLayoutConfig((OcflExtensionConfig)new HashedNTupleLayoutConfig()).ocflConfig(config -> config.setDefaultDigestAlgorithm(ocflDigestAlg).setOcflVersion(OCFL_VERSION).setUpgradeObjectsOnWrite(ocflUpgradeOnWrite)).logicalPathMapper(logicalPathMapper).workDir(ocflWorkDir);
        configurer.accept(builder);
        return builder.buildMutable();
    }

    public static ObjectMapper objectMapper() {
        return new ObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).registerModule((Module)new JavaTimeModule()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static DigestAlgorithm translateFedoraDigestToOcfl(org.fcrepo.config.DigestAlgorithm fcrepoAlg) {
        return fcrepoAlg.getAliases().stream().map(alias -> DigestAlgorithmRegistry.getAlgorithm((String)alias)).filter(alg -> alg != null).findFirst().orElse(null);
    }

    private static Path createDirectories(Path path) throws IOException {
        try {
            return Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            return path;
        }
    }
}

