/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.operations.OverwriteTombstoneOperation;
import org.fcrepo.kernel.api.operations.RdfSourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.persistence.api.exceptions.PersistentItemConflictException;
import org.fcrepo.persistence.api.exceptions.PersistentItemNotFoundException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.AbstractRdfSourcePersister;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSession;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverwriteRdfTombstonePersister
extends AbstractRdfSourcePersister {
    private static final Logger log = LoggerFactory.getLogger(OverwriteRdfTombstonePersister.class);

    protected OverwriteRdfTombstonePersister(FedoraToOcflObjectIndex index) {
        super(RdfSourceOperation.class, ResourceOperationType.OVERWRITE_TOMBSTONE, index);
    }

    @Override
    public void persist(OcflPersistentStorageSession session, ResourceOperation operation) throws PersistentStorageException {
        FedoraId rootObjectId;
        FedoraId resourceId = operation.getResourceId();
        log.debug("persisting {} to {}", (Object)resourceId, (Object)session);
        OverwriteTombstoneOperation overwriteTombstoneOp = (OverwriteTombstoneOperation)operation;
        boolean archivalGroup = overwriteTombstoneOp.isArchivalGroup();
        ResourceHeaders headers = session.getHeaders(resourceId, null);
        if (headers == null) {
            throw new PersistentItemNotFoundException("Resource does not exist");
        }
        if (!headers.isDeleted()) {
            throw new PersistentStorageException("Cannot overwrite tombstone of non-deleted resource");
        }
        if (archivalGroup) {
            if (!headers.isArchivalGroup()) {
                throw new PersistentItemConflictException("Changing from an Atomic Resource to an ArchivalGroup is not permitted");
            }
            rootObjectId = resourceId;
        } else {
            if (headers.isArchivalGroup()) {
                throw new PersistentItemConflictException("Changing from an ArchivalGroup to an Atomic Resource is not permitted");
            }
            rootObjectId = headers.getArchivalGroupId() != null ? headers.getArchivalGroupId() : resourceId.asBaseId();
        }
        String ocflObjectId = this.mapToOcflId(operation.getTransaction(), rootObjectId);
        OcflObjectSession ocflObjectSession = session.findOrCreateSession(ocflObjectId);
        this.persistRDF(ocflObjectSession, operation, rootObjectId.asBaseId(), headers.getArchivalGroupId() != null);
        this.ocflIndex.addMapping(operation.getTransaction(), resourceId.asResourceId(), rootObjectId.asBaseId(), ocflObjectId);
    }
}

