/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import java.time.Instant;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.kernel.api.operations.UpdateNonRdfSourceHeadersOperation;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.AbstractRdfSourcePersister;
import org.fcrepo.persistence.ocfl.impl.FedoraOcflMapping;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSession;
import org.fcrepo.persistence.ocfl.impl.ResourceHeadersAdapter;
import org.fcrepo.persistence.ocfl.impl.UpdateRdfSourcePersister;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateNonRdfSourceHeadersPersister
extends AbstractRdfSourcePersister {
    private static final Logger log = LoggerFactory.getLogger(UpdateRdfSourcePersister.class);

    public UpdateNonRdfSourceHeadersPersister(FedoraToOcflObjectIndex fedoraOcflIndex) {
        super(UpdateNonRdfSourceHeadersOperation.class, ResourceOperationType.UPDATE_HEADERS, fedoraOcflIndex);
    }

    @Override
    public void persist(OcflPersistentStorageSession session, ResourceOperation operation) throws PersistentStorageException {
        FedoraId resourceId = operation.getResourceId();
        log.debug("persisting {} headers to {}", (Object)resourceId, (Object)session);
        FedoraOcflMapping fedoraOcflMapping = this.getMapping(operation.getTransaction(), resourceId);
        String ocflId = fedoraOcflMapping.getOcflObjectId();
        OcflObjectSession objSession = session.findOrCreateSession(ocflId);
        ResourceHeadersAdapter headers = new ResourceHeadersAdapter(objSession.readHeaders(resourceId.getResourceId()));
        UpdateNonRdfSourceHeadersOperation updateHeadersOp = (UpdateNonRdfSourceHeadersOperation)operation;
        Instant createdDate = updateHeadersOp.getCreatedDate();
        Instant lastModifiedDate = updateHeadersOp.getLastModifiedDate();
        String createdBy = updateHeadersOp.getCreatedBy();
        String lastModifiedBy = updateHeadersOp.getLastModifiedBy();
        String mimetype = updateHeadersOp.getMimeType();
        String filename = updateHeadersOp.getFilename();
        if (createdDate != null) {
            headers.setCreatedDate(createdDate);
        }
        if (lastModifiedDate != null) {
            headers.setLastModifiedDate(lastModifiedDate);
        }
        if (createdBy != null) {
            headers.setCreatedBy(createdBy);
        }
        if (lastModifiedBy != null) {
            headers.setLastModifiedBy(lastModifiedBy);
        }
        if (mimetype != null) {
            headers.setMimeType(mimetype);
        }
        if (filename != null) {
            headers.setFilename(filename);
        }
        objSession.writeHeaders(headers.asStorageHeaders());
    }
}

