/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import org.fcrepo.common.metrics.MetricsHelper;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.persistence.ocfl.api.FedoraOcflMappingNotFoundException;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.FedoraOcflMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="ocflIndex")
public class FedoraToOcflObjectIndexMetrics
implements FedoraToOcflObjectIndex {
    private static final String METRIC_NAME = "fcrepo.db";
    private static final String DB = "db";
    private static final String OCFL = "ocfl";
    private static final String OPERATION = "operation";
    private static final Timer getMappingTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "ocfl", "operation", "getMapping"});
    private static final Timer addMappingTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "ocfl", "operation", "addMapping"});
    private static final Timer removeMappingTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "ocfl", "operation", "removeMapping"});
    private static final Timer resetTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "ocfl", "operation", "reset"});
    private static final Timer commitTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "ocfl", "operation", "commit"});
    private static final Timer rollbackTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "ocfl", "operation", "rollback"});
    private static final Timer clearAllTransactionsTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "ocfl", "operation", "clearAllTransactions"});
    @Autowired
    private FedoraToOcflObjectIndex ocflIndexImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FedoraOcflMapping getMapping(Transaction session, FedoraId fedoraResourceIdentifier) throws FedoraOcflMappingNotFoundException {
        Timer.Sample stopwatch = Timer.start();
        try {
            FedoraOcflMapping fedoraOcflMapping = this.ocflIndexImpl.getMapping(session, fedoraResourceIdentifier);
            return fedoraOcflMapping;
        }
        finally {
            stopwatch.stop(getMappingTimer);
        }
    }

    @Override
    public FedoraOcflMapping addMapping(Transaction session, FedoraId fedoraResourceIdentifier, FedoraId fedoraRootObjectIdentifier, String ocflObjectId) {
        return (FedoraOcflMapping)MetricsHelper.time((Timer)addMappingTimer, () -> this.ocflIndexImpl.addMapping(session, fedoraResourceIdentifier, fedoraRootObjectIdentifier, ocflObjectId));
    }

    @Override
    public void removeMapping(Transaction session, FedoraId fedoraResourceIdentifier) {
        removeMappingTimer.record(() -> this.ocflIndexImpl.removeMapping(session, fedoraResourceIdentifier));
    }

    @Override
    public void reset() {
        resetTimer.record(() -> this.ocflIndexImpl.reset());
    }

    @Override
    public void commit(Transaction session) {
        commitTimer.record(() -> this.ocflIndexImpl.commit(session));
    }

    @Override
    public void rollback(Transaction session) {
        rollbackTimer.record(() -> this.ocflIndexImpl.rollback(session));
    }

    @Override
    public void clearAllTransactions() {
        clearAllTransactionsTimer.record(() -> this.ocflIndexImpl.clearAllTransactions());
    }
}

