/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import io.ocfl.api.MutableOcflRepository;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.fcrepo.config.MetricsConfig;
import org.fcrepo.config.OcflPropsConfig;
import org.fcrepo.config.Storage;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageUtils;
import org.fcrepo.storage.ocfl.CommitType;
import org.fcrepo.storage.ocfl.DefaultOcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.fcrepo.storage.ocfl.ResourceHeaders;
import org.fcrepo.storage.ocfl.cache.CaffeineCache;
import org.fcrepo.storage.ocfl.cache.NoOpCache;
import org.fcrepo.storage.ocfl.validation.ObjectValidator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3CrtAsyncClientBuilder;

@Configuration
public class OcflPersistenceConfig {
    @Inject
    private OcflPropsConfig ocflPropsConfig;
    @Inject
    private MetricsConfig metricsConfig;
    @Inject
    private MeterRegistry meterRegistry;
    @Inject
    private DataSource dataSource;

    @Bean
    public MutableOcflRepository repository() throws IOException {
        if (this.ocflPropsConfig.getStorage() == Storage.OCFL_S3) {
            return OcflPersistentStorageUtils.createS3Repository(this.dataSource, this.s3Client(), this.s3CrtClient(), this.ocflPropsConfig.getOcflS3Bucket(), this.ocflPropsConfig.getOcflS3Prefix(), this.ocflPropsConfig.getOcflTemp(), this.ocflPropsConfig.getDefaultDigestAlgorithm(), this.ocflPropsConfig.isOcflS3DbEnabled(), this.ocflPropsConfig.isOcflUpgradeOnWrite(), this.ocflPropsConfig.verifyInventory());
        }
        return OcflPersistentStorageUtils.createFilesystemRepository(this.ocflPropsConfig.getOcflRepoRoot(), this.ocflPropsConfig.getOcflTemp(), this.ocflPropsConfig.getDefaultDigestAlgorithm(), this.ocflPropsConfig.isOcflUpgradeOnWrite(), this.ocflPropsConfig.verifyInventory());
    }

    @Bean
    public OcflObjectSessionFactory ocflObjectSessionFactory() throws IOException {
        ObjectMapper objectMapper = OcflPersistentStorageUtils.objectMapper();
        DefaultOcflObjectSessionFactory factory = new DefaultOcflObjectSessionFactory(this.repository(), this.ocflPropsConfig.getFedoraOcflStaging(), objectMapper, this.createCache("resourceHeadersCache"), this.createCache("rootIdCache"), this.commitType(), "Authored by Fedora 6", "fedoraAdmin", "info:fedora/fedoraAdmin");
        factory.useUnsafeWrite(this.ocflPropsConfig.isUnsafeWriteEnabled());
        return factory;
    }

    @Bean
    public ObjectValidator objectValidator() throws IOException {
        ObjectMapper objectMapper = OcflPersistentStorageUtils.objectMapper();
        return new ObjectValidator(this.repository(), objectMapper.readerFor(ResourceHeaders.class));
    }

    private CommitType commitType() {
        if (this.ocflPropsConfig.isAutoVersioningEnabled()) {
            return CommitType.NEW_VERSION;
        }
        return CommitType.UNVERSIONED;
    }

    private S3AsyncClient s3CrtClient() {
        S3CrtAsyncClientBuilder builder = S3AsyncClient.crtBuilder().checksumValidationEnabled(Boolean.valueOf(this.ocflPropsConfig.isOcflS3ChecksumEnabled()));
        if (StringUtils.isNotBlank((CharSequence)this.ocflPropsConfig.getAwsRegion())) {
            builder.region(Region.of((String)this.ocflPropsConfig.getAwsRegion()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.ocflPropsConfig.getS3Endpoint())) {
            builder.endpointOverride(URI.create(this.ocflPropsConfig.getS3Endpoint()));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.ocflPropsConfig.getAwsAccessKey(), this.ocflPropsConfig.getAwsSecretKey()})) {
            builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.ocflPropsConfig.getAwsAccessKey(), (String)this.ocflPropsConfig.getAwsSecretKey())));
        }
        return builder.build();
    }

    private S3AsyncClient s3Client() {
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        if (StringUtils.isNotBlank((CharSequence)this.ocflPropsConfig.getAwsRegion())) {
            builder.region(Region.of((String)this.ocflPropsConfig.getAwsRegion()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.ocflPropsConfig.getS3Endpoint())) {
            builder.endpointOverride(URI.create(this.ocflPropsConfig.getS3Endpoint()));
        }
        if (this.ocflPropsConfig.isPathStyleAccessEnabled()) {
            builder.serviceConfiguration(config -> config.pathStyleAccessEnabled(Boolean.valueOf(true)));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.ocflPropsConfig.getAwsAccessKey(), this.ocflPropsConfig.getAwsSecretKey()})) {
            builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.ocflPropsConfig.getAwsAccessKey(), (String)this.ocflPropsConfig.getAwsSecretKey())));
        }
        NettyNioAsyncHttpClient.Builder httpClientBuilder = NettyNioAsyncHttpClient.builder().connectionAcquisitionTimeout(Duration.ofSeconds(this.ocflPropsConfig.getS3ConnectionTimeout())).writeTimeout(Duration.ofSeconds(this.ocflPropsConfig.getS3WriteTimeout())).readTimeout(Duration.ofSeconds(this.ocflPropsConfig.getS3ReadTimeout())).maxConcurrency(Integer.valueOf(this.ocflPropsConfig.getS3MaxConcurrency()));
        builder.httpClientBuilder((SdkAsyncHttpClient.Builder)httpClientBuilder);
        return (S3AsyncClient)builder.build();
    }

    private <K, V> org.fcrepo.storage.ocfl.cache.Cache<K, V> createCache(String metricName) {
        if (this.ocflPropsConfig.isResourceHeadersCacheEnabled()) {
            Caffeine builder = Caffeine.newBuilder();
            if (this.metricsConfig.isMetricsEnabled()) {
                builder.recordStats();
            }
            Cache cache = builder.maximumSize(this.ocflPropsConfig.getResourceHeadersCacheMaxSize()).expireAfterAccess(this.ocflPropsConfig.getResourceHeadersCacheExpireAfterSeconds(), TimeUnit.SECONDS).build();
            if (this.metricsConfig.isMetricsEnabled()) {
                CaffeineCacheMetrics.monitor((MeterRegistry)this.meterRegistry, (Cache)cache, (String)metricName, (String[])new String[0]);
            }
            return new CaffeineCache(cache);
        }
        return new NoOpCache();
    }
}

