/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.fcrepo.config.OcflPropsConfig;
import org.fcrepo.kernel.api.ReadOnlyTransaction;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSession;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSessionMetrics;
import org.fcrepo.persistence.ocfl.impl.ReindexService;
import org.fcrepo.storage.ocfl.OcflObjectSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OcflPersistentSessionManager
implements PersistentStorageSessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcflPersistentSessionManager.class);
    private volatile PersistentStorageSession readOnlySession;
    private Map<String, PersistentStorageSession> sessionMap = new ConcurrentHashMap<String, PersistentStorageSession>();
    @Inject
    private OcflObjectSessionFactory objectSessionFactory;
    @Inject
    private FedoraToOcflObjectIndex ocflIndex;
    @Inject
    private ReindexService reindexService;
    @Inject
    private OcflPropsConfig ocflPropsConfig;

    @Autowired
    public OcflPersistentSessionManager() {
    }

    public PersistentStorageSession getSession(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("session id must be non-null");
        }
        return this.sessionMap.computeIfAbsent(transaction.getId(), key -> {
            LOGGER.debug("Creating storage session {}", (Object)transaction);
            return new OcflPersistentStorageSessionMetrics(new OcflPersistentStorageSession(transaction, this.ocflIndex, this.objectSessionFactory, this.reindexService));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentStorageSession getReadOnlySession() {
        PersistentStorageSession localSession = this.readOnlySession;
        if (localSession == null) {
            OcflPersistentSessionManager ocflPersistentSessionManager = this;
            synchronized (ocflPersistentSessionManager) {
                localSession = this.readOnlySession;
                if (localSession == null) {
                    localSession = this.readOnlySession = new OcflPersistentStorageSessionMetrics(new OcflPersistentStorageSession((Transaction)ReadOnlyTransaction.INSTANCE, this.ocflIndex, this.objectSessionFactory, this.reindexService));
                }
            }
        }
        return localSession;
    }

    public PersistentStorageSession removeSession(String sessionId) {
        LOGGER.debug("Removing storage session {}", (Object)sessionId);
        return this.sessionMap.remove(sessionId);
    }

    public void clearAllSessions() {
        LOGGER.debug("Clearing all storage sessions");
        this.sessionMap.clear();
        this.ocflIndex.clearAllTransactions();
        try {
            this.deleteStagingDirectories();
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete OCFL staging directories", (Throwable)e);
        }
    }

    private void deleteStagingDirectories() throws IOException {
        Files.walkFileTree(this.ocflPropsConfig.getFedoraOcflStaging(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (!dir.equals(OcflPersistentSessionManager.this.ocflPropsConfig.getFedoraOcflStaging())) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

