/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.InputStream;
import java.time.Instant;
import java.util.List;
import org.fcrepo.common.metrics.MetricsHelper;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;

public class OcflPersistentStorageSessionMetrics
implements PersistentStorageSession {
    private static final String METRIC_NAME = "fcrepo.storage.ocfl.session";
    private static final String OPERATION = "operation";
    private static final Timer persistTimer = Metrics.timer((String)"fcrepo.storage.ocfl.session", (String[])new String[]{"operation", "persist"});
    private static final Timer getHeadersTimer = Metrics.timer((String)"fcrepo.storage.ocfl.session", (String[])new String[]{"operation", "getHeaders"});
    private static final Timer getTriplesTimer = Metrics.timer((String)"fcrepo.storage.ocfl.session", (String[])new String[]{"operation", "getTriples"});
    private static final Timer listVersionsTimer = Metrics.timer((String)"fcrepo.storage.ocfl.session", (String[])new String[]{"operation", "listVersions"});
    private static final Timer getContentTimer = Metrics.timer((String)"fcrepo.storage.ocfl.session", (String[])new String[]{"operation", "getContent"});
    private static final Timer getRangeTimer = Metrics.timer((String)"fcrepo.storage.ocfl.session", (String[])new String[]{"operation", "getRange"});
    private static final Timer prepareTimer = Metrics.timer((String)"fcrepo.storage.ocfl.session", (String[])new String[]{"operation", "prepare"});
    private static final Timer commitTimer = Metrics.timer((String)"fcrepo.storage.ocfl.session", (String[])new String[]{"operation", "commit"});
    private static final Timer rollbackTimer = Metrics.timer((String)"fcrepo.storage.ocfl.session", (String[])new String[]{"operation", "rollback"});
    private final PersistentStorageSession delegate;

    public OcflPersistentStorageSessionMetrics(PersistentStorageSession delegate) {
        this.delegate = delegate;
    }

    public String getId() {
        return this.delegate.getId();
    }

    public void persist(ResourceOperation operation) throws PersistentStorageException {
        persistTimer.record(() -> this.delegate.persist(operation));
    }

    public ResourceHeaders getHeaders(FedoraId identifier, Instant version) throws PersistentStorageException {
        return (ResourceHeaders)MetricsHelper.time((Timer)getHeadersTimer, () -> this.delegate.getHeaders(identifier, version));
    }

    public RdfStream getTriples(FedoraId identifier, Instant version) throws PersistentStorageException {
        return (RdfStream)MetricsHelper.time((Timer)getTriplesTimer, () -> this.delegate.getTriples(identifier, version));
    }

    public InputStream getBinaryContent(FedoraId identifier, Instant version) throws PersistentStorageException {
        return (InputStream)MetricsHelper.time((Timer)getContentTimer, () -> this.delegate.getBinaryContent(identifier, version));
    }

    public InputStream getBinaryRange(FedoraId identifier, Instant version, long start, long end) throws PersistentStorageException {
        return (InputStream)MetricsHelper.time((Timer)getRangeTimer, () -> this.delegate.getBinaryRange(identifier, version, start, end));
    }

    public List<Instant> listVersions(FedoraId identifier) throws PersistentStorageException {
        return (List)MetricsHelper.time((Timer)listVersionsTimer, () -> this.delegate.listVersions(identifier));
    }

    public void prepare() throws PersistentStorageException {
        prepareTimer.record(() -> ((PersistentStorageSession)this.delegate).prepare());
    }

    public void commit() throws PersistentStorageException {
        commitTimer.record(() -> ((PersistentStorageSession)this.delegate).commit());
    }

    public void rollback() throws PersistentStorageException {
        rollbackTimer.record(() -> ((PersistentStorageSession)this.delegate).rollback());
    }
}

