/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.fcrepo.common.db.DbTransactionExecutor;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.TransactionManager;
import org.fcrepo.persistence.api.exceptions.ObjectExistsInOcflIndexException;
import org.fcrepo.persistence.ocfl.impl.ReindexManager;
import org.fcrepo.persistence.ocfl.impl.ReindexService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexWorker
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReindexWorker.class);
    private static final long REPORTING_INTERVAL_SECS = 30L;
    private Thread t;
    private ReindexManager manager;
    private ReindexService service;
    private boolean running = true;
    private boolean failOnError;
    private TransactionManager txManager;
    private DbTransactionExecutor dbTransactionExecutor;

    public ReindexWorker(String name, ReindexManager reindexManager, ReindexService reindexService, TransactionManager transactionManager, DbTransactionExecutor dbTransactionExecutor, boolean failOnError) {
        this.manager = reindexManager;
        this.service = reindexService;
        this.txManager = transactionManager;
        this.dbTransactionExecutor = dbTransactionExecutor;
        this.failOnError = failOnError;
        this.t = new Thread((Runnable)this, name);
    }

    public void join() throws InterruptedException {
        this.t.join();
    }

    public void start() {
        this.t.start();
    }

    @Override
    public void run() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (this.running) {
            List<String> ids = this.manager.getIds();
            if (ids.isEmpty()) {
                LOGGER.debug("No more objects found to process. Stopping...");
                this.stopThread();
                break;
            }
            int completed = 0;
            int errors = 0;
            int skipped = 0;
            for (String id : ids) {
                Transaction tx;
                block7: {
                    if (!this.running) break;
                    tx = this.txManager.create();
                    tx.suppressEvents();
                    tx.setShortLived(true);
                    if (stopwatch.elapsed(TimeUnit.SECONDS) > 30L) {
                        this.manager.updateComplete(completed, errors, skipped);
                        completed = 0;
                        errors = 0;
                        stopwatch.reset().start();
                    }
                    try {
                        this.dbTransactionExecutor.doInTxWithRetry(() -> {
                            this.service.indexOcflObject(tx, id);
                            tx.commit();
                        });
                        ++completed;
                    }
                    catch (ObjectExistsInOcflIndexException e) {
                        tx.rollback();
                        LOGGER.debug(e.getMessage());
                        ++skipped;
                    }
                    catch (Exception e) {
                        LOGGER.error("Reindexing of OCFL id {} failed", (Object)id, (Object)e);
                        tx.rollback();
                        ++errors;
                        if (!this.failOnError) break block7;
                        this.manager.updateComplete(completed, errors, skipped);
                        this.manager.stop();
                        this.service.cleanupSession(tx.getId());
                        throw e;
                    }
                }
                this.service.cleanupSession(tx.getId());
            }
            this.manager.updateComplete(completed, errors, skipped);
        }
    }

    public void stopThread() {
        this.running = false;
    }
}

