/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.persistence.common.ResourceHeadersImpl;
import org.fcrepo.storage.ocfl.ResourceHeaders;

public class ResourceHeadersAdapter
implements ResourceHeaders {
    private final ResourceHeadersImpl kernelHeaders;
    private final ResourceHeaders.Builder storageHeaders;

    public ResourceHeadersAdapter() {
        this.kernelHeaders = new ResourceHeadersImpl();
        this.storageHeaders = org.fcrepo.storage.ocfl.ResourceHeaders.builder();
    }

    public ResourceHeadersAdapter(org.fcrepo.storage.ocfl.ResourceHeaders storageHeaders) {
        this.storageHeaders = org.fcrepo.storage.ocfl.ResourceHeaders.builder((org.fcrepo.storage.ocfl.ResourceHeaders)Objects.requireNonNull(storageHeaders, "storageHeaders cannot be null"));
        this.kernelHeaders = new ResourceHeadersImpl();
        if (storageHeaders.getId() != null) {
            this.kernelHeaders.setId(FedoraId.create((String[])new String[]{storageHeaders.getId()}));
        }
        if (storageHeaders.getParent() != null) {
            this.kernelHeaders.setParent(FedoraId.create((String[])new String[]{storageHeaders.getParent()}));
        }
        if (storageHeaders.getArchivalGroupId() != null) {
            this.kernelHeaders.setArchivalGroupId(FedoraId.create((String[])new String[]{storageHeaders.getArchivalGroupId()}));
        }
        this.kernelHeaders.setArchivalGroup(storageHeaders.isArchivalGroup());
        this.kernelHeaders.setContentPath(storageHeaders.getContentPath());
        this.kernelHeaders.setContentSize(storageHeaders.getContentSize());
        this.kernelHeaders.setCreatedBy(storageHeaders.getCreatedBy());
        this.kernelHeaders.setCreatedDate(storageHeaders.getCreatedDate());
        this.kernelHeaders.setDeleted(storageHeaders.isDeleted());
        this.kernelHeaders.setDigests(new ArrayList(storageHeaders.getDigests()));
        this.storageHeaders.withDigests(this.kernelHeaders.getDigests());
        this.kernelHeaders.setExternalHandling(storageHeaders.getExternalHandling());
        this.kernelHeaders.setExternalUrl(storageHeaders.getExternalUrl());
        this.kernelHeaders.setFilename(storageHeaders.getFilename());
        this.kernelHeaders.setInteractionModel(storageHeaders.getInteractionModel());
        this.kernelHeaders.setLastModifiedBy(storageHeaders.getLastModifiedBy());
        this.kernelHeaders.setLastModifiedDate(storageHeaders.getLastModifiedDate());
        this.kernelHeaders.setMementoCreatedDate(storageHeaders.getMementoCreatedDate());
        this.kernelHeaders.setMimeType(storageHeaders.getMimeType());
        this.kernelHeaders.setObjectRoot(storageHeaders.isObjectRoot());
        this.kernelHeaders.setStateToken(storageHeaders.getStateToken());
        this.kernelHeaders.setHeadersVersion(storageHeaders.getHeadersVersion());
        this.kernelHeaders.setStorageRelativePath(storageHeaders.getStorageRelativePath());
    }

    public ResourceHeadersAdapter(ResourceHeadersImpl kernelHeaders) {
        this.kernelHeaders = Objects.requireNonNull(kernelHeaders, "kernelHeaders cannot be null");
        this.storageHeaders = org.fcrepo.storage.ocfl.ResourceHeaders.builder();
        if (kernelHeaders.getId() != null) {
            this.storageHeaders.withId(kernelHeaders.getId().getFullId());
        }
        if (kernelHeaders.getParent() != null) {
            this.storageHeaders.withParent(kernelHeaders.getParent().getFullId());
        }
        if (kernelHeaders.getArchivalGroupId() != null) {
            this.storageHeaders.withArchivalGroupId(kernelHeaders.getArchivalGroupId().getFullId());
        }
        this.storageHeaders.withArchivalGroup(kernelHeaders.isArchivalGroup());
        this.storageHeaders.withContentPath(kernelHeaders.getContentPath());
        this.storageHeaders.withContentSize(kernelHeaders.getContentSize());
        this.storageHeaders.withCreatedBy(kernelHeaders.getCreatedBy());
        this.storageHeaders.withCreatedDate(kernelHeaders.getCreatedDate());
        this.storageHeaders.withDeleted(kernelHeaders.isDeleted());
        this.storageHeaders.withDigests(kernelHeaders.getDigests());
        this.storageHeaders.withExternalHandling(kernelHeaders.getExternalHandling());
        this.storageHeaders.withExternalUrl(kernelHeaders.getExternalUrl());
        this.storageHeaders.withFilename(kernelHeaders.getFilename());
        this.storageHeaders.withInteractionModel(kernelHeaders.getInteractionModel());
        this.storageHeaders.withLastModifiedBy(kernelHeaders.getLastModifiedBy());
        this.storageHeaders.withLastModifiedDate(kernelHeaders.getLastModifiedDate());
        this.storageHeaders.withMementoCreatedDate(kernelHeaders.getMementoCreatedDate());
        this.storageHeaders.withMimeType(kernelHeaders.getMimeType());
        this.storageHeaders.withObjectRoot(kernelHeaders.isObjectRoot());
        this.storageHeaders.withStateToken(kernelHeaders.getStateToken());
        this.storageHeaders.withHeadersVersion(kernelHeaders.getHeadersVersion());
    }

    public org.fcrepo.storage.ocfl.ResourceHeaders asStorageHeaders() {
        return this.storageHeaders.build();
    }

    public ResourceHeadersImpl asKernelHeaders() {
        return this.kernelHeaders;
    }

    private String idToString(FedoraId id) {
        if (id == null) {
            return null;
        }
        return id.getFullId();
    }

    public FedoraId getId() {
        return this.kernelHeaders.getId();
    }

    public void setId(FedoraId id) {
        this.kernelHeaders.setId(id);
        this.storageHeaders.withId(this.idToString(id));
    }

    public FedoraId getParent() {
        return this.kernelHeaders.getParent();
    }

    public void setParent(FedoraId parent) {
        this.kernelHeaders.setParent(parent);
        this.storageHeaders.withParent(this.idToString(parent));
    }

    public FedoraId getArchivalGroupId() {
        return this.kernelHeaders.getArchivalGroupId();
    }

    public void setArchivalGroupId(FedoraId archivalGroupId) {
        this.kernelHeaders.setArchivalGroupId(archivalGroupId);
        this.storageHeaders.withArchivalGroupId(this.idToString(archivalGroupId));
    }

    public String getStateToken() {
        return this.kernelHeaders.getStateToken();
    }

    public void setStateToken(String stateToken) {
        this.kernelHeaders.setStateToken(stateToken);
        this.storageHeaders.withStateToken(stateToken);
    }

    public String getInteractionModel() {
        return this.kernelHeaders.getInteractionModel();
    }

    public void setInteractionModel(String interactionModel) {
        this.kernelHeaders.setInteractionModel(interactionModel);
        this.storageHeaders.withInteractionModel(interactionModel);
    }

    public String getMimeType() {
        return this.kernelHeaders.getMimeType();
    }

    public void setMimeType(String mimeType) {
        this.kernelHeaders.setMimeType(mimeType);
        this.storageHeaders.withMimeType(mimeType);
    }

    public String getFilename() {
        return this.kernelHeaders.getFilename();
    }

    public void setFilename(String filename) {
        this.kernelHeaders.setFilename(filename);
        this.storageHeaders.withFilename(filename);
    }

    public long getContentSize() {
        return this.kernelHeaders.getContentSize();
    }

    public void setContentSize(Long contentSize) {
        this.kernelHeaders.setContentSize(contentSize.longValue());
        this.storageHeaders.withContentSize(contentSize.longValue());
    }

    public Collection<URI> getDigests() {
        return this.kernelHeaders.getDigests();
    }

    public void setDigests(Collection<URI> digests) {
        this.kernelHeaders.setDigests(digests);
        this.storageHeaders.withDigests(digests);
    }

    public String getExternalHandling() {
        return this.kernelHeaders.getExternalHandling();
    }

    public void setExternalHandling(String externalHandling) {
        this.kernelHeaders.setExternalHandling(externalHandling);
        this.storageHeaders.withExternalHandling(externalHandling);
    }

    public Instant getCreatedDate() {
        return this.kernelHeaders.getCreatedDate();
    }

    public void setCreatedDate(Instant createdDate) {
        this.kernelHeaders.setCreatedDate(createdDate);
        this.storageHeaders.withCreatedDate(createdDate);
    }

    public String getCreatedBy() {
        return this.kernelHeaders.getCreatedBy();
    }

    public void setCreatedBy(String createdBy) {
        this.kernelHeaders.setCreatedBy(createdBy);
        this.storageHeaders.withCreatedBy(createdBy);
    }

    public Instant getLastModifiedDate() {
        return this.kernelHeaders.getLastModifiedDate();
    }

    public void setLastModifiedDate(Instant lastModifiedDate) {
        this.kernelHeaders.setLastModifiedDate(lastModifiedDate);
        this.storageHeaders.withLastModifiedDate(lastModifiedDate);
    }

    public String getLastModifiedBy() {
        return this.kernelHeaders.getLastModifiedBy();
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.kernelHeaders.setLastModifiedBy(lastModifiedBy);
        this.storageHeaders.withLastModifiedBy(lastModifiedBy);
    }

    public Instant getMementoCreatedDate() {
        return this.kernelHeaders.getMementoCreatedDate();
    }

    public void setMementoCreatedDate(Instant mementoCreatedDate) {
        this.kernelHeaders.setMementoCreatedDate(mementoCreatedDate);
        this.storageHeaders.withMementoCreatedDate(mementoCreatedDate);
    }

    public void setExternalUrl(String externalUrl) {
        this.kernelHeaders.setExternalUrl(externalUrl);
        this.storageHeaders.withExternalUrl(externalUrl);
    }

    public String getExternalUrl() {
        return this.kernelHeaders.getExternalUrl();
    }

    public void setArchivalGroup(boolean flag) {
        this.kernelHeaders.setArchivalGroup(flag);
        this.storageHeaders.withArchivalGroup(flag);
    }

    public boolean isArchivalGroup() {
        return this.kernelHeaders.isArchivalGroup();
    }

    public void setObjectRoot(boolean flag) {
        this.kernelHeaders.setObjectRoot(flag);
        this.storageHeaders.withObjectRoot(flag);
    }

    public boolean isObjectRoot() {
        if (this.isArchivalGroup()) {
            return true;
        }
        return this.kernelHeaders.isObjectRoot();
    }

    public void setDeleted(boolean deleted) {
        this.kernelHeaders.setDeleted(deleted);
        this.storageHeaders.withDeleted(deleted);
    }

    public boolean isDeleted() {
        return this.kernelHeaders.isDeleted();
    }

    public String getContentPath() {
        return this.kernelHeaders.getContentPath();
    }

    public void setContentPath(String contentPath) {
        this.kernelHeaders.setContentPath(contentPath);
        this.storageHeaders.withContentPath(contentPath);
    }

    public String getHeadersVersion() {
        return this.kernelHeaders.getHeadersVersion();
    }

    public void setHeadersVersion(String headersVersion) {
        this.kernelHeaders.setHeadersVersion(headersVersion);
        this.storageHeaders.withHeadersVersion(headersVersion);
    }

    public String getStorageRelativePath() {
        return this.kernelHeaders.getStorageRelativePath();
    }
}

