/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.persistence.ocfl.impl;

import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.RdfSourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.operations.ResourceOperationType;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.ocfl.api.FedoraToOcflObjectIndex;
import org.fcrepo.persistence.ocfl.impl.AbstractRdfSourcePersister;
import org.fcrepo.persistence.ocfl.impl.FedoraOcflMapping;
import org.fcrepo.persistence.ocfl.impl.OcflPersistentStorageSession;
import org.fcrepo.storage.ocfl.OcflObjectSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateRdfSourcePersister
extends AbstractRdfSourcePersister {
    private static final Logger log = LoggerFactory.getLogger(UpdateRdfSourcePersister.class);

    protected UpdateRdfSourcePersister(FedoraToOcflObjectIndex index) {
        super(RdfSourceOperation.class, ResourceOperationType.UPDATE, index);
    }

    @Override
    public void persist(OcflPersistentStorageSession session, ResourceOperation operation) throws PersistentStorageException {
        FedoraId resourceId = operation.getResourceId();
        log.debug("persisting {} to {}", (Object)resourceId, (Object)session);
        FedoraOcflMapping fedoraOcflMapping = this.getMapping(operation.getTransaction(), resourceId);
        String ocflId = fedoraOcflMapping.getOcflObjectId();
        OcflObjectSession objSession = session.findOrCreateSession(ocflId);
        this.persistRDF(objSession, operation, fedoraOcflMapping.getRootObjectIdentifier(), false);
    }
}

