/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.syndication;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jcr.RepositoryException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.xml.transform.stream.StreamSource;
import org.fcrepo.http.commons.AbstractResource;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;

@Component
@Path(value="/fcr:rss")
public class RSSPublisher
extends AbstractResource {
    private static final Integer FEED_LENGTH = 10;
    private static final String FEED_TYPE = "rss_2.0";
    private static final String FEED_TITLE = "What's happening in Fedora";
    private static final String FEED_DESCRIPTION = "What's happening in Fedora";
    private final BlockingQueue<FedoraEvent> feedQueue = new ArrayBlockingQueue<FedoraEvent>(FEED_LENGTH);
    private final SyndFeed feed = new SyndFeedImpl();
    private final Function<FedoraEvent, SyndEntry> event2entry = new Function<FedoraEvent, SyndEntry>(){

        public SyndEntry apply(FedoraEvent event) {
            SyndEntryImpl entry = new SyndEntryImpl();
            try {
                entry.setTitle(event.getIdentifier());
                entry.setLink(event.getPath());
                entry.setPublishedDate(new DateTime(event.getDate()).toDate());
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                description.setValue(event.getTypes().toString());
                entry.setDescription((SyndContent)description);
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
            return entry;
        }
    };

    @GET
    @Produces(value={"application/rss+xml"})
    public StreamSource getFeed() throws FeedException {
        this.feed.setLink(this.uriInfo.getBaseUri().toString());
        this.feed.setEntries(Lists.transform((List)ImmutableList.copyOf(this.feedQueue).reverse(), this.event2entry));
        return new StreamSource(new ByteArrayInputStream(new SyndFeedOutput().outputString(this.feed).getBytes(StandardCharsets.UTF_8)));
    }

    @PostConstruct
    public void initialize() {
        this.eventBus.register((Object)this);
        this.feed.setFeedType(FEED_TYPE);
        this.feed.setTitle("What's happening in Fedora");
        this.feed.setDescription("What's happening in Fedora");
    }

    @PreDestroy
    public void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void newEvent(FedoraEvent event) {
        if (this.feedQueue.remainingCapacity() > 0) {
            this.feedQueue.offer(event);
        } else {
            this.feedQueue.poll();
            this.feedQueue.offer(event);
        }
    }
}

