/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.search.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fcrepo.search.api.InvalidConditionExpressionException;

public class Condition {
    static final Pattern CONDITION_REGEX = Pattern.compile("([a-zA-Z0-9_]+)([><=]|<=|>=)([^><=].*)");
    private Field field;
    private Operator operator;
    private String object;

    private Condition(Field field, Operator operator, String object) {
        this.field = field;
        this.operator = operator;
        this.object = object;
    }

    public Field getField() {
        return this.field;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getObject() {
        return this.object;
    }

    public String toString() {
        return this.field.toString().toLowerCase() + this.operator + this.object;
    }

    public static Condition fromExpression(String expression) throws InvalidConditionExpressionException {
        Matcher m = CONDITION_REGEX.matcher(expression);
        if (m.matches()) {
            Field field = Field.fromString(m.group(1));
            Operator operation = Operator.fromString(m.group(2));
            String object = m.group(3);
            return Condition.fromEnums(field, operation, object);
        }
        throw new InvalidConditionExpressionException(expression);
    }

    public static Condition fromEnums(Field field, Operator operator, String expression) {
        return new Condition(field, operator, expression);
    }

    public static enum Field {
        FEDORA_ID,
        MODIFIED,
        CREATED,
        CONTENT_SIZE,
        MIME_TYPE,
        RDF_TYPE;


        public String toString() {
            return super.toString().toLowerCase();
        }

        public static Field fromString(String fieldStr) {
            return Field.valueOf(fieldStr.toUpperCase());
        }
    }

    public static enum Operator {
        LTE("<="),
        GTE(">="),
        EQ("="),
        GT(">"),
        LT("<");

        private String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getStringValue() {
            return this.value;
        }

        public static Operator fromString(String str) {
            for (Operator o : Operator.values()) {
                if (!o.value.equals(str)) continue;
                return o;
            }
            throw new IllegalArgumentException("Value " + str + " not recognized.");
        }
    }
}

