/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.search.impl;

import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.fcrepo.common.db.DbPlatform;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.search.api.Condition;
import org.fcrepo.search.api.InvalidQueryException;
import org.fcrepo.search.api.PaginationInfo;
import org.fcrepo.search.api.SearchIndex;
import org.fcrepo.search.api.SearchParameters;
import org.fcrepo.search.api.SearchResult;
import org.fcrepo.search.impl.InstantParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcInsert;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="searchIndexImpl")
public class DbSearchIndexImpl
implements SearchIndex {
    public static final String SELECT_RDF_TYPE_ID = "select id, rdf_type_uri from search_rdf_type where rdf_type_uri in (:rdf_type_uri)";
    private static final Logger LOGGER = LoggerFactory.getLogger(DbSearchIndexImpl.class);
    private static final String SIMPLE_SEARCH_TABLE = "simple_search";
    private static final String DELETE_FROM_INDEX_SQL = "DELETE FROM simple_search WHERE fedora_id = :fedora_id;";
    private static final String UPDATE_INDEX_SQL = "UPDATE simple_search SET modified = :modified, content_size = :content_size, mime_type =:mime_type WHERE fedora_id = :fedora_id;";
    private static final String SELECT_BY_FEDORA_ID = "SELECT id FROM simple_search WHERE fedora_id = :fedora_id";
    private static final String FEDORA_ID_PARAM = "fedora_id";
    private static final String MODIFIED_PARAM = "modified";
    private static final String CONTENT_SIZE_PARAM = "content_size";
    private static final String MIME_TYPE_PARAM = "mime_type";
    private static final String CREATED_PARAM = "created";
    private static final String DELETE_RDF_TYPE_ASSOCIATIONS = "DELETE FROM search_resource_rdf_type where resource_id = :resource_id";
    private static final String RDF_TYPE_TABLE = ", (SELECT rrt.resource_id,  group_concat_function as rdf_type from search_resource_rdf_type rrt, search_rdf_type rt  WHERE rrt.rdf_type_id = rt.id group by rrt.resource_id) r, (SELECT rrt.resource_id from search_resource_rdf_type rrt, search_rdf_type rt WHERE rt.rdf_type_uri like :rdf_type_uri and rrt.rdf_type_id = rt.id group by rrt.resource_id) r_filter";
    private static final String DEFAULT_DDL = "sql/default-search-index.sql";
    private static final Map<DbPlatform, String> DDL_MAP = Map.of(DbPlatform.MYSQL, "sql/default-search-index.sql", DbPlatform.H2, "sql/default-search-index.sql", DbPlatform.POSTGRESQL, "sql/postgresql-search-index.sql", DbPlatform.MARIADB, "sql/default-search-index.sql");
    public static final String SEARCH_RESOURCE_RDF_TYPE_TABLE = "search_resource_rdf_type";
    public static final String RESOURCE_ID_PARAM = "resource_id";
    public static final String RDF_TYPE_ID_PARAM = "rdf_type_id";
    public static final String RDF_TYPE_URI_PARAM = "rdf_type_uri";
    public static final String SEARCH_RDF_TYPE_TABLE = "search_rdf_type";
    public static final String ID_COLUMN = "id";
    private static final String GROUP_CONCAT_FUNCTION = "group_concat_function";
    private static final String POSTGRES_GROUP_CONCAT_FUNCTION = "STRING_AGG(rt.rdf_type_uri, ',')";
    private static final String DEFAULT_GROUP_CONCAT_FUNCTION = "GROUP_CONCAT(distinct rt.rdf_type_uri ORDER BY rt.rdf_type_uri ASC SEPARATOR ',')";
    private static final String INSERT_RDF_TYPE_ASSOC = "INSERT INTO search_resource_rdf_type (resource_id, rdf_type_id) VALUES (:resource_id, :rdf_type_id)";
    private static final String INSERT_RDF_TYPE_MYSQLMARIA = "INSERT IGNORE INTO search_rdf_type (rdf_type_uri) VALUES (:rdf_type_uri)";
    private static final String INSERT_RDF_TYPE_POSTGRES = "INSERT INTO search_rdf_type (rdf_type_uri) VALUES (:rdf_type_uri) ON CONFLICT DO NOTHING";
    private static final String INSERT_RDF_TYPE_H2 = "MERGE INTO search_rdf_type (rdf_type_uri) KEY (rdf_type_uri) VALUES (:rdf_type_uri)";
    private static final Map<DbPlatform, String> INSERT_RDF_TYPE = Map.of(DbPlatform.MYSQL, "INSERT IGNORE INTO search_rdf_type (rdf_type_uri) VALUES (:rdf_type_uri)", DbPlatform.MARIADB, "INSERT IGNORE INTO search_rdf_type (rdf_type_uri) VALUES (:rdf_type_uri)", DbPlatform.POSTGRESQL, "INSERT INTO search_rdf_type (rdf_type_uri) VALUES (:rdf_type_uri) ON CONFLICT DO NOTHING", DbPlatform.H2, "MERGE INTO search_rdf_type (rdf_type_uri) KEY (rdf_type_uri) VALUES (:rdf_type_uri)");
    @Inject
    private DataSource dataSource;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private SimpleJdbcInsert jdbcInsertResource;
    @Inject
    private ResourceFactory resourceFactory;
    private DbPlatform dbPlatForm;
    private String rdfTables;
    private static final RowMapper<RdfType> RDF_TYPE_ROW_MAPPER = (rs, rowNum) -> new RdfType(rs.getLong(ID_COLUMN), rs.getString(RDF_TYPE_URI_PARAM));

    @PostConstruct
    public void setup() {
        this.dbPlatForm = DbPlatform.fromDataSource((DataSource)this.dataSource);
        String ddl = this.lookupDdl();
        LOGGER.debug("Applying ddl: {}", (Object)ddl);
        DatabasePopulatorUtils.execute((DatabasePopulator)new ResourceDatabasePopulator(new Resource[]{new DefaultResourceLoader().getResource("classpath:" + ddl)}), (DataSource)this.dataSource);
        this.jdbcTemplate = this.getNamedParameterJdbcTemplate();
        this.jdbcInsertResource = new SimpleJdbcInsert(this.jdbcTemplate.getJdbcTemplate()).withTableName(SIMPLE_SEARCH_TABLE).usingGeneratedKeyColumns(new String[]{ID_COLUMN});
        this.rdfTables = RDF_TYPE_TABLE.replace(GROUP_CONCAT_FUNCTION, this.isPostgres() ? POSTGRES_GROUP_CONCAT_FUNCTION : DEFAULT_GROUP_CONCAT_FUNCTION);
    }

    private String lookupDdl() {
        return DDL_MAP.get(this.dbPlatForm);
    }

    private NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return new NamedParameterJdbcTemplate(this.dataSource);
    }

    public SearchResult doSearch(SearchParameters parameters) throws InvalidQueryException {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        ArrayList<String> whereClauses = new ArrayList<String>();
        List conditions = parameters.getConditions();
        for (int i = 0; i < conditions.size(); ++i) {
            this.addWhereClause(i, parameterSource, whereClauses, (Condition)conditions.get(i));
        }
        final List fields = parameters.getFields().stream().map(Condition.Field::toString).collect(Collectors.toList());
        boolean containsRDFTypeField = fields.contains(Condition.Field.RDF_TYPE.toString());
        if (containsRDFTypeField) {
            whereClauses.add("s.id = r.resource_id");
            whereClauses.add("r.resource_id = r_filter.resource_id");
        }
        StringBuilder sql = new StringBuilder("SELECT " + String.join((CharSequence)",", fields) + " FROM simple_search s");
        if (containsRDFTypeField) {
            sql.append(this.rdfTables);
            String rdfTypeUriParamValue = "*";
            for (Condition condition : conditions) {
                if (!condition.getField().equals((Object)Condition.Field.RDF_TYPE)) continue;
                rdfTypeUriParamValue = condition.getObject();
                break;
            }
            parameterSource.addValue(RDF_TYPE_URI_PARAM, (Object)this.convertToSqlLikeWildcard(rdfTypeUriParamValue));
        }
        if (!whereClauses.isEmpty()) {
            sql.append(" WHERE ");
            Iterator<String> it = whereClauses.iterator();
            while (it.hasNext()) {
                sql.append(it.next());
                if (!it.hasNext()) continue;
                sql.append(" AND ");
            }
        }
        sql.append(" ORDER BY " + parameters.getOrderBy() + " " + parameters.getOrder());
        sql.append(" LIMIT :limit OFFSET :offset");
        parameterSource.addValue("limit", (Object)parameters.getMaxResults());
        parameterSource.addValue("offset", (Object)parameters.getOffset());
        RowMapper<Map<String, Object>> rowMapper = new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String f : fields) {
                    String fieldStr = f.toString();
                    String[] value = rs.getObject(fieldStr);
                    if (value instanceof Timestamp) {
                        value = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(((Timestamp)value).getTime()));
                    } else if (f.equals(Condition.Field.RDF_TYPE.toString())) {
                        value = value.toString().split(",");
                    }
                    map.put(fieldStr, value);
                }
                return map;
            }
        };
        List items = this.jdbcTemplate.query(sql.toString(), (SqlParameterSource)parameterSource, (RowMapper)rowMapper);
        PaginationInfo pagination = new PaginationInfo(parameters.getMaxResults(), parameters.getOffset());
        LOGGER.debug("Search query with parameters: {} - {}", (Object)sql, (Object)parameters);
        return new SearchResult(items, pagination);
    }

    private void addWhereClause(int paramCount, MapSqlParameterSource parameterSource, List<String> whereClauses, Condition condition) throws InvalidQueryException {
        Condition.Field field = condition.getField();
        Condition.Operator operation = condition.getOperator();
        String object = condition.getObject();
        String paramName = "param" + paramCount;
        if ((field.equals((Object)Condition.Field.FEDORA_ID) || field.equals((Object)Condition.Field.MIME_TYPE)) && condition.getOperator().equals((Object)Condition.Operator.EQ)) {
            if (!object.equals("*")) {
                String whereClause;
                if (object.contains("*")) {
                    object = this.convertToSqlLikeWildcard(object);
                    whereClause = field + " like :" + paramName;
                } else {
                    whereClause = field + " = :" + paramName;
                }
                whereClauses.add("s." + whereClause);
                parameterSource.addValue(paramName, (Object)object);
            }
        } else if (field.equals((Object)Condition.Field.CREATED) || field.equals((Object)Condition.Field.MODIFIED)) {
            try {
                Instant instant = InstantParser.parse(object);
                whereClauses.add("s." + field + " " + operation.getStringValue() + " :" + paramName);
                parameterSource.addValue(paramName, (Object)new Timestamp(instant.toEpochMilli()), 93);
            }
            catch (Exception ex) {
                throw new InvalidQueryException(ex.getMessage());
            }
        } else if (field.equals((Object)Condition.Field.CONTENT_SIZE)) {
            try {
                whereClauses.add(field + " " + operation.getStringValue() + " :" + paramName);
                parameterSource.addValue(paramName, (Object)Long.parseLong(object), 4);
            }
            catch (Exception ex) {
                throw new InvalidQueryException(ex.getMessage());
            }
        } else if (!field.equals((Object)Condition.Field.RDF_TYPE) || !condition.getOperator().equals((Object)Condition.Operator.EQ)) {
            throw new InvalidQueryException("Condition not supported: \"" + condition + "\"");
        }
    }

    private String convertToSqlLikeWildcard(String value) {
        return value.replace("*", "%");
    }

    public void addUpdateIndex(ResourceHeaders resourceHeaders) {
        this.addUpdateIndex(null, resourceHeaders);
    }

    @Transactional
    public void addUpdateIndex(String txId, ResourceHeaders resourceHeaders) {
        FedoraId fedoraId = resourceHeaders.getId();
        String fullId = fedoraId.getFullId();
        if (fedoraId.isAcl() || fedoraId.isMemento()) {
            LOGGER.debug("The search index does not include acls or mementos. Ignoring resource {}", (Object)fullId);
            return;
        }
        MapSqlParameterSource selectParams = new MapSqlParameterSource();
        selectParams.addValue(FEDORA_ID_PARAM, (Object)fullId);
        List result = this.jdbcTemplate.queryForList(SELECT_BY_FEDORA_ID, (SqlParameterSource)selectParams);
        try {
            Long resourcePrimaryKey;
            boolean exists;
            FedoraResource fedoraResource = this.resourceFactory.getResource(txId, fedoraId);
            List rdfTypes = fedoraResource.getTypes();
            List<Long> rdfTypeIds = this.findOrCreateRdfTypesInDb(rdfTypes);
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue(FEDORA_ID_PARAM, (Object)fullId);
            params.addValue(MODIFIED_PARAM, (Object)new Timestamp(resourceHeaders.getLastModifiedDate().toEpochMilli()));
            params.addValue(MIME_TYPE_PARAM, (Object)resourceHeaders.getMimeType());
            params.addValue(CONTENT_SIZE_PARAM, (Object)resourceHeaders.getContentSize());
            boolean bl = exists = result.size() > 0;
            if (exists) {
                resourcePrimaryKey = (Long)((Map)result.get(0)).get(ID_COLUMN);
                this.jdbcTemplate.update(UPDATE_INDEX_SQL, (SqlParameterSource)params);
                this.deleteRdfTypeAssociations(resourcePrimaryKey);
            } else {
                params.addValue(CREATED_PARAM, (Object)new Timestamp(resourceHeaders.getCreatedDate().toEpochMilli()));
                resourcePrimaryKey = this.jdbcInsertResource.executeAndReturnKey((SqlParameterSource)params).longValue();
            }
            this.insertRdfTypeAssociations(rdfTypeIds, resourcePrimaryKey);
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException("Failed add/updated the search index for : " + fullId, (Throwable)e);
        }
    }

    private void insertRdfTypeAssociations(List<Long> rdfTypeIds, Long resourceId) {
        ArrayList<MapSqlParameterSource> parameterSourcesList = new ArrayList<MapSqlParameterSource>();
        for (Long rdfTypeId : rdfTypeIds) {
            MapSqlParameterSource assocParams = new MapSqlParameterSource();
            assocParams.addValue(RESOURCE_ID_PARAM, (Object)resourceId);
            assocParams.addValue(RDF_TYPE_ID_PARAM, (Object)rdfTypeId);
            parameterSourcesList.add(assocParams);
        }
        MapSqlParameterSource[] psArray = parameterSourcesList.toArray(new MapSqlParameterSource[0]);
        this.jdbcTemplate.batchUpdate(INSERT_RDF_TYPE_ASSOC, (SqlParameterSource[])psArray);
    }

    private void deleteRdfTypeAssociations(Long resourceId) {
        MapSqlParameterSource deleteParams = new MapSqlParameterSource();
        deleteParams.addValue(RESOURCE_ID_PARAM, (Object)resourceId);
        this.jdbcTemplate.update(DELETE_RDF_TYPE_ASSOCIATIONS, (SqlParameterSource)deleteParams);
    }

    private List<Long> findOrCreateRdfTypesInDb(List<URI> rdfTypes) {
        List rdfTypes_str = rdfTypes.stream().map(URI::toString).collect(Collectors.toList());
        List results = this.jdbcTemplate.query(SELECT_RDF_TYPE_ID, Map.of(RDF_TYPE_URI_PARAM, rdfTypes_str), RDF_TYPE_ROW_MAPPER);
        ArrayList<Long> rdfTypeIds = new ArrayList<Long>();
        HashSet<String> rdfTypeUris = new HashSet<String>();
        for (RdfType type : results) {
            rdfTypeIds.add(type.getTypeId());
            rdfTypeUris.add(type.getTypeUri());
        }
        Set missingUris = rdfTypes_str.stream().filter(t -> !rdfTypeUris.contains(t)).collect(Collectors.toSet());
        if (!missingUris.isEmpty()) {
            ArrayList<MapSqlParameterSource> parameterSourcesList = new ArrayList<MapSqlParameterSource>();
            for (String uri : missingUris) {
                LOGGER.debug("Adding rdf type uri: " + uri);
                MapSqlParameterSource ps = new MapSqlParameterSource();
                ps.addValue(RDF_TYPE_URI_PARAM, (Object)uri);
                parameterSourcesList.add(ps);
            }
            MapSqlParameterSource[] psArray = parameterSourcesList.toArray(new MapSqlParameterSource[0]);
            this.jdbcTemplate.batchUpdate(INSERT_RDF_TYPE.get(this.dbPlatForm), (SqlParameterSource[])psArray);
            List createdIds = this.jdbcTemplate.query(SELECT_RDF_TYPE_ID, Map.of(RDF_TYPE_URI_PARAM, missingUris), RDF_TYPE_ROW_MAPPER);
            if (createdIds.size() != missingUris.size()) {
                throw new RepositoryRuntimeException("Did not select all the items we inserted into the table");
            }
            rdfTypeIds.addAll(createdIds.stream().map(RdfType::getTypeId).collect(Collectors.toList()));
        }
        return rdfTypeIds;
    }

    public void removeFromIndex(FedoraId fedoraId) {
        try {
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue(FEDORA_ID_PARAM, (Object)fedoraId.getFullId());
            this.jdbcTemplate.update(DELETE_FROM_INDEX_SQL, (SqlParameterSource)params);
        }
        catch (DataAccessException ex) {
            throw new RepositoryRuntimeException("Failed to delete search index entry for " + fedoraId.getFullId());
        }
    }

    public void reset() {
        try (Connection conn = this.dataSource.getConnection();){
            Statement statement = conn.createStatement();
            for (String sql : this.toggleForeignKeyChecks(false)) {
                statement.addBatch(sql);
            }
            statement.addBatch(this.truncateTable(SEARCH_RDF_TYPE_TABLE));
            statement.addBatch(this.truncateTable(SEARCH_RESOURCE_RDF_TYPE_TABLE));
            statement.addBatch(this.truncateTable(SIMPLE_SEARCH_TABLE));
            for (String sql : this.toggleForeignKeyChecks(true)) {
                statement.addBatch(sql);
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            throw new RepositoryRuntimeException("Failed to truncate search index tables", (Throwable)e);
        }
    }

    private List<String> toggleForeignKeyChecks(boolean enable) {
        if (this.isPostgres()) {
            return Collections.EMPTY_LIST;
        }
        return List.of("SET FOREIGN_KEY_CHECKS = " + (enable ? 1 : 0) + ";");
    }

    private boolean isPostgres() {
        return this.dbPlatForm.equals((Object)DbPlatform.POSTGRESQL);
    }

    private String truncateTable(String tableName) {
        boolean addCascade = this.isPostgres();
        return "TRUNCATE TABLE " + tableName + (addCascade ? " CASCADE" : "") + ";";
    }

    private static class RdfType {
        private String typeUri;
        private Long typeId;

        public RdfType(Long id, String uri) {
            this.typeId = id;
            this.typeUri = uri;
        }

        public Long getTypeId() {
            return this.typeId;
        }

        public String getTypeUri() {
            return this.typeUri;
        }
    }
}

