/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.search.impl;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.search.api.InvalidQueryException;
import org.fcrepo.search.api.SearchIndex;
import org.fcrepo.search.api.SearchParameters;
import org.fcrepo.search.api.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="searchIndex")
public class SearchIndexMetrics
implements SearchIndex {
    private static final String METRIC_NAME = "fcrepo.db";
    private static final String DB = "db";
    private static final String SEARCH = "search";
    private static final String OPERATION = "operation";
    private static final Timer addUpdateIndexTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "search", "operation", "addUpdateIndex"});
    private static final Timer removeFromIndexTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "search", "operation", "removeFromIndex"});
    private static final Timer doSearchTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "search", "operation", "doSearch"});
    private static final Timer resetTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "search", "operation", "reset"});
    @Autowired
    @Qualifier(value="searchIndexImpl")
    private SearchIndex searchIndexImpl;

    public void addUpdateIndex(ResourceHeaders resourceHeaders) {
        addUpdateIndexTimer.record(() -> this.searchIndexImpl.addUpdateIndex(resourceHeaders));
    }

    public void addUpdateIndex(String dbTxId, ResourceHeaders resourceHeaders) {
        addUpdateIndexTimer.record(() -> this.searchIndexImpl.addUpdateIndex(dbTxId, resourceHeaders));
    }

    public void removeFromIndex(FedoraId fedoraId) {
        removeFromIndexTimer.record(() -> this.searchIndexImpl.removeFromIndex(fedoraId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResult doSearch(SearchParameters parameters) throws InvalidQueryException {
        Timer.Sample stopwatch = Timer.start();
        try {
            SearchResult searchResult = this.searchIndexImpl.doSearch(parameters);
            return searchResult;
        }
        finally {
            stopwatch.stop(doSearchTimer);
        }
    }

    public void reset() {
        resetTimer.record(() -> this.searchIndexImpl.reset());
    }
}

