/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.search.impl;

import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.models.ResourceHelper;
import org.fcrepo.kernel.api.observer.Event;
import org.fcrepo.kernel.api.observer.EventType;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.search.api.SearchIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SearchIndexUpdater {
    @Inject
    private EventBus eventBus;
    @Autowired
    @Qualifier(value="searchIndex")
    private SearchIndex searchIndex;
    @Inject
    private ResourceHelper resourceHelper;
    @Inject
    private PersistentStorageSessionManager persistentStorageSessionManager;
    private static Logger LOGGER = LoggerFactory.getLogger(SearchIndexUpdater.class);
    private static final Set<EventType> HANDLED_TYPES = Sets.newHashSet((Object[])new EventType[]{EventType.RESOURCE_CREATION, EventType.RESOURCE_MODIFICATION, EventType.RESOURCE_DELETION});

    @Subscribe
    @AllowConcurrentEvents
    public void onEvent(Event event) {
        LOGGER.debug("event={}", (Object)event);
        try {
            FedoraId fedoraId = event.getFedoraId();
            Set types = event.getTypes();
            if (types.contains(EventType.RESOURCE_DELETION) && !this.resourceHelper.doesResourceExist(null, fedoraId, false)) {
                this.searchIndex.removeFromIndex(fedoraId);
            } else if (types.contains(EventType.RESOURCE_CREATION) || types.contains(EventType.RESOURCE_MODIFICATION)) {
                PersistentStorageSession session = this.persistentStorageSessionManager.getReadOnlySession();
                ResourceHeaders headers = session.getHeaders(fedoraId, null);
                this.searchIndex.addUpdateIndex(headers);
            }
        }
        catch (PersistentStorageException e) {
            LOGGER.error("Failed to handle event: " + event, (Throwable)e);
        }
    }

    @PostConstruct
    public void register() {
        LOGGER.debug("Registering: {}", (Object)this.getClass().getCanonicalName());
        this.eventBus.register((Object)this);
    }

    @PreDestroy
    public void releaseConnections() {
        LOGGER.debug("Unregistering: {}", (Object)this.getClass().getCanonicalName());
        this.eventBus.unregister((Object)this);
    }
}

