/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.search.impl;

import com.google.common.collect.Sets;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.fcrepo.common.db.DbPlatform;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.search.api.Condition;
import org.fcrepo.search.api.InvalidQueryException;
import org.fcrepo.search.api.PaginationInfo;
import org.fcrepo.search.api.SearchIndex;
import org.fcrepo.search.api.SearchParameters;
import org.fcrepo.search.api.SearchResult;
import org.fcrepo.search.impl.InstantParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="searchIndexImpl")
public class DbSearchIndexImpl
implements SearchIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbSearchIndexImpl.class);
    private static final String TRANSACTION_ID_COLUMN = "transaction_id";
    private static final String SIMPLE_SEARCH_TABLE = "simple_search";
    private static final String SIMPLE_SEARCH_TRANSACTIONS_TABLE = "simple_search_transactions";
    private static final String SEARCH_RESOURCE_RDF_TYPE_TRANSACTIONS_TABLE = "search_resource_rdf_type_transactions";
    public static final String SEARCH_RESOURCE_RDF_TYPE_TABLE = "search_resource_rdf_type";
    public static final String SEARCH_RDF_TYPE_TABLE = "search_rdf_type";
    private static final String FEDORA_ID_COLUMN = "fedora_id";
    private static final String MODIFIED_COLUMN = "modified";
    private static final String CREATED_COLUMN = "created";
    private static final String CONTENT_SIZE_COLUMN = "content_size";
    private static final String MIME_TYPE_COLUMN = "mime_type";
    private static final String RESOURCE_ID_COLUMN = "resource_id";
    public static final String RDF_TYPE_ID_COLUMN = "rdf_type_id";
    public static final String ID_COLUMN = "id";
    private static final String OPERATION_COLUMN = "operation";
    private static final String RDF_TYPE_URI_COLUMN = "rdf_type_uri";
    private static final String FEDORA_ID_PARAM = "fedora_id";
    private static final String RESOURCE_ID_PARAM = "resource_id";
    private static final String RDF_TYPE_ID_PARAM = "rdf_type_id";
    private static final String MODIFIED_PARAM = "modified";
    private static final String CONTENT_SIZE_PARAM = "content_size";
    private static final String MIME_TYPE_PARAM = "mime_type";
    private static final String CREATED_PARAM = "created";
    public static final String RDF_TYPE_URI_PARAM = "rdf_type_uri";
    public static final String RESOURCE_SEARCH_ID_PARAM = "resource_search_id";
    public static final String TRANSACTION_ID_PARAM = "transaction_id";
    private static final String OPERATION_PARAM = "operation";
    private static final String RDF_TYPE_FILTER_SUB_TABLE = ", (SELECT rrt.resource_id from search_resource_rdf_type rrt, search_rdf_type rt, simple_search s WHERE rrt.rdf_type_id = rt.id and s.id = rrt.resource_id and rt.rdf_type_uri like :rdf_type_uri group by rrt.resource_id) r_filter";
    private static final String RDF_TYPES_SUB_TABLE = ", (SELECT rrt.resource_id,  group_concat_function as rdf_type  from search_resource_rdf_type rrt, search_rdf_type rt ,simple_search s WHERE rrt.rdf_type_id = rt.id group by rrt.resource_id) r ";
    private static final String POSTGRES_GROUP_CONCAT_FUNCTION = "STRING_AGG(b.rdf_type_uri, ',')";
    private static final String DEFAULT_GROUP_CONCAT_FUNCTION = "GROUP_CONCAT(distinct b.rdf_type_uri ORDER BY b.rdf_type_uri ASC SEPARATOR ',')";
    private static final String UPSERT_SIMPLE_SEARCH_TRANSACTION_H2 = "MERGE INTO simple_search_transactions (modified,created, content_size,mime_type,fedora_id,operation, transaction_id) KEY (fedora_id, transaction_id) VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id, :operation, :transaction_id)";
    private static final String UPSERT_SIMPLE_SEARCH_H2 = "MERGE INTO simple_search (modified,created, content_size,mime_type,fedora_id) KEY (fedora_id) VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id)";
    private static final String UPSERT_SIMPLE_SEARCH_TRANSACTION_MYSQL_MARIA = "INSERT INTO simple_search_transactions (modified,created, content_size,mime_type,fedora_id,operation, transaction_id)  VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id, :operation, :transaction_id) ON DUPLICATE KEY UPDATE modified = VALUES(modified), created= VALUES(created),content_size= VALUES(content_size),mime_type= VALUES(mime_type),operation= VALUES(operation)";
    private static final String UPSERT_SIMPLE_SEARCH_MYSQL_MARIA = "INSERT INTO simple_search (modified,created, content_size,mime_type,fedora_id)  VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id) ON DUPLICATE KEY UPDATE modified = VALUES(modified), created= VALUES(created),content_size= VALUES(content_size),mime_type= VALUES(mime_type)";
    private static final String UPSERT_SIMPLE_SEARCH_TRANSACTION_POSTGRESQL = "INSERT INTO simple_search_transactions (modified,created, content_size,mime_type,fedora_id,operation, transaction_id)  VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id, :operation, :transaction_id) ON CONFLICT ( fedora_id, transaction_id) DO UPDATE SET modified = EXCLUDED.modified, created = EXCLUDED.created, content_size = EXCLUDED.content_size, mime_type = EXCLUDED.mime_type, operation = EXCLUDED.operation";
    private static final String UPSERT_SIMPLE_SEARCH_POSTGRESQL = "INSERT INTO simple_search (modified,created, content_size,mime_type,fedora_id)  VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id) ON CONFLICT ( fedora_id) DO UPDATE SET modified = EXCLUDED.modified, created = EXCLUDED.created, content_size = EXCLUDED.content_size, mime_type = EXCLUDED.mime_type";
    private static final String UPSERT_COMMIT_SIMPLE_SEARCH_H2 = "MERGE INTO simple_search (modified,created, content_size,mime_type, fedora_id) KEY (fedora_id) SELECT modified, created, content_size,mime_type, fedora_id FROM simple_search_transactions WHERE transaction_id= :transaction_id AND operation='add'";
    private static final String UPSERT_COMMIT_SIMPLE_SEARCH_MYSQL_MARIA = "INSERT INTO simple_search (modified,created, content_size,mime_type, fedora_id) SELECT modified, created, content_size,mime_type, fedora_id FROM simple_search_transactions a WHERE transaction_id= :transaction_id AND operation='add' ON DUPLICATE KEY UPDATE modified = a.modified, created = a.created, content_size = a.content_size, mime_type = a.mime_type";
    private static final String UPSERT_COMMIT_SIMPLE_SEARCH_POSTGRESQL = "INSERT INTO simple_search (modified,created, content_size,mime_type, fedora_id) SELECT modified, created, content_size,mime_type, fedora_id FROM simple_search_transactions WHERE transaction_id= :transaction_id AND operation='add' ON CONFLICT (fedora_id) DO UPDATE SET modified = EXCLUDED.modified, created = EXCLUDED.created, content_size = EXCLUDED.content_size, mime_type = EXCLUDED.mime_type";
    private static final String COMMIT_RDF_TYPES = "INSERT INTO search_rdf_type (rdf_type_uri) SELECT distinct rdf_type_uri FROM search_resource_rdf_type_transactions WHERE transaction_id= :transaction_id AND rdf_type_uri NOT IN (SELECT rdf_type_uri FROM search_rdf_type)";
    private static final String INSERT_RDF_TYPE = "INSERT INTO search_rdf_type (rdf_type_uri) VALUES (:rdf_type_uri)";
    private static final String INSERT_RDF_TYPE_POSTGRES = "INSERT INTO search_rdf_type (rdf_type_uri) VALUES (:rdf_type_uri) ON CONFLICT (rdf_type_uri) DO NOTHING";
    private static final String COMMIT_RDF_TYPE_ASSOCIATIONS = "INSERT INTO search_resource_rdf_type (resource_id,rdf_type_id) SELECT a.id, b.id FROM simple_search a, search_rdf_type b, search_resource_rdf_type_transactions c WHERE c.transaction_id= :transaction_id AND b.rdf_type_uri= c.rdf_type_uri AND c.fedora_id = a.fedora_id GROUP BY a.id, b.id";
    private static final String COMMIT_DELETE_RESOURCES_IN_TRANSACTION = "DELETE FROM simple_search WHERE fedora_id IN (SELECT  fedora_id FROM simple_search_transactions WHERE transaction_id = :transaction_id AND operation = 'delete')";
    private static final String COMMIT_DELETE_RDF_TYPE_ASSOCIATIONS = "DELETE FROM search_resource_rdf_type where resource_id in (SELECT a.id FROM simple_search a, simple_search_transactions b  WHERE a.fedora_id= b.fedora_id AND b.transaction_id= :transaction_id)";
    private static final String DELETE_TRANSACTION = "DELETE FROM simple_search_transactions WHERE transaction_id = :transaction_id";
    private static final String DELETE_RESOURCE_FROM_SEARCH = "DELETE FROM simple_search WHERE fedora_id = :fedora_id";
    private static final String DELETE_RDF_TYPE_ASSOCIATIONS_IN_TRANSACTION = "DELETE FROM search_resource_rdf_type_transactions WHERE transaction_id = :transaction_id";
    private static final Map<DbPlatform, String> DIRECT_UPSERT_MAPPING = Map.of(DbPlatform.H2, "MERGE INTO simple_search (modified,created, content_size,mime_type,fedora_id) KEY (fedora_id) VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id)", DbPlatform.MYSQL, "INSERT INTO simple_search (modified,created, content_size,mime_type,fedora_id)  VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id) ON DUPLICATE KEY UPDATE modified = VALUES(modified), created= VALUES(created),content_size= VALUES(content_size),mime_type= VALUES(mime_type)", DbPlatform.MARIADB, "INSERT INTO simple_search (modified,created, content_size,mime_type,fedora_id)  VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id) ON DUPLICATE KEY UPDATE modified = VALUES(modified), created= VALUES(created),content_size= VALUES(content_size),mime_type= VALUES(mime_type)", DbPlatform.POSTGRESQL, "INSERT INTO simple_search (modified,created, content_size,mime_type,fedora_id)  VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id) ON CONFLICT ( fedora_id) DO UPDATE SET modified = EXCLUDED.modified, created = EXCLUDED.created, content_size = EXCLUDED.content_size, mime_type = EXCLUDED.mime_type");
    private static final Map<DbPlatform, String> TRANSACTION_UPSERT_MAPPING = Map.of(DbPlatform.H2, "MERGE INTO simple_search_transactions (modified,created, content_size,mime_type,fedora_id,operation, transaction_id) KEY (fedora_id, transaction_id) VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id, :operation, :transaction_id)", DbPlatform.MYSQL, "INSERT INTO simple_search_transactions (modified,created, content_size,mime_type,fedora_id,operation, transaction_id)  VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id, :operation, :transaction_id) ON DUPLICATE KEY UPDATE modified = VALUES(modified), created= VALUES(created),content_size= VALUES(content_size),mime_type= VALUES(mime_type),operation= VALUES(operation)", DbPlatform.MARIADB, "INSERT INTO simple_search_transactions (modified,created, content_size,mime_type,fedora_id,operation, transaction_id)  VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id, :operation, :transaction_id) ON DUPLICATE KEY UPDATE modified = VALUES(modified), created= VALUES(created),content_size= VALUES(content_size),mime_type= VALUES(mime_type),operation= VALUES(operation)", DbPlatform.POSTGRESQL, "INSERT INTO simple_search_transactions (modified,created, content_size,mime_type,fedora_id,operation, transaction_id)  VALUES ( :modified, :created, :content_size, :mime_type,:fedora_id, :operation, :transaction_id) ON CONFLICT ( fedora_id, transaction_id) DO UPDATE SET modified = EXCLUDED.modified, created = EXCLUDED.created, content_size = EXCLUDED.content_size, mime_type = EXCLUDED.mime_type, operation = EXCLUDED.operation");
    private static final Map<DbPlatform, String> UPSERT_COMMIT_MAPPING = Map.of(DbPlatform.H2, "MERGE INTO simple_search (modified,created, content_size,mime_type, fedora_id) KEY (fedora_id) SELECT modified, created, content_size,mime_type, fedora_id FROM simple_search_transactions WHERE transaction_id= :transaction_id AND operation='add'", DbPlatform.MYSQL, "INSERT INTO simple_search (modified,created, content_size,mime_type, fedora_id) SELECT modified, created, content_size,mime_type, fedora_id FROM simple_search_transactions a WHERE transaction_id= :transaction_id AND operation='add' ON DUPLICATE KEY UPDATE modified = a.modified, created = a.created, content_size = a.content_size, mime_type = a.mime_type", DbPlatform.MARIADB, "INSERT INTO simple_search (modified,created, content_size,mime_type, fedora_id) SELECT modified, created, content_size,mime_type, fedora_id FROM simple_search_transactions a WHERE transaction_id= :transaction_id AND operation='add' ON DUPLICATE KEY UPDATE modified = a.modified, created = a.created, content_size = a.content_size, mime_type = a.mime_type", DbPlatform.POSTGRESQL, "INSERT INTO simple_search (modified,created, content_size,mime_type, fedora_id) SELECT modified, created, content_size,mime_type, fedora_id FROM simple_search_transactions WHERE transaction_id= :transaction_id AND operation='add' ON CONFLICT (fedora_id) DO UPDATE SET modified = EXCLUDED.modified, created = EXCLUDED.created, content_size = EXCLUDED.content_size, mime_type = EXCLUDED.mime_type");
    private static final String INSERT_RDF_TYPE_ASSOC_IN_TRANSACTION = "INSERT INTO search_resource_rdf_type_transactions (fedora_id, rdf_type_uri, transaction_id) VALUES (:fedora_id, :rdf_type_uri, :transaction_id)";
    private static final String SELECT_RESOURCE_SEARCH_ID = "SELECT id FROM simple_search WHERE fedora_id = :fedora_id";
    private static final String SELECT_RDF_TYPE_ID = "SELECT id FROM search_rdf_type WHERE rdf_type_uri= :rdf_type_uri";
    private static final String INSERT_RDF_TYPE_ASSOC = "INSERT INTO search_resource_rdf_type (resource_id, rdf_type_id) VALUES (:resource_search_id, :rdf_type_id)";
    private static final String DELETE_RESOURCE_TYPE_ASSOCIATIONS_IN_TRANSACTION = "DELETE FROM search_resource_rdf_type_transactions WHERE fedora_id= :fedora_id AND transaction_id= :transaction_id";
    private static final String DELETE_RDF_TYPE_ASSOCIATIONS = "DELETE FROM search_resource_rdf_type WHERE resource_id = (SELECT id FROM simple_search WHERE fedora_id = :fedora_id)";
    private static final List<String> COUNT_QUERY_COLUMNS = Arrays.asList("count(0) as count");
    @Inject
    private DataSource dataSource;
    private NamedParameterJdbcTemplate jdbcTemplate;
    @Inject
    private ResourceFactory resourceFactory;
    private DbPlatform dbPlatForm;
    private final Map<URI, Long> rdfTypeIdCache = new ConcurrentHashMap<URI, Long>();

    @PostConstruct
    public void setup() {
        this.dbPlatForm = DbPlatform.fromDataSource((DataSource)this.dataSource);
        this.jdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
    }

    public SearchResult doSearch(SearchParameters parameters) throws InvalidQueryException {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        List<String> fields = parameters.getFields().stream().map(Condition.Field::toString).collect(Collectors.toList());
        StringBuilder selectQuery = this.createSearchQuery(parameters, parameterSource, fields, false);
        RowMapper<Map<String, Object>> rowMapper = this.createRowMapper(fields);
        Integer totalResults = -1;
        if (parameters.isIncludeTotalResultCount()) {
            StringBuilder countQuery = this.createSearchQuery(parameters, parameterSource, Collections.emptyList(), true);
            LOGGER.debug("countQuery={}, parameterSource={}", (Object)countQuery, (Object)parameterSource);
            totalResults = (Integer)this.jdbcTemplate.queryForObject(countQuery.toString(), (SqlParameterSource)parameterSource, Integer.class);
        }
        String selectQueryStr = selectQuery.toString();
        LOGGER.debug("selectQueryStr={}, parameterSource={}", (Object)selectQueryStr, (Object)parameterSource);
        List items = this.jdbcTemplate.query(selectQueryStr, (SqlParameterSource)parameterSource, rowMapper);
        PaginationInfo pagination = new PaginationInfo(parameters.getMaxResults(), parameters.getOffset(), totalResults != null ? totalResults : 0);
        LOGGER.debug("Search query with parameters: {} - {}", (Object)selectQuery.toString(), (Object)parameters);
        return new SearchResult(items, pagination);
    }

    private RowMapper<Map<String, Object>> createRowMapper(final List<String> fields) {
        return new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String fieldStr : fields) {
                    String[] value = rs.getObject(fieldStr);
                    if (value instanceof Timestamp) {
                        value = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(((Timestamp)value).getTime()));
                    } else if (fieldStr.equals(Condition.Field.RDF_TYPE.toString())) {
                        value = value.toString().split(",");
                    }
                    map.put(fieldStr, value);
                }
                return map;
            }
        };
    }

    private StringBuilder createSearchQuery(SearchParameters parameters, MapSqlParameterSource parameterSource, List<String> selectedFields, boolean isCountQuery) throws InvalidQueryException {
        ArrayList<String> queryFields = new ArrayList<String>(selectedFields);
        String fedoraIdStr = Condition.Field.FEDORA_ID.toString();
        if (!isCountQuery) {
            if (!queryFields.contains(fedoraIdStr)) {
                queryFields.add(0, fedoraIdStr);
            }
            queryFields.add(0, ID_COLUMN);
        } else {
            queryFields.add("count(0)");
        }
        ArrayList<String> whereClauses = new ArrayList<String>();
        List conditions = parameters.getConditions();
        ArrayList<String> fields = new ArrayList<String>(queryFields);
        Condition rdfTypeConditionValue = conditions.stream().filter(c -> c.getField().equals((Object)Condition.Field.RDF_TYPE)).findFirst().orElse(null);
        boolean returnRdfType = fields.stream().anyMatch(x -> x.equals(Condition.Field.RDF_TYPE.toString()));
        List returnFields = fields.stream().filter(x -> !x.equals(Condition.Field.RDF_TYPE.toString())).collect(Collectors.toList());
        StringBuilder sql = new StringBuilder("").append("SELECT ").append(String.join((CharSequence)",", returnFields));
        sql.append(" FROM ").append(SIMPLE_SEARCH_TABLE).append(" s ");
        if (rdfTypeConditionValue != null) {
            String rdfTypeOperator = rdfTypeConditionValue.getObject().contains("*") ? " LIKE " : " = ";
            sql.append(", (SELECT ").append("resource_id").append(" FROM ").append(SEARCH_RESOURCE_RDF_TYPE_TABLE).append(" WHERE ").append("rdf_type_id").append(" IN (").append("SELECT ID FROM ").append(SEARCH_RDF_TYPE_TABLE).append(" WHERE ").append("rdf_type_uri").append(rdfTypeOperator).append(":").append("rdf_type_uri").append(")) rdf_type_filter ");
            whereClauses.add("rdf_type_filter.resource_id = s.id");
            this.addRdfTypeParam(parameterSource, conditions);
        }
        for (int i = 0; i < conditions.size(); ++i) {
            this.addWhereClause(i, parameterSource, whereClauses, (Condition)conditions.get(i));
        }
        if (!whereClauses.isEmpty()) {
            sql.append(" WHERE ");
            Iterator<String> it = whereClauses.iterator();
            while (it.hasNext()) {
                sql.append(it.next());
                if (!it.hasNext()) continue;
                sql.append(" AND ");
            }
        }
        if (isCountQuery) {
            return sql;
        }
        if (parameters.getOrderBy() != null) {
            sql.append(" ORDER BY ").append(parameters.getOrderBy()).append(" ").append(parameters.getOrder());
        }
        sql.append(" LIMIT :limit OFFSET :offset");
        parameterSource.addValue("limit", (Object)parameters.getMaxResults());
        parameterSource.addValue("offset", (Object)parameters.getOffset());
        if (!returnRdfType) {
            return sql;
        }
        StringBuilder rdfTypeWrapperSql = new StringBuilder();
        rdfTypeWrapperSql.append("SELECT a.*, ").append(this.isPostgres() ? POSTGRES_GROUP_CONCAT_FUNCTION : DEFAULT_GROUP_CONCAT_FUNCTION).append(" as rdf_type").append(" FROM ").append("(").append((CharSequence)sql).append(") a, ").append("(SELECT rrt.resource_id , rt.rdf_type_uri FROM search_resource_rdf_type rrt, search_rdf_type rt WHERE  rrt.rdf_type_id = rt.id) b ").append("WHERE a.id = b.resource_id GROUP BY ").append(String.join((CharSequence)",", returnFields));
        if (parameters.getOrderBy() != null) {
            rdfTypeWrapperSql.append(" ORDER BY ").append(parameters.getOrderBy()).append(" ").append(parameters.getOrder());
        }
        return rdfTypeWrapperSql;
    }

    private void addRdfTypeParam(MapSqlParameterSource parameterSource, List<Condition> conditions) {
        String rdfTypeUriParamValue = "*";
        for (Condition condition : conditions) {
            if (!condition.getField().equals((Object)Condition.Field.RDF_TYPE)) continue;
            rdfTypeUriParamValue = condition.getObject();
            break;
        }
        parameterSource.addValue("rdf_type_uri", (Object)this.convertToSqlLikeWildcard(rdfTypeUriParamValue));
    }

    private void addWhereClause(int paramCount, MapSqlParameterSource parameterSource, List<String> whereClauses, Condition condition) throws InvalidQueryException {
        Condition.Field field = condition.getField();
        Condition.Operator operation = condition.getOperator();
        String object = condition.getObject();
        String paramName = "param" + paramCount;
        if ((field.equals((Object)Condition.Field.FEDORA_ID) || field.equals((Object)Condition.Field.MIME_TYPE)) && condition.getOperator().equals((Object)Condition.Operator.EQ)) {
            if (!object.equals("*")) {
                String whereClause;
                if (object.contains("*")) {
                    if ((object = this.convertToSqlLikeWildcard(object)).contains("_")) {
                        object = object.replaceAll("_", "\\\\_");
                    }
                    whereClause = String.valueOf(field) + " like :" + paramName;
                } else {
                    whereClause = String.valueOf(field) + " = :" + paramName;
                }
                whereClauses.add("s." + whereClause);
                parameterSource.addValue(paramName, (Object)object);
            }
        } else if (field.equals((Object)Condition.Field.CREATED) || field.equals((Object)Condition.Field.MODIFIED)) {
            try {
                Instant instant = InstantParser.parse(object);
                whereClauses.add("s." + String.valueOf(field) + " " + operation.getStringValue() + " :" + paramName);
                parameterSource.addValue(paramName, (Object)new Timestamp(instant.toEpochMilli()), 93);
            }
            catch (Exception ex) {
                throw new InvalidQueryException(ex.getMessage());
            }
        } else if (field.equals((Object)Condition.Field.CONTENT_SIZE)) {
            try {
                whereClauses.add(String.valueOf(field) + " " + operation.getStringValue() + " :" + paramName);
                parameterSource.addValue(paramName, (Object)Long.parseLong(object), 4);
            }
            catch (Exception ex) {
                throw new InvalidQueryException(ex.getMessage());
            }
        } else if (!field.equals((Object)Condition.Field.RDF_TYPE) || !condition.getOperator().equals((Object)Condition.Operator.EQ)) {
            throw new InvalidQueryException("Condition not supported: \"" + String.valueOf(condition) + "\"");
        }
    }

    private String convertToSqlLikeWildcard(String value) {
        return value.replace("*", "%");
    }

    public void addUpdateIndex(Transaction transaction, ResourceHeaders resourceHeaders) {
        FedoraId fedoraId = resourceHeaders.getId();
        if (fedoraId.isAcl() || fedoraId.isMemento()) {
            LOGGER.debug("The search index does not include acls or mementos. Ignoring resource {}", (Object)fedoraId.getFullId());
            return;
        }
        LOGGER.debug("Updating search index for {}", (Object)fedoraId);
        transaction.doInTx(() -> {
            if (!transaction.isShortLived()) {
                this.doUpsertWithTransaction(transaction, resourceHeaders, fedoraId);
            } else {
                this.doDirectUpsert(transaction, resourceHeaders, fedoraId);
            }
        });
    }

    private void doDirectUpsert(Transaction transaction, ResourceHeaders resourceHeaders, FedoraId fedoraId) {
        String fullId = fedoraId.getFullId();
        try {
            FedoraResource fedoraResource = this.resourceFactory.getResource(transaction, fedoraId);
            this.doUpsertIntoSimpleSearch(fedoraId, resourceHeaders);
            ArrayList<URI> rdfTypes = new ArrayList<URI>(Sets.newHashSet((Iterable)fedoraResource.getTypes()));
            Set<URI> newTypes = this.insertRdfTypes(rdfTypes);
            this.deleteRdfTypeAssociations(fedoraId);
            this.insertRdfTypeAssociations(rdfTypes, newTypes, fedoraId);
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException("Failed add/updated the search index for : " + fullId, (Throwable)e);
        }
    }

    private Set<URI> insertRdfTypes(List<URI> rdfTypes) {
        HashSet<URI> addTypes = new HashSet<URI>();
        rdfTypes.stream().filter(rdfType -> !this.rdfTypeIdCache.containsKey(rdfType)).forEach(rdfType -> {
            try {
                MapSqlParameterSource params = new MapSqlParameterSource();
                params.addValue("rdf_type_uri", (Object)rdfType.toString());
                if (this.isPostgres()) {
                    this.jdbcTemplate.update(INSERT_RDF_TYPE_POSTGRES, (SqlParameterSource)params);
                } else {
                    this.jdbcTemplate.update(INSERT_RDF_TYPE, (SqlParameterSource)params);
                }
                addTypes.add((URI)rdfType);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                // empty catch block
            }
        });
        return addTypes;
    }

    private void doUpsertWithTransaction(Transaction transaction, ResourceHeaders resourceHeaders, FedoraId fedoraId) {
        String fullId = fedoraId.getFullId();
        try {
            String txId = transaction.getId();
            FedoraResource fedoraResource = this.resourceFactory.getResource(transaction, fedoraId);
            this.doUpsertIntoTransactionTables(txId, fedoraId, resourceHeaders, "add");
            HashSet rdfTypes = Sets.newHashSet((Iterable)fedoraResource.getTypes());
            this.insertRdfTypeAssociationsInTransaction(rdfTypes, txId, fedoraId);
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException("Failed add/updated the search index for : " + fullId, (Throwable)e);
        }
    }

    private void doUpsertIntoTransactionTables(String txId, FedoraId fedoraId, ResourceHeaders resourceHeaders, String operation) {
        String mimetype = "";
        long contentSize = 0L;
        Instant modified = Instant.now();
        Instant created = Instant.now();
        if (resourceHeaders != null) {
            contentSize = resourceHeaders.getContentSize();
            mimetype = resourceHeaders.getMimeType();
            modified = resourceHeaders.getLastModifiedDate();
            created = resourceHeaders.getCreatedDate();
        }
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("fedora_id", (Object)fedoraId.getFullId());
        params.addValue("mime_type", (Object)mimetype);
        params.addValue("content_size", (Object)contentSize);
        params.addValue("created", (Object)this.formatInstant(created));
        params.addValue("modified", (Object)this.formatInstant(modified));
        params.addValue("operation", (Object)operation);
        params.addValue("transaction_id", (Object)txId);
        this.jdbcTemplate.update(TRANSACTION_UPSERT_MAPPING.get(this.dbPlatForm), (SqlParameterSource)params);
    }

    private void doUpsertIntoSimpleSearch(FedoraId fedoraId, ResourceHeaders resourceHeaders) {
        String mimetype = "";
        long contentSize = 0L;
        Instant modified = Instant.now();
        Instant created = Instant.now();
        if (resourceHeaders != null) {
            contentSize = resourceHeaders.getContentSize();
            mimetype = resourceHeaders.getMimeType();
            modified = resourceHeaders.getLastModifiedDate();
            created = resourceHeaders.getCreatedDate();
        }
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("fedora_id", (Object)fedoraId.getFullId());
        params.addValue("mime_type", (Object)mimetype);
        params.addValue("content_size", (Object)contentSize);
        params.addValue("created", (Object)this.formatInstant(created));
        params.addValue("modified", (Object)this.formatInstant(modified));
        this.jdbcTemplate.update(DIRECT_UPSERT_MAPPING.get(this.dbPlatForm), (SqlParameterSource)params);
    }

    private Timestamp formatInstant(Instant instant) {
        if (instant == null) {
            return null;
        }
        return Timestamp.from(instant.truncatedTo(ChronoUnit.MILLIS));
    }

    private void insertRdfTypeAssociationsInTransaction(Set<URI> rdfTypes, String txId, FedoraId fedoraId) {
        ArrayList<MapSqlParameterSource> parameterSourcesList = new ArrayList<MapSqlParameterSource>(rdfTypes.size());
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("transaction_id", (Object)txId);
        parameterSource.addValue("fedora_id", (Object)fedoraId.getFullId());
        this.jdbcTemplate.update(DELETE_RESOURCE_TYPE_ASSOCIATIONS_IN_TRANSACTION, (SqlParameterSource)parameterSource);
        for (URI rdfType : rdfTypes) {
            MapSqlParameterSource assocParams = new MapSqlParameterSource();
            assocParams.addValue("transaction_id", (Object)txId);
            assocParams.addValue("fedora_id", (Object)fedoraId.getFullId());
            assocParams.addValue("rdf_type_uri", (Object)rdfType.toString());
            parameterSourcesList.add(assocParams);
        }
        MapSqlParameterSource[] psArray = parameterSourcesList.toArray(new MapSqlParameterSource[0]);
        this.jdbcTemplate.batchUpdate(INSERT_RDF_TYPE_ASSOC_IN_TRANSACTION, (SqlParameterSource[])psArray);
    }

    private void deleteRdfTypeAssociations(FedoraId fedoraId) {
        MapSqlParameterSource deleteParams = new MapSqlParameterSource();
        deleteParams.addValue("fedora_id", (Object)fedoraId.getFullId());
        this.jdbcTemplate.update(DELETE_RDF_TYPE_ASSOCIATIONS, (SqlParameterSource)deleteParams);
    }

    private void insertRdfTypeAssociations(List<URI> rdfTypes, Set<URI> newTypes, FedoraId fedoraId) {
        Long resourceSearchId = (Long)this.jdbcTemplate.queryForObject(SELECT_RESOURCE_SEARCH_ID, Map.of("fedora_id", fedoraId.getFullId()), Long.class);
        ArrayList<MapSqlParameterSource> parameterSourcesList = new ArrayList<MapSqlParameterSource>();
        for (URI rdfType : rdfTypes) {
            Long rdfTypeId = newTypes.contains(rdfType) ? this.getRdfTypeIdDirect(rdfType) : this.getRdfTypeIdCached(rdfType);
            MapSqlParameterSource assocParams = new MapSqlParameterSource();
            assocParams.addValue(RESOURCE_SEARCH_ID_PARAM, (Object)resourceSearchId);
            assocParams.addValue("rdf_type_id", (Object)rdfTypeId);
            parameterSourcesList.add(assocParams);
        }
        MapSqlParameterSource[] psArray = parameterSourcesList.toArray(new MapSqlParameterSource[0]);
        this.jdbcTemplate.batchUpdate(INSERT_RDF_TYPE_ASSOC, (SqlParameterSource[])psArray);
    }

    private Long getRdfTypeIdCached(URI rdfType) {
        return this.rdfTypeIdCache.computeIfAbsent(rdfType, this::getRdfTypeIdDirect);
    }

    private Long getRdfTypeIdDirect(URI rdfType) {
        return (Long)this.jdbcTemplate.queryForObject(SELECT_RDF_TYPE_ID, Map.of("rdf_type_uri", rdfType.toString()), Long.class);
    }

    public void removeFromIndex(Transaction transaction, FedoraId fedoraId) {
        transaction.doInTx(() -> {
            if (!transaction.isShortLived()) {
                try {
                    this.doUpsertIntoTransactionTables(transaction.getId(), fedoraId, null, "delete");
                }
                catch (Exception e) {
                    throw new RepositoryRuntimeException("Failed to remove " + String.valueOf(fedoraId) + " from search index", (Throwable)e);
                }
            } else {
                this.doDirectRemove(fedoraId);
            }
        });
    }

    private void doDirectRemove(FedoraId fedoraId) {
        this.deleteRdfTypeAssociations(fedoraId);
        this.deleteResource(fedoraId);
    }

    private void deleteResource(FedoraId fedoraId) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("fedora_id", (Object)fedoraId.getFullId());
        this.jdbcTemplate.update(DELETE_RESOURCE_FROM_SEARCH, (SqlParameterSource)params);
    }

    public void reset() {
        this.rdfTypeIdCache.clear();
        this.executeTruncationBatches(SEARCH_RESOURCE_RDF_TYPE_TABLE, SEARCH_RDF_TYPE_TABLE, SIMPLE_SEARCH_TABLE, SEARCH_RESOURCE_RDF_TYPE_TRANSACTIONS_TABLE, SIMPLE_SEARCH_TRANSACTIONS_TABLE);
    }

    private void executeTruncationBatches(String ... truncateQueries) {
        try (Connection conn = this.dataSource.getConnection();
             Statement statement = conn.createStatement();){
            for (String sql : this.toggleForeignKeyChecks(false)) {
                statement.addBatch(sql);
            }
            for (String query : truncateQueries) {
                statement.addBatch(this.truncateTable(query));
            }
            for (String sql : this.toggleForeignKeyChecks(true)) {
                statement.addBatch(sql);
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            throw new RepositoryRuntimeException("Failed to truncate search index tables", (Throwable)e);
        }
    }

    public void clearAllTransactions() {
        this.executeTruncationBatches(SEARCH_RESOURCE_RDF_TYPE_TRANSACTIONS_TABLE, SIMPLE_SEARCH_TRANSACTIONS_TABLE);
    }

    public void commitTransaction(Transaction tx) {
        if (!tx.isShortLived()) {
            tx.ensureCommitting();
            String txId = tx.getId();
            try {
                MapSqlParameterSource parameterSource = new MapSqlParameterSource();
                parameterSource.addValue("transaction_id", (Object)txId);
                int deletedAssociations = this.jdbcTemplate.update(COMMIT_DELETE_RDF_TYPE_ASSOCIATIONS, (SqlParameterSource)parameterSource);
                int deletedResources = this.jdbcTemplate.update(COMMIT_DELETE_RESOURCES_IN_TRANSACTION, (SqlParameterSource)parameterSource);
                int addedRdfTypes = this.jdbcTemplate.update(COMMIT_RDF_TYPES, (SqlParameterSource)parameterSource);
                int addedResources = this.jdbcTemplate.update(UPSERT_COMMIT_MAPPING.get(this.dbPlatForm), (SqlParameterSource)parameterSource);
                int addRdfTypeAssociations = this.jdbcTemplate.update(COMMIT_RDF_TYPE_ASSOCIATIONS, (SqlParameterSource)parameterSource);
                this.cleanupTransaction(txId);
                LOGGER.debug("Commit of tx {} complete with {} resource adds, {} resource associations adds, {} rdf types adds{},  resource deletes, {} resource/rdf type associations deletes", new Object[]{txId, addedResources, addRdfTypeAssociations, addedRdfTypes, deletedResources, deletedAssociations});
            }
            catch (Exception e) {
                LOGGER.warn("Unable to commit search index transaction {}: {}", (Object)txId, (Object)e.getMessage());
                throw new RepositoryRuntimeException("Unable to commit search index transaction", (Throwable)e);
            }
        }
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public void rollbackTransaction(Transaction tx) {
        if (!tx.isShortLived()) {
            this.cleanupTransaction(tx.getId());
        }
    }

    private void cleanupTransaction(String txId) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("transaction_id", (Object)txId);
        this.jdbcTemplate.update(DELETE_TRANSACTION, (SqlParameterSource)parameterSource);
        this.jdbcTemplate.update(DELETE_RDF_TYPE_ASSOCIATIONS_IN_TRANSACTION, (SqlParameterSource)parameterSource);
        LOGGER.debug("Transaction data has been removed from the search transaction tables for txId={} ", (Object)txId);
    }

    private List<String> toggleForeignKeyChecks(boolean enable) {
        if (this.isPostgres()) {
            return Collections.emptyList();
        }
        if (this.isH2()) {
            return List.of("SET REFERENTIAL_INTEGRITY  " + (enable ? "TRUE" : "FALSE") + ";");
        }
        return List.of("SET FOREIGN_KEY_CHECKS = " + (enable ? 1 : 0) + ";");
    }

    private boolean isPostgres() {
        return this.dbPlatForm.equals((Object)DbPlatform.POSTGRESQL);
    }

    private boolean isH2() {
        return this.dbPlatForm.equals((Object)DbPlatform.H2);
    }

    private String truncateTable(String tableName) {
        boolean addCascade = this.isPostgres();
        return "TRUNCATE TABLE " + tableName + (addCascade ? " CASCADE" : "") + ";";
    }
}

