/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.search.impl;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;

public class InstantParser {
    private static final List<DateTimeFormatter> VALID_DATE_FORMATS = new ArrayList<DateTimeFormatter>();

    private InstantParser() {
    }

    public static Instant parse(String dateString) {
        for (DateTimeFormatter formatter : VALID_DATE_FORMATS) {
            try {
                TemporalAccessor temporalAccessor = formatter.parse(dateString);
                return Instant.from(temporalAccessor);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException("Invalid date format: \"" + dateString + "\"");
    }

    static {
        VALID_DATE_FORMATS.add(DateTimeFormatter.ISO_DATE_TIME);
        VALID_DATE_FORMATS.add(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        VALID_DATE_FORMATS.add(DateTimeFormatter.RFC_1123_DATE_TIME);
        ZoneOffset zoneId = ZoneOffset.UTC;
        VALID_DATE_FORMATS.add(new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").parseDefaulting(ChronoField.NANO_OF_DAY, 0L).toFormatter().withZone(zoneId));
        VALID_DATE_FORMATS.add(new DateTimeFormatterBuilder().appendPattern("yyyyMMdd").parseDefaulting(ChronoField.NANO_OF_DAY, 0L).toFormatter().withZone(zoneId));
        VALID_DATE_FORMATS.add(new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").parseDefaulting(ChronoField.NANO_OF_DAY, 0L).toFormatter().withZone(zoneId));
        VALID_DATE_FORMATS.add(new DateTimeFormatterBuilder().appendPattern("yyyyMMdd HH:mm:ss").parseDefaulting(ChronoField.NANO_OF_DAY, 0L).toFormatter().withZone(zoneId));
    }
}

