/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.security.http;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.server.security.jaas.auth.AuthHttpServletRequestWrapper;
import org.fcrepo.server.security.jaas.auth.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthZHttpRequestAttributesFilter
implements Filter {
    private Set<String> names;
    private String principalHeader;
    static final String FEDORA_ATTRIBUTES_KEY = "FEDORA_AUX_SUBJECT_ATTRIBUTES";
    private static final Logger logger = LoggerFactory.getLogger(AuthZHttpRequestAttributesFilter.class);

    public void setNames(String names) {
        this.names = new HashSet<String>(Arrays.asList(names.split(" ")));
    }

    public void setPrincipalHeader(String principalHeader) {
        this.principalHeader = principalHeader;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HashMap<String, String[]> subjectAttributes = new HashMap<String, String[]>();
        for (String name : this.names) {
            logger.debug("Looking for header with name: {}", (Object)name);
            HashSet<String> headervalues = new HashSet<String>();
            Enumeration retrievedheadervalues = req.getHeaders(name);
            while (retrievedheadervalues.hasMoreElements()) {
                logger.debug("Retrieved header with name: {}", (Object)name);
                String value = (String)retrievedheadervalues.nextElement();
                logger.debug("Now adding value: " + value + " to field " + name);
                headervalues.add(value);
            }
            subjectAttributes.put(name, headervalues.toArray(new String[0]));
        }
        String[] principalNames = (String[])subjectAttributes.get(this.principalHeader);
        if (this.isValid(principalNames).booleanValue()) {
            logger.debug("Trying to set principal to new Principal with name=" + principalNames[0]);
            UserPrincipal principal = new UserPrincipal(principalNames[0]);
            AuthHttpServletRequestWrapper authRequest = new AuthHttpServletRequestWrapper(req);
            authRequest.setUserPrincipal((Principal)principal);
            logger.debug("Principal has been set to " + principal);
            authRequest.setAttribute(FEDORA_ATTRIBUTES_KEY, subjectAttributes);
            if (logger.isDebugEnabled()) {
                logger.debug("Added " + subjectAttributes + " to " + FEDORA_ATTRIBUTES_KEY);
            }
            if (chain != null) {
                chain.doFilter((ServletRequest)authRequest, response);
            }
        } else if (chain != null) {
            chain.doFilter(request, response);
        }
    }

    private Boolean isValid(String[] principalnames) {
        logger.debug("Checking potential principal name.");
        if (principalnames == null) {
            logger.debug("Principal name was null!");
            return false;
        }
        if (0 == principalnames.length) {
            logger.debug("Principal name was an array of zero length!");
            return false;
        }
        if (principalnames.length > 1) {
            logger.error(new Exception("More than one principal for authentication found in HTTP request!").toString());
            return false;
        }
        if (principalnames[0] == null || principalnames[0].length() == 0) {
            return false;
        }
        logger.debug("Principal name {} was valid!", (Object)principalnames[0]);
        return true;
    }

    public void init(FilterConfig config) throws ServletException {
        this.init();
    }

    public void init() throws ServletException {
        this.names.add(this.principalHeader);
        logger.info("Initializing {}", (Object)this.getClass().getName());
    }

    public void destroy() {
        logger.info("Destroying {}", (Object)this.getClass().getName());
    }

    public String getNames() {
        StringBuffer result = new StringBuffer();
        Iterator<String> iter = this.names.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append("");
        }
        return result.toString();
    }

    public String getPrincipalHeader() {
        return this.principalHeader;
    }
}

