/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp;

import com.sun.xacml.ConfigurationStore;
import com.sun.xacml.Indenter;
import com.sun.xacml.PDP;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.fcrepo.server.security.xacml.pdp.EvaluationException;
import org.fcrepo.server.security.xacml.pdp.MelcoePDP;
import org.fcrepo.server.security.xacml.pdp.MelcoePDPException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStore;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStoreException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStoreFactory;
import org.fcrepo.server.security.xacml.util.PopulatePolicyDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MelcoePDPImpl
implements MelcoePDP {
    private static final Logger logger = LoggerFactory.getLogger(MelcoePDPImpl.class);
    private static PolicyStore policyStore;
    private PDP pdp;

    public MelcoePDPImpl() throws MelcoePDPException {
        ConfigurationStore config = null;
        try {
            String home = PDP_HOME.getAbsolutePath();
            File f = null;
            String filename = null;
            try {
                PopulatePolicyDatabase.addDocuments(this.getPolicyStore());
            }
            catch (Exception e) {
                logger.error("Error loading bootstrap FeSL policies: " + e.getMessage(), (Throwable)e);
                throw new MelcoePDPException("Error loading bootstrap FeSL policies", e);
            }
            filename = home + "/conf/config-pdp.xml";
            f = new File(filename);
            if (!f.exists()) {
                throw new MelcoePDPException("Could not locate config file: " + f.getAbsolutePath());
            }
            logger.info("Loading config file: " + f.getAbsolutePath());
            config = new ConfigurationStore(f);
            this.pdp = new PDP(config.getDefaultPDPConfig());
            logger.info("PDP Instantiated and initialised!");
        }
        catch (Exception e) {
            logger.error("Could not initialise PDP: " + e.getMessage(), (Throwable)e);
            throw new MelcoePDPException("Could not initialise PDP: " + e.getMessage(), e);
        }
    }

    @Override
    public String evaluate(String request) throws EvaluationException {
        logger.debug("evaluating request: {}", (Object)request);
        RequestCtx req = null;
        ByteArrayInputStream is = new ByteArrayInputStream(request.getBytes());
        try {
            req = RequestCtx.getInstance((InputStream)is);
        }
        catch (ParsingException pe) {
            logger.error("Error parsing request:\n" + request, (Throwable)pe);
            throw new EvaluationException("Error parsing request:\n" + request);
        }
        ResponseCtx res = this.pdp.evaluate(req);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        res.encode((OutputStream)os, new Indenter());
        logger.debug("response is: {}", (Object)os.toString());
        return os.toString();
    }

    @Override
    public String evaluateBatch(String[] requests) throws EvaluationException {
        logger.debug("evaluating request batch");
        HashSet results = new HashSet();
        for (String req : requests) {
            ResponseCtx resCtx = null;
            String response = this.evaluate(req);
            ByteArrayInputStream is = new ByteArrayInputStream(response.getBytes());
            try {
                resCtx = ResponseCtx.getInstance((InputStream)is);
            }
            catch (ParsingException pe) {
                logger.error("Error parsing response:\n" + response, (Throwable)pe);
                throw new EvaluationException("Error parsing response:\n" + response);
            }
            Set r = resCtx.getResults();
            results.addAll(r);
        }
        ResponseCtx combinedResponse = new ResponseCtx(results);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        combinedResponse.encode((OutputStream)os, new Indenter());
        return os.toString();
    }

    private synchronized PolicyStore getPolicyStore() throws PolicyStoreException {
        if (policyStore != null) {
            return policyStore;
        }
        PolicyStoreFactory f = new PolicyStoreFactory();
        policyStore = f.newPolicyStore();
        return policyStore;
    }
}

