/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.data;

import com.sleepycat.db.DeadlockException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.dbxml.XmlContainer;
import com.sleepycat.dbxml.XmlContainerConfig;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlIndexSpecification;
import com.sleepycat.dbxml.XmlManager;
import com.sleepycat.dbxml.XmlManagerConfig;
import com.sleepycat.dbxml.XmlUpdateContext;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fcrepo.server.security.xacml.pdp.MelcoePDP;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DbXmlManager {
    private static final Logger log = LoggerFactory.getLogger((String)DbXmlManager.class.getName());
    private static final String XACML20_POLICY_NS = "urn:oasis:names:tc:xacml:2.0:policy:schema:os";
    public String DB_HOME = null;
    public String CONTAINER = null;
    public Map<String, Map<String, String>> indexMap = null;
    public XmlManager manager = null;
    public XmlUpdateContext updateContext = null;
    public XmlContainer container = null;
    public Environment env = null;
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    public static final Lock readLock = rwl.readLock();
    public static final Lock writeLock = rwl.writeLock();

    public DbXmlManager() throws PolicyStoreException {
        this.initConfig();
        File envHome = new File(this.DB_HOME);
        EnvironmentConfig envCfg = new EnvironmentConfig();
        envCfg.setAllowCreate(true);
        envCfg.setInitializeCache(true);
        envCfg.setInitializeLocking(false);
        envCfg.setInitializeLogging(true);
        envCfg.setTransactional(false);
        XmlManagerConfig managerCfg = new XmlManagerConfig();
        managerCfg.setAdoptEnvironment(true);
        managerCfg.setAllowExternalAccess(true);
        XmlContainerConfig containerCfg = new XmlContainerConfig();
        containerCfg.setAllowCreate(true);
        containerCfg.setTransactional(false);
        try {
            this.env = new Environment(envHome, envCfg);
            this.manager = new XmlManager(this.env, managerCfg);
            this.updateContext = this.manager.createUpdateContext();
        }
        catch (Exception e) {
            log.error("Error opening container: " + e.getMessage(), (Throwable)e);
            this.close();
            throw new PolicyStoreException(e.getMessage(), e);
        }
        try {
            if (this.manager.existsContainer(this.CONTAINER) == 0) {
                this.container = this.manager.createContainer(this.CONTAINER, containerCfg);
                XmlIndexSpecification is = this.container.getIndexSpecification();
                int idxType = 0;
                int syntaxType = 0;
                idxType |= 0x2000000;
                idxType |= 0x10000;
                syntaxType = 29;
                is.addIndex(XACML20_POLICY_NS, "AttributeValue", idxType |= 0x200, syntaxType);
                idxType = 0;
                idxType |= 0x1000000;
                idxType |= 0x30000;
                syntaxType = 0;
                is.addDefaultIndex(idxType |= 0x100, syntaxType);
                this.container.setIndexSpecification(is, this.updateContext);
            } else {
                this.container = this.manager.openContainer(this.CONTAINER, containerCfg);
            }
        }
        catch (XmlException e) {
            if (e.getDatabaseException() instanceof DeadlockException) {
                log.error("Caught deadlock exception, create/open container", (Throwable)e);
            }
            log.error("Could not start database subsystem.", (Throwable)e);
            this.close();
            throw new PolicyStoreException(e.getMessage(), e);
        }
        log.info("Opened Container: " + this.CONTAINER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        readLock.lock();
        try {
            if (this.container != null) {
                try {
                    this.container.close();
                    this.container = null;
                    log.info("Closed container");
                }
                catch (XmlException e) {
                    log.warn("close failed: " + e.getMessage(), (Throwable)e);
                }
            }
            if (this.manager != null) {
                try {
                    this.manager.close();
                    this.manager = null;
                    log.info("Closed manager");
                }
                catch (XmlException e) {
                    log.warn("close failed: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDatabase() {
        readLock.lock();
        try {
            try {
                this.container.close();
                this.container = null;
            }
            catch (XmlException e) {
                log.warn("Error closing container " + e.getMessage());
            }
            try {
                this.manager.removeContainer(this.CONTAINER);
            }
            catch (XmlException e) {
                log.warn("Error removing container " + e.getMessage());
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void initConfig() throws PolicyStoreException {
        if (log.isDebugEnabled()) {
            Runtime runtime = Runtime.getRuntime();
            log.debug("Total memory: " + runtime.totalMemory() / 1024L);
            log.debug("Free memory: " + runtime.freeMemory() / 1024L);
            log.debug("Max memory: " + runtime.maxMemory() / 1024L);
        }
        try {
            String home = MelcoePDP.PDP_HOME.getAbsolutePath();
            String filename = home + "/conf/config-dbxml.xml";
            File f = new File(filename);
            if (!f.exists()) {
                throw new PolicyStoreException("Could not locate config file: " + f.getAbsolutePath());
            }
            log.info("Loading config file: " + f.getAbsolutePath());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(new FileInputStream(f));
            NodeList nodes = null;
            nodes = doc.getElementsByTagName("database").item(0).getChildNodes();
            for (int x = 0; x < nodes.getLength(); ++x) {
                Node node = nodes.item(x);
                if (node.getNodeName().equals("directory")) {
                    this.DB_HOME = MelcoePDP.PDP_HOME.getAbsolutePath() + node.getAttributes().getNamedItem("name").getNodeValue();
                    File db_home = new File(this.DB_HOME);
                    if (!db_home.exists()) {
                        try {
                            db_home.mkdirs();
                        }
                        catch (Exception e) {
                            throw new PolicyStoreException("Could not create DB directory: " + db_home.getAbsolutePath());
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("[config] " + node.getNodeName() + ": " + db_home.getAbsolutePath());
                    }
                }
                if (!node.getNodeName().equals("container")) continue;
                this.CONTAINER = node.getAttributes().getNamedItem("name").getNodeValue();
                File conFile = new File(this.DB_HOME + "/" + this.CONTAINER);
                if (!log.isDebugEnabled()) continue;
                log.debug("[config] " + node.getNodeName() + ": " + conFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new PolicyStoreException("Could not initialise DBXML: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

