/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.data;

import com.sleepycat.dbxml.XmlDocument;
import com.sleepycat.dbxml.XmlDocumentConfig;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlQueryContext;
import com.sleepycat.dbxml.XmlQueryExpression;
import com.sleepycat.dbxml.XmlResults;
import com.sleepycat.dbxml.XmlValue;
import com.sun.xacml.EvaluationCtx;
import java.io.File;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.fcrepo.server.security.xacml.pdp.data.DbXmlManager;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndex;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStoreException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyUtils;
import org.fcrepo.server.security.xacml.pdp.data.XPathPolicyIndex;
import org.fcrepo.server.security.xacml.util.AttributeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbXmlPolicyIndex
extends XPathPolicyIndex
implements PolicyIndex {
    private static final Logger log = LoggerFactory.getLogger((String)DbXmlPolicyIndex.class.getName());
    private DbXmlManager dbXmlManager = null;
    private volatile long lastUpdate;
    private PolicyUtils utils;
    private Map<String, XmlQueryExpression> queries = null;

    protected DbXmlPolicyIndex() throws PolicyIndexException {
        this.init();
        this.queries = new ConcurrentHashMap<String, XmlQueryExpression>();
    }

    private void init() throws PolicyIndexException {
        try {
            this.dbXmlManager = new DbXmlManager();
        }
        catch (PolicyStoreException e) {
            throw new PolicyIndexException("Error initialising DbXmlManager - " + e.getMessage(), e);
        }
        this.dbXmlManager.indexMap = this.indexMap;
        this.utils = new PolicyUtils();
    }

    @Override
    public Map<String, byte[]> getPolicies(EvaluationCtx eval) throws PolicyIndexException {
        long a = 0L;
        long b = 0L;
        long total = 0L;
        HashMap<String, byte[]> documents = new HashMap<String, byte[]>();
        XmlQueryExpression qe = null;
        XmlQueryContext context = null;
        try {
            a = System.nanoTime();
            Map<String, Set<AttributeBean>> attributeMap = this.getAttributeMap(eval);
            context = this.dbXmlManager.manager.createQueryContext();
            context.setDefaultCollection(this.dbXmlManager.CONTAINER);
            for (String prefix : namespaces.keySet()) {
                context.setNamespace(prefix, (String)namespaces.get(prefix));
            }
            int resourceComponentCount = 0;
            Map<String, String> variables = DbXmlPolicyIndex.getXpathVariables(attributeMap);
            for (String variable : variables.keySet()) {
                context.setVariableValue(variable, new XmlValue(variables.get(variable)));
                if (!variable.equals("urn:oasis:names:tc:xacml:1.0:resource:resource-id")) continue;
                ++resourceComponentCount;
            }
            qe = this.getQuery(attributeMap, context, resourceComponentCount);
        }
        catch (XmlException xe) {
            throw new PolicyIndexException("Error while constructing query", xe);
        }
        catch (URISyntaxException e) {
            throw new PolicyIndexException("Error while constructing query", e);
        }
        DbXmlManager.readLock.lock();
        try {
            b = System.nanoTime();
            total += b - a;
            if (log.isDebugEnabled()) {
                log.debug("Query prep. time: " + (b - a) + "ns");
            }
            a = System.nanoTime();
            XmlResults results = qe.execute(context);
            b = System.nanoTime();
            total += b - a;
            if (log.isDebugEnabled()) {
                log.debug("Query exec. time: " + (b - a) + "ns");
            }
            while (results.hasNext()) {
                XmlValue value = results.next();
                byte[] content = value.asDocument().getContent();
                if (content.length > 0) {
                    documents.put(value.asDocument().getName(), content);
                    continue;
                }
                throw new PolicyIndexException("Zero-length result found");
            }
            results.delete();
        }
        catch (XmlException xe) {
            log.error("Error getting query results." + xe.getMessage());
            throw new PolicyIndexException("Error getting query results." + xe.getMessage(), xe);
        }
        finally {
            DbXmlManager.readLock.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("Total exec. time: " + total + "ns");
        }
        return documents;
    }

    private XmlQueryExpression getQuery(Map<String, Set<AttributeBean>> attributeMap, XmlQueryContext context, int r) throws XmlException {
        StringBuilder sb = new StringBuilder();
        for (Set<AttributeBean> attributeBeans : attributeMap.values()) {
            sb.append(attributeBeans.size() + ":");
            for (AttributeBean bean : attributeBeans) {
                sb.append(bean.getValues().size() + "-");
            }
        }
        String hash = sb.toString() + r;
        XmlQueryExpression result = this.queries.get(hash);
        if (result != null) {
            return result;
        }
        String query = this.createQuery(attributeMap);
        if (log.isDebugEnabled()) {
            log.debug("Query [" + hash + "]:\n" + query);
        }
        result = this.dbXmlManager.manager.prepare(query, context);
        this.queries.put(hash, result);
        return result;
    }

    private String createQuery(Map<String, Set<AttributeBean>> attributeMap) {
        return "collection('" + this.dbXmlManager.CONTAINER + "')" + DbXmlPolicyIndex.getXpath(attributeMap);
    }

    @Override
    public String addPolicy(String name, String document) throws PolicyIndexException {
        String docName = null;
        DbXmlManager.writeLock.lock();
        try {
            XmlDocument doc = this.makeDocument(name, document);
            docName = doc.getName();
            log.debug("Adding document: " + docName);
            this.dbXmlManager.container.putDocument(doc, this.dbXmlManager.updateContext);
            this.setLastUpdate(System.currentTimeMillis());
        }
        catch (XmlException xe) {
            if (xe.getErrorCode() == 19) {
                throw new PolicyIndexException("Document already exists: " + docName);
            }
            throw new PolicyIndexException("Error adding policy: " + xe.getMessage(), xe);
        }
        finally {
            DbXmlManager.writeLock.unlock();
        }
        return docName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePolicy(String name) throws PolicyIndexException {
        block6: {
            log.debug("Deleting document: " + name);
            DbXmlManager.writeLock.lock();
            try {
                this.dbXmlManager.container.deleteDocument(name, this.dbXmlManager.updateContext);
                this.setLastUpdate(System.currentTimeMillis());
            }
            catch (XmlException xe) {
                if (xe.getDbError() == 11) {
                    log.warn("Error deleting document: " + name + " - document does not exist");
                    break block6;
                }
                throw new PolicyIndexException("Error deleting document: " + name + xe.getMessage(), xe);
            }
            finally {
                DbXmlManager.writeLock.unlock();
            }
        }
        return true;
    }

    @Override
    public boolean updatePolicy(String name, String newDocument) throws PolicyIndexException {
        log.debug("Updating document: " + name);
        this.deletePolicy(name);
        this.addPolicy(name, newDocument);
        return true;
    }

    @Override
    public byte[] getPolicy(String name) throws PolicyIndexException {
        log.debug("Getting document: " + name);
        XmlDocument doc = null;
        DbXmlManager.readLock.lock();
        try {
            doc = this.dbXmlManager.container.getDocument(name);
            byte[] byArray = doc.getContent();
            return byArray;
        }
        catch (XmlException xe) {
            throw new PolicyIndexException("Error getting Policy: " + name + xe.getMessage() + " - " + xe.getDatabaseException().getMessage(), xe);
        }
        finally {
            DbXmlManager.readLock.unlock();
        }
    }

    @Override
    public boolean contains(String policyName) throws PolicyIndexException {
        log.debug("Determining if document exists: " + policyName);
        DbXmlManager.readLock.lock();
        try {
            this.dbXmlManager.container.getDocument(policyName, new XmlDocumentConfig().setLazyDocs(true));
        }
        catch (XmlException e) {
            if (e.getErrorCode() == 11) {
                boolean bl = false;
                return bl;
            }
            throw new PolicyIndexException("Error executing contains. " + e.getMessage(), e);
        }
        finally {
            DbXmlManager.readLock.unlock();
        }
        return true;
    }

    private XmlDocument makeDocument(String name, String document) throws XmlException, PolicyIndexException {
        Map<String, String> metadata = this.utils.getDocumentMetadata(document.getBytes());
        XmlDocument doc = this.dbXmlManager.manager.createDocument();
        String docName = name;
        if (docName == null || "".equals(docName)) {
            docName = metadata.get("PolicyId");
        }
        if (docName == null || "".equals(docName)) {
            throw new PolicyIndexException("Could not extract PolicyID from document.");
        }
        doc.setMetaData("metadata", "PolicyId", new XmlValue(29, docName));
        doc.setContent(document);
        doc.setName(docName);
        String item = null;
        item = metadata.get("anySubject");
        if (item != null) {
            doc.setMetaData("metadata", "anySubject", new XmlValue(29, item));
        }
        if ((item = metadata.get("anyResource")) != null) {
            doc.setMetaData("metadata", "anyResource", new XmlValue(29, item));
        }
        if ((item = metadata.get("anyAction")) != null) {
            doc.setMetaData("metadata", "anyAction", new XmlValue(29, item));
        }
        if ((item = metadata.get("anyEnvironment")) != null) {
            doc.setMetaData("metadata", "anyEnvironment", new XmlValue(29, item));
        }
        return doc;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean clear() throws PolicyIndexException {
        this.dbXmlManager.deleteDatabase();
        this.dbXmlManager.close();
        this.dbXmlManager = null;
        this.init();
        return true;
    }

    private boolean deleteDirectory(String directory) {
        File file;
        boolean result = false;
        if (directory != null && (file = new File(directory)).exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            result = true;
            for (File f : files) {
                if (f.isFile()) {
                    result = result && f.delete();
                    continue;
                }
                if (!f.isDirectory()) continue;
                result = result && this.deleteDirectory(f.getAbsolutePath());
            }
            file.delete();
        }
        return result;
    }
}

