/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.data;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.cond.EvaluationResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fcrepo.server.security.xacml.pdp.MelcoePDP;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndex;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexException;
import org.fcrepo.server.security.xacml.util.AttributeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class PolicyIndexBase
implements PolicyIndex {
    public boolean indexed = true;
    protected Map<String, Map<String, String>> indexMap = null;
    private static final Logger log = LoggerFactory.getLogger((String)PolicyIndexBase.class.getName());
    protected static final String METADATA_POLICY_NS = "metadata";
    private static final String CONFIG_FILE = "/conf/config-policy-index.xml";
    public static final Map<String, String> namespaces = new HashMap<String, String>();

    protected PolicyIndexBase() throws PolicyIndexException {
        this.initConfig();
    }

    private void initConfig() throws PolicyIndexException {
        String home = MelcoePDP.PDP_HOME.getAbsolutePath();
        String filename = home + CONFIG_FILE;
        File f = new File(filename);
        log.info("Loading config file: " + f.getAbsolutePath());
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            doc = docBuilder.parse(new FileInputStream(f));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            throw new PolicyIndexException("Configuration file " + filename + " not found.", e);
        }
        catch (SAXException e) {
            throw new PolicyIndexException("Error parsing config file + " + filename, e);
        }
        catch (IOException e) {
            throw new PolicyIndexException("Error reading config file " + filename, e);
        }
        NodeList nodes = null;
        String[] indexMapElements = new String[]{"subjectAttributes", "resourceAttributes", "actionAttributes", "environmentAttributes"};
        this.indexMap = new HashMap<String, Map<String, String>>();
        for (String s : indexMapElements) {
            this.indexMap.put(s, new HashMap());
        }
        nodes = doc.getElementsByTagName("indexMap").item(0).getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (log.isDebugEnabled()) {
                log.debug("Node name: " + node.getNodeName());
            }
            NodeList attrs = node.getChildNodes();
            for (int y = 0; y < attrs.getLength(); ++y) {
                Node attr = attrs.item(y);
                if (attr.getNodeType() != 1) continue;
                String name = attr.getAttributes().getNamedItem("name").getNodeValue();
                String type = attr.getAttributes().getNamedItem("type").getNodeValue();
                this.indexMap.get(node.getNodeName()).put(name, type);
            }
        }
    }

    protected Map<String, Set<AttributeBean>> getAttributeMap(EvaluationCtx eval) throws URISyntaxException {
        AttributeBean ab;
        String attributeType;
        AttributeValue value;
        Iterator i;
        AttributeValue attr;
        EvaluationResult result;
        URI defaultCategoryURI = new URI("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");
        Map<String, String> im = null;
        HashMap<String, Set<AttributeBean>> attributeMap = new HashMap<String, Set<AttributeBean>>();
        HashMap<String, AttributeBean> attributeBeans = null;
        im = this.indexMap.get("subjectAttributes");
        attributeBeans = new HashMap<String, AttributeBean>();
        for (String attributeId : im.keySet()) {
            result = eval.getSubjectAttribute(new URI(im.get(attributeId)), new URI(attributeId), defaultCategoryURI);
            if (result.getStatus() != null || result.indeterminate() || !(attr = result.getAttributeValue()).returnsBag() || !(i = ((BagAttribute)attr).iterator()).hasNext()) continue;
            while (i.hasNext()) {
                value = (AttributeValue)i.next();
                attributeType = im.get(attributeId);
                ab = (AttributeBean)attributeBeans.get(attributeId);
                if (ab == null) {
                    ab = new AttributeBean();
                    ab.setId(attributeId);
                    ab.setType(attributeType);
                    attributeBeans.put(attributeId, ab);
                }
                ab.addValue(value.encode());
            }
        }
        attributeMap.put("subjectAttributes", new HashSet(attributeBeans.values()));
        im = this.indexMap.get("resourceAttributes");
        attributeBeans = new HashMap();
        for (String attributeId : im.keySet()) {
            result = eval.getResourceAttribute(new URI(im.get(attributeId)), new URI(attributeId), null);
            if (result.getStatus() != null || result.indeterminate() || !(attr = result.getAttributeValue()).returnsBag() || !(i = ((BagAttribute)attr).iterator()).hasNext()) continue;
            while (i.hasNext()) {
                value = (AttributeValue)i.next();
                attributeType = im.get(attributeId);
                ab = (AttributeBean)attributeBeans.get(attributeId);
                if (ab == null) {
                    ab = new AttributeBean();
                    ab.setId(attributeId);
                    ab.setType(attributeType);
                    attributeBeans.put(attributeId, ab);
                }
                if (attributeId.equals("urn:oasis:names:tc:xacml:1.0:resource:resource-id") && value.encode().startsWith("/")) {
                    String[] components = PolicyIndexBase.makeComponents(value.encode());
                    if (components != null && components.length > 0) {
                        for (String c : components) {
                            ab.addValue(c);
                        }
                        continue;
                    }
                    ab.addValue(value.encode());
                    continue;
                }
                ab.addValue(value.encode());
            }
        }
        attributeMap.put("resourceAttributes", new HashSet(attributeBeans.values()));
        im = this.indexMap.get("actionAttributes");
        attributeBeans = new HashMap();
        for (String attributeId : im.keySet()) {
            result = eval.getActionAttribute(new URI(im.get(attributeId)), new URI(attributeId), null);
            if (result.getStatus() != null || result.indeterminate() || !(attr = result.getAttributeValue()).returnsBag() || !(i = ((BagAttribute)attr).iterator()).hasNext()) continue;
            while (i.hasNext()) {
                value = (AttributeValue)i.next();
                attributeType = im.get(attributeId);
                ab = (AttributeBean)attributeBeans.get(attributeId);
                if (ab == null) {
                    ab = new AttributeBean();
                    ab.setId(attributeId);
                    ab.setType(attributeType);
                    attributeBeans.put(attributeId, ab);
                }
                ab.addValue(value.encode());
            }
        }
        attributeMap.put("actionAttributes", new HashSet(attributeBeans.values()));
        im = this.indexMap.get("environmentAttributes");
        attributeBeans = new HashMap();
        for (String attributeId : im.keySet()) {
            Iterator i2;
            AttributeValue attr2;
            URI attrId;
            URI imAttrId = new URI(im.get(attributeId));
            EvaluationResult result2 = eval.getEnvironmentAttribute(imAttrId, attrId = new URI(attributeId), null);
            if (result2.getStatus() != null || result2.indeterminate() || !(attr2 = result2.getAttributeValue()).returnsBag() || !(i2 = ((BagAttribute)attr2).iterator()).hasNext()) continue;
            while (i2.hasNext()) {
                AttributeValue value2 = (AttributeValue)i2.next();
                String attributeType2 = im.get(attributeId);
                AttributeBean ab2 = (AttributeBean)attributeBeans.get(attributeId);
                if (ab2 == null) {
                    ab2 = new AttributeBean();
                    ab2.setId(attributeId);
                    ab2.setType(attributeType2);
                    attributeBeans.put(attributeId, ab2);
                }
                ab2.addValue(value2.encode());
            }
        }
        attributeMap.put("environmentAttributes", new HashSet(attributeBeans.values()));
        return attributeMap;
    }

    protected static String[] makeComponents(String resourceId) {
        if (resourceId == null || resourceId.equals("") || !resourceId.startsWith("/")) {
            return null;
        }
        ArrayList<String> components = new ArrayList<String>();
        String[] parts = resourceId.split("\\/");
        for (int x = 1; x < parts.length; ++x) {
            StringBuilder sb = new StringBuilder();
            for (int y = 0; y < x; ++y) {
                sb.append("/");
                sb.append(parts[y + 1]);
            }
            components.add(sb.toString());
            if (x != parts.length - 1) {
                components.add(sb.toString() + "/.*");
                continue;
            }
            components.add(sb.toString() + "$");
        }
        return components.toArray(new String[components.size()]);
    }

    static {
        namespaces.put("p", "urn:oasis:names:tc:xacml:2.0:policy:schema:os");
        namespaces.put("m", METADATA_POLICY_NS);
    }
}

