/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndex;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexBase;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexException;
import org.fcrepo.server.security.xacml.util.AttributeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XPathPolicyIndex
extends PolicyIndexBase
implements PolicyIndex {
    private static final Logger log = LoggerFactory.getLogger((String)XPathPolicyIndex.class.getName());
    private static String[] targets = new String[]{"Subject", "Resource", "Action", "Environment"};

    protected XPathPolicyIndex() throws PolicyIndexException {
    }

    public static Map<String, String> getXpathVariables(Map<String, Set<AttributeBean>> attributeMap) {
        HashMap<String, String> variables = new HashMap<String, String>();
        for (String t : targets) {
            int count = 0;
            for (AttributeBean bean : attributeMap.get(t.toLowerCase() + "Attributes")) {
                if (bean.getId().equals("urn:oasis:names:tc:xacml:1.0:resource:resource-id")) {
                    variables.put("XacmlResourceId", bean.getId());
                    if (log.isDebugEnabled()) {
                        log.debug("XacmlResourceId = '" + bean.getId() + "'");
                    }
                    int c = 0;
                    for (String value : bean.getValues()) {
                        variables.put("XacmlResourceIdValue" + c, value);
                        if (log.isDebugEnabled()) {
                            log.debug("XacmlResourceIdValue" + c + " = '" + value + "'");
                        }
                        ++c;
                    }
                    continue;
                }
                variables.put(t + "Id" + count, bean.getId());
                if (log.isDebugEnabled()) {
                    log.debug(t + "Id" + count + " = '" + bean.getId() + "'");
                }
                int valueCount = 0;
                for (String value : bean.getValues()) {
                    variables.put(t + "Id" + count + "-Value" + valueCount, value);
                    if (log.isDebugEnabled()) {
                        log.debug(t + "Id" + count + "-Value" + valueCount + " = '" + value + "'");
                    }
                    ++valueCount;
                }
                ++count;
            }
        }
        return variables;
    }

    protected static String getXpath(Map<String, Set<AttributeBean>> attributeMap) {
        int sections = 0;
        StringBuilder sb = new StringBuilder();
        int resourceValueCount = 0;
        for (AttributeBean b : attributeMap.get("resourceAttributes")) {
            if (!b.getId().equals("urn:oasis:names:tc:xacml:1.0:resource:resource-id")) continue;
            resourceValueCount += b.getValues().size();
        }
        sb.append("/p:Policy/p:Target[");
        for (String t : targets) {
            if (attributeMap.get(t.toLowerCase() + "Attributes").size() == 0) continue;
            if (sections > 0) {
                sb.append(" and ");
            }
            ++sections;
            sb.append("(");
            sb.append("(");
            sb.append("not(p:" + t + "s)");
            sb.append(" or ");
            sb.append("p:" + t + "s/p:Any" + t);
            sb.append(")");
            int count = 0;
            sb.append(" or (");
            sb.append("p:" + t + "s" + "/p:" + t + "/p:" + t + "Match/p:" + t + "AttributeDesignator/@AttributeId[");
            boolean firstBean = true;
            for (AttributeBean bean : attributeMap.get(t.toLowerCase() + "Attributes")) {
                if (!firstBean) {
                    sb.append(" and ");
                }
                if (bean.getId().equals("urn:oasis:names:tc:xacml:1.0:resource:resource-id") && resourceValueCount > 0) {
                    sb.append(". != $XacmlResourceId");
                    firstBean = false;
                    continue;
                }
                sb.append("$" + t + "Id" + count);
                firstBean = false;
            }
            sb.append("]");
            sb.append(")");
            for (AttributeBean bean : attributeMap.get(t.toLowerCase() + "Attributes")) {
                sb.append(" or ");
                sb.append("(");
                if (bean.getId().equals("urn:oasis:names:tc:xacml:1.0:resource:resource-id") && resourceValueCount > 0) {
                    sb.append("p:" + t + "s/p:" + t + "/p:" + t + "Match/");
                    sb.append("p:" + t + "AttributeDesignator/@AttributeId = ");
                    sb.append("$XacmlResourceId");
                    sb.append(" and ");
                    sb.append("(");
                    for (int i = 0; i < bean.getValues().size(); ++i) {
                        if (i > 0) {
                            sb.append(" or ");
                        }
                        sb.append("p:" + t + "s/p:" + t + "/p:" + t + "Match/");
                        sb.append("p:AttributeValue = ");
                        sb.append("$XacmlResourceIdValue" + i);
                    }
                    sb.append(")");
                } else {
                    sb.append("p:" + t + "s/p:" + t + "/p:" + t + "Match/");
                    sb.append("p:" + t + "AttributeDesignator/@AttributeId = ");
                    sb.append("$" + t + "Id" + count);
                    sb.append(" and ");
                    sb.append("(");
                    for (int valueCount = 0; valueCount < bean.getValues().size(); ++valueCount) {
                        if (valueCount > 0) {
                            sb.append(" or ");
                        }
                        sb.append("p:" + t + "s/p:" + t + "/p:" + t + "Match/");
                        sb.append("p:AttributeValue = ");
                        sb.append("$" + t + "Id" + count + "-Value" + valueCount);
                    }
                    sb.append(")");
                    ++count;
                }
                sb.append(")");
            }
            sb.append(")");
        }
        sb.append("]");
        return sb.toString();
    }
}

