/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.decorator;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.security.xacml.pdp.decorator.PolicyIndexInvocationHandler;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.fcrepo.server.storage.types.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementMethodInvocation
implements Management {
    private static Logger LOG = LoggerFactory.getLogger((String)PolicyIndexInvocationHandler.class.getName());
    public Action action = null;
    public Target target = null;
    public Component component = null;
    public Parameters parameters = new Parameters();

    private ManagementMethodInvocation() {
    }

    public ManagementMethodInvocation(Method method, Object[] args) throws InvocationTargetException {
        Method[] methods = this.getClass().getMethods();
        Method targetMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(method.getName())) continue;
            targetMethod = method;
            break;
        }
        if (targetMethod == null) {
            LOG.warn("Method " + method.getName() + " not found");
            throw new InvocationTargetException(new Exception("Method not found"));
        }
        try {
            targetMethod.invoke((Object)this, args);
        }
        catch (Exception e) {
            LOG.warn("Execution failed for method " + method.getName());
            throw new InvocationTargetException(e);
        }
    }

    public String addDatastream(Context context, String pid, String dsID, String[] altIDs, String dsLabel, boolean versionable, String mimeType, String formatURI, String dsLocation, String controlGroup, String dsState, String checksumType, String checksum, String logMessage) throws ServerException {
        this.action = Action.CREATE;
        this.target = Target.DATASTREAM;
        this.component = Component.CONTENT;
        this.parameters.context = context;
        this.parameters.pid = pid;
        this.parameters.dsID = dsID;
        this.parameters.dsState = dsState;
        return null;
    }

    public boolean addRelationship(Context context, String subject, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        this.action = Action.NA;
        return false;
    }

    public String compareDatastreamChecksum(Context context, String pid, String dsID, Date asOfDateTime) throws ServerException {
        this.action = Action.NA;
        return null;
    }

    public InputStream export(Context context, String pid, String format, String exportContext, String encoding) throws ServerException {
        this.action = Action.NA;
        return null;
    }

    public Datastream getDatastream(Context context, String pid, String dsID, Date asOfDateTime) throws ServerException {
        this.action = Action.NA;
        return null;
    }

    public Datastream[] getDatastreamHistory(Context context, String pid, String dsID) throws ServerException {
        this.action = Action.NA;
        return null;
    }

    public Datastream[] getDatastreams(Context context, String pid, Date asOfDateTime, String dsState) throws ServerException {
        this.action = Action.NA;
        return null;
    }

    public String[] getNextPID(Context context, int numPIDs, String namespace) throws ServerException {
        this.action = Action.NA;
        return null;
    }

    public InputStream getObjectXML(Context context, String pid, String encoding) throws ServerException {
        this.action = Action.NA;
        return null;
    }

    public RelationshipTuple[] getRelationships(Context context, String subject, String relationship) throws ServerException {
        this.action = Action.NA;
        return null;
    }

    public InputStream getTempStream(String id) throws ServerException {
        this.action = Action.NA;
        return null;
    }

    public String ingest(Context context, InputStream serialization, String logMessage, String format, String encoding, String newPid) throws ServerException {
        this.action = Action.CREATE;
        this.target = Target.DIGITALOBJECT;
        this.component = Component.CONTENT;
        this.parameters.context = context;
        return null;
    }

    public Date modifyDatastreamByReference(Context context, String pid, String dsID, String[] altIDs, String dsLabel, String mimeType, String formatURI, String dsLocation, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        this.action = Action.UPDATE;
        this.target = Target.DATASTREAM;
        this.component = Component.CONTENT;
        this.parameters.context = context;
        this.parameters.pid = pid;
        this.parameters.dsID = dsID;
        return null;
    }

    public Date modifyDatastreamByValue(Context context, String pid, String dsID, String[] altIDs, String dsLabel, String mimeType, String formatURI, InputStream dsContent, String checksumType, String checksum, String logMessage, Date lastModifiedDate) throws ServerException {
        this.action = Action.UPDATE;
        this.target = Target.DATASTREAM;
        this.component = Component.CONTENT;
        this.parameters.context = context;
        this.parameters.pid = pid;
        this.parameters.dsID = dsID;
        return null;
    }

    public Date modifyObject(Context context, String pid, String state, String label, String ownerID, String logMessage, Date lastModifiedDate) throws ServerException {
        this.action = Action.UPDATE;
        this.target = Target.DIGITALOBJECT;
        this.component = Component.STATE;
        this.parameters.context = context;
        this.parameters.pid = pid;
        this.parameters.objectState = state;
        return null;
    }

    public Date[] purgeDatastream(Context context, String pid, String dsID, Date startDT, Date endDT, String logMessage) throws ServerException {
        this.action = Action.DELETE;
        this.target = Target.DATASTREAM;
        this.component = Component.CONTENT;
        this.parameters.context = context;
        this.parameters.pid = pid;
        this.parameters.dsID = dsID;
        return null;
    }

    public Date purgeObject(Context context, String pid, String logMessage) throws ServerException {
        this.action = Action.DELETE;
        this.target = Target.DIGITALOBJECT;
        this.component = Component.CONTENT;
        this.parameters.context = context;
        this.parameters.pid = pid;
        return null;
    }

    public boolean purgeRelationship(Context context, String subject, String relationship, String object, boolean isLiteral, String datatype) throws ServerException {
        this.action = Action.NA;
        return false;
    }

    public String putTempStream(Context context, InputStream in) throws ServerException {
        this.action = Action.NA;
        return null;
    }

    public Date setDatastreamState(Context context, String pid, String dsID, String dsState, String logMessage) throws ServerException {
        this.action = Action.UPDATE;
        this.target = Target.DATASTREAM;
        this.component = Component.STATE;
        this.parameters.context = context;
        this.parameters.pid = pid;
        this.parameters.dsID = dsID;
        this.parameters.dsState = dsState;
        return null;
    }

    public Date setDatastreamVersionable(Context context, String pid, String dsID, boolean versionable, String logMessage) throws ServerException {
        this.action = Action.NA;
        return null;
    }

    public Validation validate(Context context, String pid, Date asOfDateTime) throws ServerException {
        this.action = Action.NA;
        return null;
    }

    public class Parameters {
        public Context context = null;
        public String pid = null;
        public String dsID = null;
        public String dsState = null;
        public String objectState = null;
    }

    public static enum Component {
        CONTENT,
        STATE,
        OTHER;

    }

    public static enum Target {
        DIGITALOBJECT,
        DATASTREAM,
        OTHER;

    }

    public static enum Action {
        CREATE,
        READ,
        UPDATE,
        DELETE,
        NA;

    }
}

