/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.decorator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.io.IOUtils;
import org.fcrepo.common.Constants;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.GeneralException;
import org.fcrepo.server.proxy.AbstractInvocationHandler;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndex;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexFactory;
import org.fcrepo.server.security.xacml.pdp.decorator.ManagementMethodInvocation;
import org.fcrepo.server.security.xacml.pdp.decorator.PolicyObject;
import org.fcrepo.server.storage.DOManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyIndexInvocationHandler
extends AbstractInvocationHandler {
    private static Logger LOG = LoggerFactory.getLogger((String)PolicyIndexInvocationHandler.class.getName());
    private Boolean initialised = null;
    private DOManager m_DOManager = null;
    private PolicyIndex policyIndex = null;

    public boolean init() {
        if (this.initialised != null) {
            return this.initialised;
        }
        this.initialised = false;
        Server s_server = null;
        try {
            s_server = Server.getInstance((File)new File(Constants.FEDORA_HOME), (boolean)false);
        }
        catch (Exception e) {
            LOG.error("Failed to get server instance", (Throwable)e);
            return false;
        }
        this.m_DOManager = (DOManager)s_server.getModule("org.fcrepo.server.storage.DOManager");
        if (this.m_DOManager == null) {
            LOG.error("failed to get DOManager module");
            return false;
        }
        try {
            PolicyIndexFactory factory = new PolicyIndexFactory();
            this.policyIndex = factory.newPolicyIndex();
        }
        catch (PolicyIndexException e) {
            LOG.error("Failed to initialise PolicyIndex", (Throwable)e);
            return false;
        }
        this.initialised = true;
        return this.initialised;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!this.init()) {
            return this.invokeTarget(this.target, method, args);
        }
        ManagementMethodInvocation managementMethod = new ManagementMethodInvocation(method, args);
        if (managementMethod.action.equals((Object)ManagementMethodInvocation.Action.NA)) {
            return this.invokeTarget(this.target, method, args);
        }
        Object returnValue = null;
        PolicyObject policyBefore = null;
        PolicyObject policyAfter = null;
        block0 : switch (managementMethod.target) {
            case DIGITALOBJECT: {
                block4 : switch (managementMethod.component) {
                    case STATE: {
                        if (managementMethod.parameters.objectState == null || managementMethod.parameters.objectState.length() <= 0) break;
                        policyBefore = new PolicyObject(this.m_DOManager, managementMethod.parameters.context, managementMethod.parameters.pid, null, null, null);
                        boolean indexedBefore = policyBefore.isPolicyActive();
                        returnValue = this.invokeTarget(this.target, method, args);
                        policyAfter = new PolicyObject(this.m_DOManager, managementMethod.parameters.context, managementMethod.parameters.pid, managementMethod.parameters.objectState, null, null);
                        if (indexedBefore == policyAfter.isPolicyActive()) break block0;
                        if (policyAfter.isPolicyActive()) {
                            this.addPolicy(managementMethod.parameters.pid, policyAfter.getDsContent());
                            break;
                        }
                        this.deletePolicy(managementMethod.parameters.pid);
                        break;
                    }
                    case CONTENT: {
                        switch (managementMethod.action) {
                            case CREATE: {
                                returnValue = this.invokeTarget(this.target, method, args);
                                policyAfter = new PolicyObject(this.m_DOManager, managementMethod.parameters.context, (String)returnValue, null, null, null);
                                if (!policyAfter.isPolicyActive()) break;
                                this.addPolicy((String)returnValue, policyAfter.getDsContent());
                                break block4;
                            }
                            case DELETE: {
                                policyBefore = new PolicyObject(this.m_DOManager, managementMethod.parameters.context, managementMethod.parameters.pid, null, null, null);
                                boolean wasIndexed = policyBefore.isPolicyActive();
                                returnValue = this.invokeTarget(this.target, method, args);
                                if (!wasIndexed) break;
                                this.deletePolicy(managementMethod.parameters.pid);
                                break block4;
                            }
                        }
                        break;
                    }
                }
                break;
            }
            case DATASTREAM: {
                if (managementMethod.parameters.dsID == null || !managementMethod.parameters.dsID.equals("FESLPOLICY")) break;
                block12 : switch (managementMethod.component) {
                    case STATE: {
                        policyBefore = new PolicyObject(this.m_DOManager, managementMethod.parameters.context, managementMethod.parameters.pid, null, managementMethod.parameters.dsID, null);
                        boolean wasIndexed = policyBefore.isPolicyActive();
                        returnValue = this.invokeTarget(this.target, method, args);
                        policyAfter = new PolicyObject(this.m_DOManager, managementMethod.parameters.context, managementMethod.parameters.pid, null, managementMethod.parameters.dsID, managementMethod.parameters.dsState);
                        if (wasIndexed == policyAfter.isPolicyActive()) break;
                        if (policyAfter.isPolicyActive()) {
                            this.addPolicy(managementMethod.parameters.pid, policyAfter.getDsContent());
                            break;
                        }
                        this.deletePolicy(managementMethod.parameters.pid);
                        break;
                    }
                    case CONTENT: {
                        switch (managementMethod.action) {
                            case CREATE: {
                                returnValue = this.invokeTarget(this.target, method, args);
                                policyAfter = new PolicyObject(this.m_DOManager, managementMethod.parameters.context, managementMethod.parameters.pid, null, managementMethod.parameters.dsID, managementMethod.parameters.dsState);
                                if (!policyAfter.isPolicyActive()) break block12;
                                this.addPolicy(managementMethod.parameters.pid, policyAfter.getDsContent());
                                break block12;
                            }
                            case DELETE: {
                                policyBefore = new PolicyObject(this.m_DOManager, managementMethod.parameters.context, managementMethod.parameters.pid, null, managementMethod.parameters.dsID, managementMethod.parameters.dsState);
                                boolean wasIndexed = policyBefore.isPolicyActive();
                                returnValue = this.invokeTarget(this.target, method, args);
                                policyAfter = new PolicyObject(this.m_DOManager, managementMethod.parameters.context, managementMethod.parameters.pid, null, managementMethod.parameters.dsID, null);
                                if (!wasIndexed) break block12;
                                if (policyAfter.isPolicyActive()) {
                                    this.updatePolicy(managementMethod.parameters.pid, policyAfter.getDsContent());
                                    break block12;
                                }
                                this.deletePolicy(managementMethod.parameters.pid);
                                break block12;
                            }
                            case UPDATE: {
                                returnValue = this.invokeTarget(this.target, method, args);
                                policyAfter = new PolicyObject(this.m_DOManager, managementMethod.parameters.context, managementMethod.parameters.pid, null, managementMethod.parameters.dsID, null);
                                if (!policyAfter.isPolicyActive()) break block12;
                                this.updatePolicy(managementMethod.parameters.pid, policyAfter.getDsContent());
                                break block12;
                            }
                        }
                        break;
                    }
                }
                break;
            }
        }
        if (returnValue == null) {
            returnValue = this.invokeTarget(this.target, method, args);
        }
        return returnValue;
    }

    private Object invokeTarget(Object target, Method method, Object[] args) throws Throwable {
        Object returnValue;
        try {
            returnValue = method.invoke(target, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        return returnValue;
    }

    private void addPolicy(String pid, InputStream dsContent) throws GeneralException {
        LOG.info("Adding policy " + pid);
        try {
            String policy = IOUtils.toString((InputStream)dsContent);
            dsContent.close();
            this.policyIndex.addPolicy(pid, policy);
        }
        catch (IOException e) {
            throw new GeneralException("Error adding policy " + pid + " to policy index: " + e.getMessage(), (Throwable)e);
        }
        catch (PolicyIndexException e) {
            throw new GeneralException("Error adding policy " + pid + " to policy index: " + e.getMessage(), (Throwable)e);
        }
    }

    private void updatePolicy(String pid, InputStream dsContent) throws GeneralException {
        LOG.info("Updating policy " + pid);
        try {
            String policy = IOUtils.toString((InputStream)dsContent);
            dsContent.close();
            this.policyIndex.updatePolicy(pid, policy);
        }
        catch (IOException e) {
            throw new GeneralException("Error adding policy " + pid + " to policy index: " + e.getMessage(), (Throwable)e);
        }
        catch (PolicyIndexException e) {
            throw new GeneralException("Error adding policy " + pid + " to policy index: " + e.getMessage(), (Throwable)e);
        }
    }

    private void deletePolicy(String pid) throws GeneralException {
        LOG.debug("Deleting policy " + pid);
        try {
            this.policyIndex.deletePolicy(pid);
        }
        catch (PolicyIndexException e) {
            throw new GeneralException("Error deleting policy " + pid + " from policy index: " + e.getMessage(), (Throwable)e);
        }
    }
}

