/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.finder.attribute;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.StandardAttributeFactory;
import com.sun.xacml.cond.EvaluationResult;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.rdf.SimpleURIReference;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.security.AttributeFinderModule;
import org.fcrepo.server.security.PolicyFinderModule;
import org.fcrepo.server.security.xacml.pdp.finder.AttributeFinderException;
import org.fcrepo.server.storage.DOManager;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOTriplesAttributeFinder
extends AttributeFinderModule {
    private static final Logger logger = LoggerFactory.getLogger(DOTriplesAttributeFinder.class);
    private static final Set<String> EMPTY = Collections.emptySet();
    private AttributeFactory m_attributeFactory = StandardAttributeFactory.getFactory();
    private Map<Integer, Set<String>> m_attributes = new HashMap<Integer, Set<String>>();
    private DOManager m_doManager;
    private Context fedoraCtx;

    public DOTriplesAttributeFinder(DOManager doManager) {
        this.m_doManager = doManager;
    }

    public void setActionAttributes(Set<String> attributes) {
        this.m_attributes.put(2, attributes);
    }

    public void setEnvironmentAttributes(Set<String> attributes) {
        this.m_attributes.put(3, attributes);
    }

    public void setResourceAttributes(Set<String> attributes) {
        this.m_attributes.put(1, attributes);
    }

    public void setSubjectAttributes(Set<String> attributes) {
        this.m_attributes.put(0, attributes);
    }

    private boolean emptyAttributeMap() {
        return this.m_attributes.size() == 0;
    }

    public void init() throws AttributeFinderException {
        if (this.emptyAttributeMap()) {
            logger.warn(((Object)((Object)this)).getClass().getName() + " configured with no registered attributes");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("registering the following attributes: ");
            for (int desNum : this.m_attributes.keySet()) {
                for (String attrName : this.m_attributes.get(desNum)) {
                    logger.debug(desNum + ": " + attrName);
                }
            }
        }
        logger.info("Initialised AttributeFinder:" + ((Object)((Object)this)).getClass().getName());
    }

    public boolean isDesignatorSupported() {
        return true;
    }

    public Set<Integer> getSupportedDesignatorTypes() {
        return this.m_attributes.keySet();
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI subjectCategory, EvaluationCtx context, int designatorType) {
        String pid;
        String resourceId = context.getResourceId().encode();
        if ((resourceId == null || resourceId.equals("")) && (pid = PolicyFinderModule.getPid((EvaluationCtx)context)) != null) {
            resourceId = "info:fedora/" + pid;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RIAttributeFinder: [" + attributeType.toString() + "] " + attributeId + ", rid=" + resourceId);
        }
        if (resourceId == null || resourceId.equals("")) {
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        if (resourceId.equals("/FedoraRepository")) {
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        String attrName = attributeId.toString();
        if (!this.m_attributes.containsKey(designatorType)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Does not know about designatorType: " + designatorType);
            }
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        Set<String> allowedAttributes = this.m_attributes.get(designatorType);
        if (!allowedAttributes.contains(attrName)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Does not know about attribute: " + attrName);
            }
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        EvaluationResult result = null;
        try {
            result = this.getEvaluationResult(resourceId, attrName, designatorType, attributeType);
        }
        catch (Exception e) {
            logger.error("Error finding attribute: " + e.getMessage(), (Throwable)e);
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        return result;
    }

    private EvaluationResult getEvaluationResult(String resourceID, String attribute, int designatorType, URI type) throws AttributeFinderException {
        String pid;
        String[] resourceParts = resourceID.split("/");
        HashSet<String> results = null;
        if (resourceParts.length > 1) {
            pid = resourceParts[resourceParts.length - 1].contains(":") ? resourceParts[resourceParts.length - 1] : resourceParts[resourceParts.length - 2];
        } else {
            logger.debug("Resource ID not valid path to PID or datastream: " + resourceID);
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)type));
        }
        logger.debug("Getting attribute for resource " + resourceID);
        try {
            SimpleURIReference snode = new SimpleURIReference(new URI(resourceID));
            SimpleURIReference pnode = new SimpleURIReference(new URI(attribute));
            DOReader reader = this.m_doManager.getReader(false, this.getContext(), pid);
            Set triples = reader.getRelationships((SubjectNode)snode, (PredicateNode)pnode, null);
            results = new HashSet<String>();
            for (RelationshipTuple triple : triples) {
                results.add(triple.object);
            }
        }
        catch (Exception e) {
            logger.warn("Error retreiving triples in attributeFinder", (Throwable)e);
        }
        if (results == null || results.isEmpty()) {
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)type));
        }
        HashSet<AttributeValue> bagValues = new HashSet<AttributeValue>();
        logger.debug("Attribute values found: " + results.size());
        for (String s : results) {
            AttributeValue attributeValue = null;
            try {
                attributeValue = this.m_attributeFactory.createValue(type, s);
            }
            catch (Exception e) {
                logger.error("Error creating attribute: " + e.getMessage(), (Throwable)e);
                continue;
            }
            bagValues.add(attributeValue);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("AttributeValue found: [" + type.toASCIIString() + "] " + s);
        }
        BagAttribute bag = new BagAttribute(type, bagValues);
        return new EvaluationResult((AttributeValue)bag);
    }

    protected boolean canHandleAdhoc() {
        return false;
    }

    protected Object getAttributeLocally(int designatorType, String attributeId, URI resourceCategory, EvaluationCtx context) {
        return null;
    }

    private Context getContext() throws Exception {
        if (this.fedoraCtx != null) {
            return this.fedoraCtx;
        }
        this.fedoraCtx = ReadOnlyContext.getContext(null, null, null, (boolean)false);
        return this.fedoraCtx;
    }
}

