/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.finder.attribute;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.StandardAttributeFactory;
import com.sun.xacml.cond.EvaluationResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.rdf.SimpleURIReference;
import org.fcrepo.server.resourceIndex.ResourceIndex;
import org.fcrepo.server.security.AttributeFinderModule;
import org.fcrepo.server.security.PolicyFinderModule;
import org.fcrepo.server.security.xacml.pdp.finder.AttributeFinderException;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trippi.TripleIterator;
import org.trippi.TrippiException;

public class RITriplesAttributeFinder
extends AttributeFinderModule {
    private static final Logger logger = LoggerFactory.getLogger(RITriplesAttributeFinder.class);
    private static final Set<String> EMPTY = Collections.emptySet();
    private AttributeFactory m_attributeFactory = StandardAttributeFactory.getFactory();
    private Map<Integer, Set<String>> m_attributes = new HashMap<Integer, Set<String>>();
    private ResourceIndex m_resourceIndex;

    public RITriplesAttributeFinder(ResourceIndex resourceIndex) {
        this.m_resourceIndex = resourceIndex;
    }

    public void setActionAttributes(Set<String> attributes) {
        this.m_attributes.put(2, attributes);
    }

    public void setEnvironmentAttributes(Set<String> attributes) {
        this.m_attributes.put(3, attributes);
    }

    public void setResourceAttributes(Set<String> attributes) {
        this.m_attributes.put(1, attributes);
    }

    public void setSubjectAttributes(Set<String> attributes) {
        this.m_attributes.put(0, attributes);
    }

    private boolean emptyAttributeMap() {
        return this.m_attributes.size() == 0;
    }

    public void init() throws AttributeFinderException {
        if (this.emptyAttributeMap()) {
            logger.warn(((Object)((Object)this)).getClass().getName() + " configured with no registered attributes");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("registering the following attributes: ");
            for (int desNum : this.m_attributes.keySet()) {
                for (String attrName : this.m_attributes.get(desNum)) {
                    logger.debug(desNum + ": " + attrName);
                }
            }
        }
        logger.info("Initialised AttributeFinder:" + ((Object)((Object)this)).getClass().getName());
    }

    public boolean isDesignatorSupported() {
        return true;
    }

    public Set<Integer> getSupportedDesignatorTypes() {
        return this.m_attributes.keySet();
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI subjectCategory, EvaluationCtx context, int designatorType) {
        String pid;
        String resourceId = context.getResourceId().encode();
        if ((resourceId == null || resourceId.equals("")) && (pid = PolicyFinderModule.getPid((EvaluationCtx)context)) != null) {
            resourceId = "info:fedora/" + pid;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("RITriplesAttributeFinder: [" + attributeType.toString() + "] " + attributeId + ", rid=" + resourceId);
        }
        if (resourceId == null || resourceId.equals("")) {
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        if (resourceId.equals("/FedoraRepository")) {
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        String attrName = attributeId.toString();
        if (!this.m_attributes.containsKey(designatorType)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Does not know about designatorType: " + designatorType);
            }
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        Set<String> allowedAttributes = this.m_attributes.get(designatorType);
        if (!allowedAttributes.contains(attrName)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Does not know about attribute: " + attrName);
            }
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        EvaluationResult result = null;
        try {
            result = this.getEvaluationResult(resourceId, attrName, designatorType, attributeType);
        }
        catch (Exception e) {
            logger.error("Error finding attribute: " + e.getMessage(), (Throwable)e);
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EvaluationResult getEvaluationResult(String resourceID, String attribute, int designatorType, URI type) throws AttributeFinderException {
        String[] resourceParts = resourceID.split("/");
        HashSet<String> results = null;
        if (resourceParts.length <= 1) {
            logger.debug("Resource ID not valid path to PID or datastream: " + resourceID);
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)type));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Getting attribute " + attribute + " for resource " + resourceID);
        }
        try {
            SimpleURIReference snode = new SimpleURIReference(new URI(resourceID));
            SimpleURIReference pnode = new SimpleURIReference(new URI(attribute));
            TripleIterator triples = this.m_resourceIndex.findTriples((SubjectNode)snode, (PredicateNode)pnode, null, 0);
            results = new HashSet<String>();
            while (triples.hasNext()) {
                Triple triple = triples.next();
                String object = triple.getObject().stringValue();
                results.add(object);
            }
        }
        catch (TrippiException e) {
            logger.warn("Error retreiving triples in attributeFinder", (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.warn("Error retreiving triples in attributeFinder", (Throwable)e);
        }
        if (results == null || results.isEmpty()) {
            logger.debug("Attribute values found: 0");
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)type));
        }
        HashSet<AttributeValue> bagValues = new HashSet<AttributeValue>();
        logger.debug("Attribute values found: " + results.size());
        for (String s : results) {
            AttributeValue attributeValue = null;
            try {
                attributeValue = this.m_attributeFactory.createValue(type, s);
            }
            catch (Exception e) {
                logger.error("Error creating attribute: " + e.getMessage(), (Throwable)e);
                continue;
            }
            bagValues.add(attributeValue);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("AttributeValue found: [" + type.toASCIIString() + "] " + s);
        }
        BagAttribute bag = new BagAttribute(type, bagValues);
        return new EvaluationResult((AttributeValue)bag);
    }

    protected boolean canHandleAdhoc() {
        return false;
    }

    protected Object getAttributeLocally(int designatorType, String attributeId, URI resourceCategory, EvaluationCtx context) {
        return null;
    }
}

