/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.finder.policy;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexException;
import org.fcrepo.server.security.xacml.pdp.finder.policy.PolicyManager;
import org.fcrepo.server.security.xacml.pdp.finder.policy.TopLevelPolicyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPolicyFinderModule
extends PolicyFinderModule {
    private static final Logger logger = LoggerFactory.getLogger(GenericPolicyFinderModule.class);
    private PolicyManager policyManager = null;

    public boolean isRequestSupported() {
        return true;
    }

    public void init(PolicyFinder finder) {
        try {
            this.policyManager = new PolicyManager(finder);
        }
        catch (URISyntaxException use) {
            logger.error("Error initialising DBPolicyFinderModule due to improper URI:", (Throwable)use);
        }
        catch (PolicyIndexException pdme) {
            logger.error("Error initialising DBPolicyFinderModule:", (Throwable)pdme);
        }
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        try {
            AbstractPolicy policy = this.policyManager.getPolicy(context);
            if (policy == null) {
                return new PolicyFinderResult();
            }
            return new PolicyFinderResult(policy);
        }
        catch (TopLevelPolicyException tlpe) {
            return new PolicyFinderResult(tlpe.getStatus());
        }
        catch (PolicyIndexException pdme) {
            if (logger.isDebugEnabled()) {
                logger.debug("problem processing policy", (Throwable)pdme);
            }
            ArrayList<String> codes = new ArrayList<String>();
            codes.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            return new PolicyFinderResult(new Status(codes, pdme.getMessage()));
        }
    }
}

