/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.finder.policy;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.MatchResult;
import com.sun.xacml.ParsingException;
import com.sun.xacml.PolicySet;
import com.sun.xacml.Target;
import com.sun.xacml.TargetSection;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinder;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.fcrepo.server.security.xacml.pdp.data.Config;
import org.fcrepo.server.security.xacml.pdp.data.PolicyConfigException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndex;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexFactory;
import org.fcrepo.server.security.xacml.pdp.finder.policy.PolicyReader;
import org.fcrepo.server.security.xacml.pdp.finder.policy.TopLevelPolicyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyManager {
    private static final Logger logger = LoggerFactory.getLogger(PolicyManager.class);
    private PolicyIndex policyIndex = null;
    private PolicyCombiningAlgorithm combiningAlg = null;
    private Target target = null;
    private PolicyReader policyReader = null;
    private static final String PARENT_POLICY_ID = "urn:com:sun:xacml:support:finder:dynamic-policy-set";
    private static URI parentPolicyId = null;

    public PolicyManager(PolicyFinder polFinder) throws URISyntaxException, PolicyIndexException {
        String policyCombiningAlgorithmClassname = null;
        PolicyIndexFactory indexFactory = new PolicyIndexFactory();
        try {
            this.policyIndex = indexFactory.newPolicyIndex();
        }
        catch (PolicyIndexException e) {
            throw new PolicyIndexException("Error getting PolicyIndex", e);
        }
        try {
            policyCombiningAlgorithmClassname = Config.policyCombiningAlgorithmClassName();
        }
        catch (PolicyConfigException e) {
            throw new PolicyIndexException("Error reading config for PolicyCombiningAlgorithm", e);
        }
        try {
            this.combiningAlg = (PolicyCombiningAlgorithm)Class.forName(policyCombiningAlgorithmClassname).newInstance();
        }
        catch (Exception e) {
            throw new PolicyIndexException("Error instantiating PolicyCombiningAlgorithm", e);
        }
        this.policyReader = new PolicyReader(polFinder, null);
        parentPolicyId = new URI(PARENT_POLICY_ID);
        this.target = new Target(new TargetSection(null, 0, 2), new TargetSection(null, 1, 2), new TargetSection(null, 2, 2), new TargetSection(null, 3, 2));
    }

    public AbstractPolicy getPolicy(EvaluationCtx eval) throws TopLevelPolicyException, PolicyIndexException {
        Map<String, byte[]> potentialPolicies = this.policyIndex.getPolicies(eval);
        logger.debug("Obtained policies: " + potentialPolicies.size());
        AbstractPolicy policy = this.matchPolicies(eval, potentialPolicies);
        logger.debug("Matched policies and created abstract policy.");
        return policy;
    }

    private AbstractPolicy matchPolicies(EvaluationCtx eval, Map<String, byte[]> policyList) throws TopLevelPolicyException {
        HashMap<String, AbstractPolicy> list = new HashMap<String, AbstractPolicy>();
        for (String policyId : policyList.keySet()) {
            try {
                byte[] pol = policyList.get(policyId);
                AbstractPolicy policy = this.policyReader.readPolicy(new ByteArrayInputStream(pol));
                MatchResult match = policy.match(eval);
                int result = match.getResult();
                if (result == 2) {
                    throw new TopLevelPolicyException(match.getStatus());
                }
                if (result != 0) continue;
                if (this.combiningAlg == null && list.size() > 0) {
                    ArrayList<String> code = new ArrayList<String>();
                    code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                    Status status = new Status(code, "too many applicable top-level policies");
                    throw new TopLevelPolicyException(status);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Matched policy: " + policyId);
                }
                list.put(policyId, policy);
            }
            catch (ParsingException pe) {
                logger.error("Error parsing policy: " + policyId + " (" + pe.getMessage() + ")");
            }
        }
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Iterator i = list.values().iterator();
                AbstractPolicy p = (AbstractPolicy)i.next();
                return p;
            }
        }
        return new PolicySet(parentPolicyId, this.combiningAlg, this.target, new ArrayList(list.values()));
    }
}

