/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.finder.policy;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.ParsingException;
import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import com.sun.xacml.finder.PolicyFinder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PolicyReader
implements ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(PolicyReader.class);
    public static final String POLICY_SCHEMA_PROPERTY = "com.sun.xacml.PolicySchema";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private final PolicyFinder finder;
    private DocumentBuilder builder;

    public PolicyReader(PolicyFinder finder) {
        this(finder, null);
    }

    public PolicyReader(PolicyFinder finder, File schemaFile) {
        this.finder = finder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        if (schemaFile == null) {
            factory.setValidating(false);
        } else {
            factory.setValidating(true);
            factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            factory.setAttribute(JAXP_SCHEMA_SOURCE, schemaFile);
        }
        try {
            this.builder = factory.newDocumentBuilder();
            this.builder.setErrorHandler(this);
        }
        catch (ParserConfigurationException pce) {
            throw new IllegalArgumentException("Filed to setup reader: " + pce.toString());
        }
    }

    public synchronized AbstractPolicy readPolicy(File file) throws ParsingException {
        try {
            return this.handleDocument(this.builder.parse(file));
        }
        catch (IOException ioe) {
            throw new ParsingException("Failed to read the file", (Throwable)ioe);
        }
        catch (SAXException saxe) {
            throw new ParsingException("Failed to parse the file", (Throwable)saxe);
        }
    }

    public synchronized AbstractPolicy readPolicy(InputStream input) throws ParsingException {
        try {
            return this.handleDocument(this.builder.parse(input));
        }
        catch (IOException ioe) {
            throw new ParsingException("Failed to read the stream", (Throwable)ioe);
        }
        catch (SAXException saxe) {
            throw new ParsingException("Failed to parse the stream", (Throwable)saxe);
        }
    }

    public synchronized AbstractPolicy readPolicy(URL url) throws ParsingException {
        try {
            return this.readPolicy(url.openStream());
        }
        catch (IOException ioe) {
            throw new ParsingException("Failed to resolve the URL: " + url.toString(), (Throwable)ioe);
        }
    }

    private AbstractPolicy handleDocument(Document doc) throws ParsingException {
        Element root = doc.getDocumentElement();
        String name = root.getTagName();
        if (name.equals("Policy")) {
            return Policy.getInstance((Node)root);
        }
        if (name.equals("PolicySet")) {
            return PolicySet.getInstance((Node)root, (PolicyFinder)this.finder);
        }
        throw new ParsingException("Unknown root document type: " + name);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        logger.warn("Warning on line " + exception.getLineNumber() + ": " + exception.getMessage());
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        logger.warn("Error on line " + exception.getLineNumber() + ": " + exception.getMessage() + " ... " + "Policy will not be available");
        throw new SAXException("error parsing policy");
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        logger.warn("Fatal error on line " + exception.getLineNumber() + ": " + exception.getMessage() + " ... " + "Policy will not be available");
        throw new SAXException("fatal error parsing policy");
    }
}

