/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fcrepo.server.security.xacml.pdp.finder.AttributeFinderException;

public class AttributeFinderConfig {
    private final Map<Integer, Designator> designators = new HashMap<Integer, Designator>();

    public Designator get(int designator) {
        return this.designators.get(new Integer(designator));
    }

    public Designator get(String designatorName) {
        return this.designators.get(AttributeFinderConfig.getTarget(designatorName));
    }

    public Set<Integer> getDesignatorIds() {
        return this.designators.keySet();
    }

    public Designator put(String designatorName) throws AttributeFinderException {
        int target = AttributeFinderConfig.getTarget(designatorName);
        if (target != -1) {
            Designator des = this.designators.get(target);
            if (des == null) {
                des = new Designator();
            }
            this.designators.put(new Integer(target), des);
            return des;
        }
        throw new AttributeFinderException("Invalid attribute designator name " + designatorName);
    }

    private static Integer getTarget(String targetName) {
        if (targetName.equals("resource")) {
            return 1;
        }
        if (targetName.equals("subject")) {
            return 0;
        }
        if (targetName.equals("environment")) {
            return 3;
        }
        if (targetName.equals("action")) {
            return 2;
        }
        return -1;
    }

    public class Designator {
        private final Map<String, Attribute> attributes = new HashMap<String, Attribute>();

        protected Designator() {
        }

        public Attribute get(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public Set<String> getAttributeNames() {
            return this.attributes.keySet();
        }

        public Attribute put(String attributeName) {
            Attribute attr = this.attributes.get(attributeName);
            if (attr == null) {
                attr = new Attribute();
            }
            this.attributes.put(attributeName, attr);
            return attr;
        }

        public class Attribute {
            private final Map<String, String> options = new HashMap<String, String>();

            protected Attribute() {
            }

            public String get(String optionName) {
                return this.options.get(optionName);
            }

            public String put(String optionName, String optionValue) {
                this.options.put(optionName, optionValue);
                return optionValue;
            }
        }
    }
}

