/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.util;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AnyURIAttribute;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Subject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fcrepo.common.Constants;
import org.fcrepo.server.security.xacml.MelcoeXacmlException;
import org.fcrepo.server.security.xacml.util.RELSRelationshipResolver;
import org.fcrepo.server.security.xacml.util.RelationshipResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContextUtil {
    private static final Logger logger = LoggerFactory.getLogger(ContextUtil.class);
    private static final URI XACML_RESOURCE_ID = URI.create("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
    private static final Map<URI, URI> actionMap = new ConcurrentHashMap<URI, URI>();
    private static final Map<String, String> actionValueMap = new ConcurrentHashMap<String, String>();
    private RelationshipResolver relationshipResolver = null;
    private static ContextUtil instance = null;

    protected ContextUtil() {
        this.initMappings();
    }

    public static ContextUtil getInstance() {
        if (instance == null) {
            instance = new ContextUtil();
        }
        return instance;
    }

    private void initMappings() {
        File configPEPFile = new File(Constants.FEDORA_HOME, "server/config/config-melcoe-pep-mapping.xml");
        FileInputStream is = null;
        try {
            is = new FileInputStream(configPEPFile);
        }
        catch (FileNotFoundException e) {
            logger.info("Mapping file, config-melcoe-pep-mapping.xml, not found.");
        }
        if (is != null) {
            logger.info("Mapping file found (config-melcoe-pep-mapping.xml). Loading maps");
            try {
                String to;
                String from;
                int x;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = factory.newDocumentBuilder();
                Document doc = docBuilder.parse(is);
                NodeList nodes = null;
                nodes = doc.getElementsByTagName("actionAttribute");
                if (nodes != null && nodes.getLength() > 0) {
                    for (x = 0; x < nodes.getLength(); ++x) {
                        if (nodes.item(x).getNodeType() != 1) continue;
                        from = nodes.item(x).getAttributes().getNamedItem("from").getNodeValue();
                        to = nodes.item(x).getAttributes().getNamedItem("to").getNodeValue();
                        try {
                            URI key = new URI(from);
                            URI value = new URI(to);
                            actionMap.put(key, value);
                            continue;
                        }
                        catch (URISyntaxException mue) {
                            logger.warn("Mapping contained invalid URI: [" + from + "] / [" + to + "]");
                        }
                    }
                }
                if ((nodes = doc.getElementsByTagName("actionAttributeValue")) != null && nodes.getLength() > 0) {
                    for (x = 0; x < nodes.getLength(); ++x) {
                        if (nodes.item(x).getNodeType() != 1) continue;
                        from = nodes.item(x).getAttributes().getNamedItem("from").getNodeValue();
                        to = nodes.item(x).getAttributes().getNamedItem("to").getNodeValue();
                        actionValueMap.put(from, to);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Error occurred loading the mapping file. Mappings will not be used.", (Throwable)e);
            }
        }
    }

    private RelationshipResolver initRelationshipResolver() {
        RelationshipResolver rr;
        String className = null;
        HashMap<String, String> options = null;
        try {
            File configPEPFile = new File(Constants.FEDORA_HOME, "server/config/config-melcoe-pep.xml");
            FileInputStream is = new FileInputStream(configPEPFile);
            if (is == null) {
                throw new MelcoeXacmlException("Could not locate config file: config-melcoe-pep.xml");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(is);
            NodeList nodes = doc.getElementsByTagName("relationship-resolver");
            if (nodes.getLength() != 1) {
                throw new MelcoeXacmlException("Config file needs to contain exactly 1 'relationship-resolver' section.");
            }
            Element relationshipResolverElement = (Element)nodes.item(0);
            className = relationshipResolverElement.getAttributes().getNamedItem("class").getNodeValue();
            NodeList optionList = relationshipResolverElement.getElementsByTagName("option");
            if (optionList != null && optionList.getLength() > 0) {
                options = new HashMap<String, String>();
                for (int x = 0; x < optionList.getLength(); ++x) {
                    Node n = optionList.item(x);
                    String key = n.getAttributes().getNamedItem("name").getNodeValue();
                    String value = n.getFirstChild().getNodeValue();
                    options.put(key, value);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Node [name]: " + key + ": " + value);
                }
            }
            if (options == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("creating relationship resolver WITHOUT options");
                }
                rr = (RelationshipResolver)Class.forName(className).newInstance();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("creating relationship resolver WITH options");
                }
                Constructor<?> c = Class.forName(className).getConstructor(Map.class);
                rr = (RelationshipResolver)c.newInstance(options);
            }
        }
        catch (Exception e) {
            logger.error("Failed to get configured RelationshipResolver " + className + ", will try " + "fallback. " + e.getMessage());
            logger.debug(e.getMessage());
            rr = options == null ? new RELSRelationshipResolver() : new RELSRelationshipResolver(options);
        }
        return rr;
    }

    public RelationshipResolver getRelationshipResolver() {
        if (this.relationshipResolver == null) {
            this.relationshipResolver = this.initRelationshipResolver();
        }
        return this.relationshipResolver;
    }

    public Set<Subject> setupSubjects(List<Map<URI, List<AttributeValue>>> subjs) {
        HashSet<Subject> subjects = new HashSet<Subject>();
        if (subjs == null || subjs.size() == 0) {
            subjects.add(new Subject(new HashSet()));
            return subjects;
        }
        for (Map<URI, List<AttributeValue>> s : subjs) {
            HashSet<Attribute> attributes = new HashSet<Attribute>();
            for (URI uri : s.keySet()) {
                List<AttributeValue> attributeValues = s.get(uri);
                for (AttributeValue attributeValue : attributeValues) {
                    attributes.add(new Attribute(uri, null, null, attributeValue));
                }
            }
            subjects.add(new Subject(attributes));
        }
        return subjects;
    }

    public Set<Attribute> setupResources(Map<URI, AttributeValue> res) throws MelcoeXacmlException {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        if (res == null || res.size() == 0) {
            return attributes;
        }
        try {
            String pid = null;
            AttributeValue pidAttr = res.get(XACML_RESOURCE_ID);
            if (pidAttr != null) {
                pid = pidAttr.encode();
                pid = this.getRelationshipResolver().buildRESTParentHierarchy(pid);
                String dsid = null;
                AttributeValue dsidAttr = res.get(Constants.DATASTREAM.ID.getURI());
                if (dsidAttr != null && !(dsid = dsidAttr.encode()).equals("")) {
                    pid = pid + "/" + dsid;
                }
                res.put(XACML_RESOURCE_ID, (AttributeValue)new AnyURIAttribute(new URI(pid)));
            }
        }
        catch (Exception e) {
            logger.error("Error finding parents.", (Throwable)e);
            throw new MelcoeXacmlException("Error finding parents.", e);
        }
        for (URI uri : res.keySet()) {
            attributes.add(new Attribute(uri, null, null, res.get(uri)));
        }
        return attributes;
    }

    public Set<Attribute> setupAction(Map<URI, AttributeValue> a) {
        HashSet<Attribute> actions = new HashSet<Attribute>();
        if (a == null || a.size() == 0) {
            return actions;
        }
        HashMap<URI, AttributeValue> newActions = new HashMap<URI, AttributeValue>();
        for (URI uri : a.keySet()) {
            String tmpValue;
            URI newUri = null;
            AttributeValue newValue = null;
            if (actionMap != null && actionMap.size() > 0) {
                newUri = actionMap.get(uri);
            }
            if (actionValueMap != null && actionValueMap.size() > 0 && (tmpValue = actionValueMap.get(a.get(uri).encode())) != null) {
                newValue = new StringAttribute(tmpValue);
            }
            newUri = newUri == null ? uri : newUri;
            newValue = newValue == null ? a.get(uri) : newValue;
            newActions.put(newUri, newValue);
        }
        for (URI uri : newActions.keySet()) {
            actions.add(new Attribute(uri, null, null, (AttributeValue)newActions.get(uri)));
        }
        return actions;
    }

    public Set<Attribute> setupEnvironment(Map<URI, AttributeValue> e) {
        HashSet<Attribute> environment = new HashSet<Attribute>();
        if (e == null || e.size() == 0) {
            return environment;
        }
        for (URI uri : e.keySet()) {
            environment.add(new Attribute(uri, null, null, e.get(uri)));
        }
        return environment;
    }

    public RequestCtx buildRequest(List<Map<URI, List<AttributeValue>>> subjects, Map<URI, AttributeValue> actions, Map<URI, AttributeValue> resources, Map<URI, AttributeValue> environment) throws MelcoeXacmlException {
        if (logger.isDebugEnabled()) {
            logger.debug("Building request!");
        }
        RequestCtx request = null;
        try {
            request = new RequestCtx(this.setupSubjects(subjects), this.setupResources(resources), this.setupAction(actions), this.setupEnvironment(environment));
        }
        catch (Exception e) {
            logger.error("Error creating request.", (Throwable)e);
            throw new MelcoeXacmlException("Error creating request", e);
        }
        return request;
    }

    public ResponseCtx makeResponseCtx(String response) throws MelcoeXacmlException {
        ResponseCtx resCtx = null;
        try {
            String newResponse = response.replaceAll("ResourceID", "ResourceId");
            ByteArrayInputStream is = new ByteArrayInputStream(newResponse.getBytes());
            resCtx = ResponseCtx.getInstance((InputStream)is);
        }
        catch (ParsingException pe) {
            throw new MelcoeXacmlException("Error parsing response.", pe);
        }
        return resCtx;
    }

    public RequestCtx makeRequestCtx(String request) throws MelcoeXacmlException {
        RequestCtx reqCtx = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(request.getBytes());
            reqCtx = RequestCtx.getInstance((InputStream)is);
        }
        catch (ParsingException pe) {
            throw new MelcoeXacmlException("Error parsing response.", pe);
        }
        return reqCtx;
    }

    public String makeRequestCtx(RequestCtx reqCtx) {
        ByteArrayOutputStream request = new ByteArrayOutputStream();
        reqCtx.encode((OutputStream)request, new Indenter());
        return new String(request.toByteArray());
    }

    public String makeResponseCtx(ResponseCtx resCtx) {
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        resCtx.encode((OutputStream)response, new Indenter());
        return new String(response.toByteArray());
    }

    public Map<String, Result> makeResultMap(ResponseCtx resCtx) {
        Iterator i = resCtx.getResults().iterator();
        HashMap<String, Result> resultMap = new HashMap<String, Result>();
        while (i.hasNext()) {
            Result r = (Result)i.next();
            resultMap.put(r.getResource(), r);
        }
        return resultMap;
    }
}

