/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;
import org.fcrepo.server.security.xacml.pdp.MelcoePDP;
import org.fcrepo.server.security.xacml.pdp.MelcoePDPException;
import org.fcrepo.server.security.xacml.pdp.data.FedoraPolicyStore;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStore;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStoreException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyUtils;
import org.fcrepo.server.security.xacml.util.PolicyFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulatePolicyDatabase {
    private static boolean policiesLoaded = false;
    private static final Logger logger = LoggerFactory.getLogger(PopulatePolicyDatabase.class);
    private static final String POLICY_HOME = MelcoePDP.PDP_HOME.getAbsolutePath() + "/policies";
    private static Set<String> policyNames = new HashSet<String>();

    public static void add(PolicyStore policyStore) throws PolicyStoreException, FileNotFoundException {
        logger.info("Starting clock!");
        long time1 = System.nanoTime();
        PopulatePolicyDatabase.addDocuments(policyStore);
        long time2 = System.nanoTime();
        logger.info("Stopping clock!");
        logger.info("Time taken: " + (time2 - time1));
    }

    public static synchronized void addDocuments(PolicyStore policyStore) throws PolicyStoreException, FileNotFoundException {
        if (policiesLoaded) {
            return;
        }
        File[] files = PopulatePolicyDatabase.getPolicyFiles();
        if (files.length == 0) {
            return;
        }
        PolicyUtils utils = new PolicyUtils();
        StringBuilder failedPolicies = new StringBuilder();
        for (File f : files) {
            try {
                String policyID = utils.getPolicyName(f);
                if (policyStore instanceof FedoraPolicyStore) {
                    if (policyID.contains(":")) {
                        policyID = policyID.replace(":", "%3A");
                    }
                    policyID = FedoraPolicyStore.FESL_BOOTSTRAP_POLICY_NAMESPACE + ":" + policyID;
                }
                if (policyStore.contains(policyID)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Policy database already contains " + policyID + " (" + f.getName() + ")" + ". Skipping.");
                    continue;
                }
                policyNames.add(policyStore.addPolicy(f, policyID));
            }
            catch (MelcoePDPException e) {
                logger.warn("Failed to add bootstrap policy " + f.getName() + " - " + e.getMessage());
                failedPolicies.append(f.getName() + "\n");
            }
        }
        if (failedPolicies.length() != 0) {
            throw new PolicyStoreException("Failed to load some bootstrap policies: " + failedPolicies.toString());
        }
        policiesLoaded = true;
    }

    public static File[] getPolicyFiles() {
        File policyHome = new File(POLICY_HOME);
        File[] policies = policyHome.listFiles(new PolicyFileFilter());
        return policies;
    }
}

