/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.util;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.common.MalformedPIDException;
import org.fcrepo.common.PID;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.security.xacml.MelcoeXacmlException;
import org.fcrepo.server.security.xacml.util.RelationshipResolver;
import org.fcrepo.server.security.xacml.util.RelationshipResolverBase;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RELSRelationshipResolver
extends RelationshipResolverBase
implements RelationshipResolver {
    private static final Logger logger = LoggerFactory.getLogger(RELSRelationshipResolver.class);
    private Management apim;
    private Context fedoraCtx;

    public RELSRelationshipResolver() {
        this(new HashMap<String, String>());
    }

    public RELSRelationshipResolver(Map<String, String> options) {
        super(options);
    }

    @Override
    public Map<String, Set<String>> getRelationships(String subject, String relationship) throws MelcoeXacmlException {
        RelationshipTuple[] tuples;
        if (subject == null) {
            logger.warn("Invalid subject argument for getRelationships.  Subject cannot be null");
            return new HashMap<String, Set<String>>();
        }
        String subjectURI = this.getFedoraResourceURI(subject);
        if (subjectURI == null) {
            logger.warn("Invalid subject argument for getRelationships: " + subject + ". Should be pid or datastream (URI form optional");
            return new HashMap<String, Set<String>>();
        }
        try {
            tuples = this.getApiM().getRelationships(this.getContext(), subjectURI, relationship);
        }
        catch (ServerException e) {
            if (e instanceof ObjectNotInLowlevelStorageException) {
                return new HashMap<String, Set<String>>();
            }
            throw new MelcoeXacmlException(e.getMessage(), e);
        }
        HashMap<String, Set<String>> relationships = new HashMap<String, Set<String>>();
        for (RelationshipTuple t : tuples) {
            String p = t.predicate;
            String o = t.object;
            HashSet<String> values = (HashSet<String>)relationships.get(p);
            if (values == null) {
                values = new HashSet<String>();
            }
            values.add(o);
            relationships.put(p, values);
        }
        return relationships;
    }

    private Management getApiM() {
        Server server;
        if (this.apim != null) {
            return this.apim;
        }
        try {
            server = Server.getInstance((File)new File(Constants.FEDORA_HOME), (boolean)false);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new RuntimeException("Failed getting instance of Fedora", e);
        }
        this.apim = (Management)server.getModule("org.fcrepo.server.management.Management");
        return this.apim;
    }

    private Context getContext() throws MelcoeXacmlException {
        if (this.fedoraCtx != null) {
            return this.fedoraCtx;
        }
        try {
            this.fedoraCtx = ReadOnlyContext.getContext(null, null, null, (boolean)false);
        }
        catch (Exception e) {
            throw new MelcoeXacmlException(e.getMessage(), e);
        }
        return this.fedoraCtx;
    }

    @Override
    public Map<String, Set<String>> getRelationships(String subject) throws MelcoeXacmlException {
        return this.getRelationships(subject, null);
    }

    @Override
    public String buildRESTParentHierarchy(String pid) throws MelcoeXacmlException {
        Set<String> parents = this.getParents(pid);
        if (parents == null || parents.size() == 0) {
            return "/" + pid;
        }
        String[] parentArray = parents.toArray(new String[parents.size()]);
        return this.buildRESTParentHierarchy(parentArray[0]) + "/" + pid;
    }

    protected Set<String> getParents(String pid) throws MelcoeXacmlException {
        if (logger.isDebugEnabled()) {
            logger.debug("Obtaining parents for: " + pid);
        }
        HashSet<String> parentPIDs = new HashSet<String>();
        if (pid.equalsIgnoreCase("FedoraRepository")) {
            return parentPIDs;
        }
        if (this.childRelationships != null) {
            logger.warn("Parent-child relationships have been specified, but the specified relationship resolver is not able to resolve these");
        }
        Map<String, Set<String>> allRelationships = this.parentRelationships.size() == 1 ? this.getRelationships(pid, (String)this.parentRelationships.get(0)) : this.getRelationships(pid);
        for (String rel : allRelationships.keySet()) {
            Set<String> parents;
            if (!this.parentRelationships.contains(rel) || (parents = allRelationships.get(rel)) == null) continue;
            for (String parent : parents) {
                try {
                    PID parentPID = new PID(parent);
                    parentPIDs.add(parentPID.toString());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("added parent " + parentPID.toString());
                }
                catch (MalformedPIDException e) {
                    logger.warn("Triple " + pid + " " + rel + " " + parent + " does not have a digital object as its target");
                }
            }
        }
        return parentPIDs;
    }

    @Override
    public Set<String> getAttributesFromQuery(String query, String queryLang, String variable) throws MelcoeXacmlException {
        logger.warn("RELS relationship resolver does not support retrieving attributes with an RI query");
        return Collections.emptySet();
    }
}

