/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.decorator;

import java.io.InputStream;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.DOManager;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.types.Datastream;

public class PolicyObject {
    private Datastream m_datastream = null;
    private InputStream m_dsContent = null;
    public static final String POLICY_DATASTREAM = "FESLPOLICY";
    private Boolean m_hasPolicyDatastream = null;
    private String m_pid = null;
    private String m_dsState = null;
    private String m_objectState = null;
    private DOManager m_DOManager = null;
    private DOReader m_reader = null;
    private Context m_context = null;

    private PolicyObject() {
    }

    public PolicyObject(DOManager manager, Context context, String pid, String objectState, String dsID, String dsState) {
        this.m_DOManager = manager;
        this.m_context = context;
        this.m_pid = pid;
        if (objectState != null) {
            this.m_objectState = objectState;
        }
        if (dsID != null && dsID.equals(POLICY_DATASTREAM)) {
            this.m_hasPolicyDatastream = true;
        }
        if (dsState != null) {
            this.m_dsState = dsState;
        }
    }

    public boolean isPolicyActive() throws ServerException {
        return this.hasPolicyDatastream() && this.isDatastreamActive() && this.isObjectActive();
    }

    public boolean isObjectActive() throws ServerException {
        if (this.m_objectState == null) {
            this.m_objectState = this.getReader().GetObjectState();
        }
        return this.m_objectState.equals("A");
    }

    public boolean isDatastreamActive() throws ServerException {
        if (this.m_dsState == null && this.getDatastream() != null) {
            this.m_dsState = this.m_datastream.DSState;
        }
        return this.m_dsState != null && this.m_dsState.equals("A");
    }

    public boolean hasPolicyDatastream() throws ServerException {
        if (this.m_hasPolicyDatastream == null) {
            this.m_hasPolicyDatastream = false;
            Datastream[] allDs = this.getReader().GetDatastreams(null, null);
            for (int i = 0; i < allDs.length; ++i) {
                if (!allDs[i].DatastreamID.equals(POLICY_DATASTREAM)) continue;
                this.m_hasPolicyDatastream = true;
                this.m_datastream = allDs[i];
                break;
            }
        }
        return this.m_hasPolicyDatastream;
    }

    private DOReader getReader() throws ServerException {
        if (this.m_reader == null) {
            this.m_reader = this.m_DOManager.getReader(false, this.m_context, this.m_pid);
        }
        return this.m_reader;
    }

    public InputStream getDsContent() throws ServerException {
        if (this.m_dsContent == null && this.getDatastream() != null) {
            this.m_dsContent = this.getDatastream().getContentStream();
            this.m_hasPolicyDatastream = true;
        }
        return this.m_dsContent;
    }

    private Datastream getDatastream() throws ServerException {
        if (this.m_datastream == null) {
            this.m_datastream = this.getReader().GetDatastream(POLICY_DATASTREAM, null);
        }
        this.m_hasPolicyDatastream = true;
        return this.m_datastream;
    }
}

