/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fcrepo.common.Constants;
import org.fcrepo.common.MalformedPIDException;
import org.fcrepo.common.PID;
import org.fcrepo.server.security.xacml.util.RelationshipResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationshipResolverBase
implements RelationshipResolver {
    private static final Logger logger = LoggerFactory.getLogger(RelationshipResolverBase.class);
    protected static final String REPOSITORY = "FedoraRepository";
    protected static String DEFAULT_RELATIONSHIP = "info:fedora/fedora-system:def/relations-external#isMemberOf";
    protected final List<String> parentRelationships = new ArrayList<String>();
    protected final List<String> childRelationships;

    public RelationshipResolverBase(Map<String, String> options) {
        ArrayList<String> childRels = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>(options.keySet());
        Collections.sort(keys);
        for (String s : keys) {
            if (s.startsWith("xacml-parent-relationship")) {
                this.parentRelationships.add(options.get(s));
                continue;
            }
            if (!s.startsWith("xacml-child-relationship")) continue;
            childRels.add(options.get(s));
        }
        if (this.parentRelationships.isEmpty()) {
            this.parentRelationships.add(DEFAULT_RELATIONSHIP);
        }
        this.childRelationships = childRels.isEmpty() ? null : childRels;
    }

    protected String getFedoraResourceURI(String res) {
        String resURI;
        PID pid;
        String strippedRes = res.startsWith(Constants.FEDORA.uri) ? res.substring(Constants.FEDORA.uri.length()) : res;
        String[] parts = strippedRes.split("/");
        try {
            pid = new PID(parts[0]);
        }
        catch (MalformedPIDException e1) {
            logger.warn("Invalid Fedora resource identifier: " + res + ". PID part of URI is malformed");
            return null;
        }
        if (parts.length == 1) {
            resURI = pid.toURI();
        } else if (parts.length == 2) {
            resURI = pid.toURI() + "/" + parts[1];
        } else {
            logger.warn("Invalid Fedora resource identifier: " + res + ". Should be pid or datastream (URI form optional");
            return null;
        }
        return resURI;
    }
}

