/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.finder.policy;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.MatchResult;
import com.sun.xacml.PolicySet;
import com.sun.xacml.Target;
import com.sun.xacml.TargetSection;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinder;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndex;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexException;
import org.fcrepo.server.security.xacml.pdp.finder.policy.TopLevelPolicyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyManager {
    private static final Logger logger = LoggerFactory.getLogger(PolicyManager.class);
    private final PolicyIndex m_policyIndex;
    private PolicyCombiningAlgorithm m_combiningAlg = null;
    private final PolicyFinder m_policyFinder;
    private Target m_target = null;
    private static final String PARENT_POLICY_ID = "urn:com:sun:xacml:support:finder:dynamic-policy-set";
    private static URI parentPolicyId = null;

    public PolicyManager(PolicyIndex policyIndex, PolicyCombiningAlgorithm combiningAlg, PolicyFinder policyFinder) {
        this.m_policyIndex = policyIndex;
        this.m_combiningAlg = combiningAlg;
        this.m_policyFinder = policyFinder;
        this.m_target = new Target(new TargetSection(null, 0, 2), new TargetSection(null, 1, 2), new TargetSection(null, 2, 2), new TargetSection(null, 3, 2));
    }

    public AbstractPolicy getPolicy(EvaluationCtx eval) throws TopLevelPolicyException, PolicyIndexException {
        Map<String, AbstractPolicy> potentialPolicies = this.m_policyIndex.getPolicies(eval, this.m_policyFinder);
        logger.debug("Obtained policies: {}", (Object)potentialPolicies.size());
        AbstractPolicy policy = this.matchPolicies(eval, potentialPolicies);
        logger.debug("Matched policies and created abstract policy.");
        return policy;
    }

    private AbstractPolicy matchPolicies(EvaluationCtx eval, Map<String, AbstractPolicy> policyList) throws TopLevelPolicyException {
        HashMap<String, AbstractPolicy> list = new HashMap<String, AbstractPolicy>();
        for (String policyId : policyList.keySet()) {
            AbstractPolicy policy = policyList.get(policyId);
            MatchResult match = policy.match(eval);
            int result = match.getResult();
            if (result == 2) {
                throw new TopLevelPolicyException(match.getStatus());
            }
            if (result != 0) continue;
            if (this.m_combiningAlg == null && list.size() > 0) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                throw new TopLevelPolicyException(status);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Matched policy: {}", (Object)policyId);
            }
            list.put(policyId, policy);
        }
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Iterator i = list.values().iterator();
                AbstractPolicy p = (AbstractPolicy)i.next();
                return p;
            }
        }
        return new PolicySet(parentPolicyId, this.m_combiningAlg, this.m_target, new ArrayList(list.values()));
    }

    static {
        try {
            parentPolicyId = new URI(PARENT_POLICY_ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

