/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp;

import com.sun.xacml.Indenter;
import com.sun.xacml.PDP;
import com.sun.xacml.PDPConfig;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.fcrepo.server.security.xacml.pdp.EvaluationException;
import org.fcrepo.server.security.xacml.pdp.MelcoePDP;
import org.fcrepo.server.security.xacml.pdp.MelcoePDPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MelcoePDPImpl
implements MelcoePDP {
    private static final Logger logger = LoggerFactory.getLogger(MelcoePDPImpl.class);
    private final PDP m_pdp;

    public MelcoePDPImpl(PDPConfig pdpConfig) throws MelcoePDPException {
        this.m_pdp = new PDP(pdpConfig);
        logger.info("PDP Instantiated and initialised!");
    }

    @Override
    public String evaluate(String request) throws EvaluationException {
        logger.debug("evaluating request: {}", (Object)request);
        RequestCtx req = null;
        ByteArrayInputStream is = new ByteArrayInputStream(request.getBytes());
        try {
            req = RequestCtx.getInstance((InputStream)is);
        }
        catch (ParsingException pe) {
            logger.error("Error parsing request:\n" + request, (Throwable)pe);
            throw new EvaluationException("Error parsing request:\n" + request);
        }
        ResponseCtx res = this.m_pdp.evaluate(req);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        res.encode((OutputStream)os, new Indenter());
        logger.debug("response is: {}", (Object)os.toString());
        return os.toString();
    }

    @Override
    public String evaluateBatch(String[] requests) throws EvaluationException {
        logger.debug("evaluating request batch");
        HashSet results = new HashSet();
        for (String req : requests) {
            ResponseCtx resCtx = null;
            String response = this.evaluate(req);
            ByteArrayInputStream is = new ByteArrayInputStream(response.getBytes());
            try {
                resCtx = ResponseCtx.getInstance((InputStream)is);
            }
            catch (ParsingException pe) {
                logger.error("Error parsing response:\n" + response, (Throwable)pe);
                throw new EvaluationException("Error parsing response:\n" + response);
            }
            Set r = resCtx.getResults();
            results.addAll(r);
        }
        ResponseCtx combinedResponse = new ResponseCtx(results);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        combinedResponse.encode((OutputStream)os, new Indenter());
        return os.toString();
    }
}

