/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;
import org.fcrepo.server.security.xacml.pdp.MelcoePDPException;
import org.fcrepo.server.security.xacml.pdp.data.FedoraPolicyStore;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStore;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStoreException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyUtils;
import org.fcrepo.server.security.xacml.util.PopulatePolicyDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPolicyStore
implements PolicyStore {
    public static final Logger LOGGER = LoggerFactory.getLogger(PopulatePolicyDatabase.class);
    public static Set<String> policyNames = new HashSet<String>();
    protected boolean policiesLoaded = false;

    @Override
    public void init() throws FileNotFoundException, PolicyStoreException {
        AbstractPolicyStore.addDocuments(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadPolicies() throws FileNotFoundException, PolicyStoreException {
        Class<AbstractPolicyStore> clazz = AbstractPolicyStore.class;
        synchronized (AbstractPolicyStore.class) {
            this.policiesLoaded = false;
            AbstractPolicyStore.addDocuments(this, true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void addDocuments(AbstractPolicyStore policyStore) throws PolicyStoreException, FileNotFoundException {
        AbstractPolicyStore.addDocuments(policyStore, false);
    }

    public static synchronized void addDocuments(AbstractPolicyStore policyStore, boolean reload) throws PolicyStoreException, FileNotFoundException {
        if (policyStore.policiesLoaded) {
            return;
        }
        File[] files = PopulatePolicyDatabase.getPolicyFiles();
        if (files.length == 0) {
            return;
        }
        PolicyUtils utils = new PolicyUtils();
        StringBuilder failedPolicies = new StringBuilder();
        for (File f : files) {
            try {
                String policyID = utils.getPolicyName(f);
                if (policyStore instanceof FedoraPolicyStore) {
                    if (policyID.contains(":")) {
                        policyID = policyID.replace(":", "%3A");
                    }
                    policyID = FedoraPolicyStore.FESL_BOOTSTRAP_POLICY_NAMESPACE + ":" + policyID;
                }
                if (policyStore.contains(policyID) && !reload) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Policy database already contains " + policyID + " (" + f.getName() + ")" + ". Skipping.");
                    continue;
                }
                policyNames.add(policyStore.addPolicy(f, policyID));
            }
            catch (MelcoePDPException e) {
                LOGGER.warn("Failed to add bootstrap policy " + f.getName() + " - " + e.getMessage());
                failedPolicies.append(f.getName() + "\n");
            }
        }
        if (failedPolicies.length() != 0) {
            throw new PolicyStoreException("Failed to load some bootstrap policies: " + failedPolicies.toString());
        }
        policyStore.policiesLoaded = true;
    }
}

