/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.finder.attribute;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.StandardAttributeFactory;
import com.sun.xacml.cond.EvaluationResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.fcrepo.server.security.xacml.pdp.finder.AttributeFinderException;
import org.fcrepo.server.security.xacml.pdp.finder.attribute.DesignatorAttributeFinderModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPAttributeFinder
extends DesignatorAttributeFinderModule {
    private static final Logger logger = LoggerFactory.getLogger(LDAPAttributeFinder.class);
    private final AttributeFactory attributeFactory = StandardAttributeFactory.getFactory();
    private Hashtable<String, String> dirEnv = null;
    private Map<String, String> m_options = null;
    private InitialDirContext ctx = null;

    public LDAPAttributeFinder(Map<String, String> options) {
        try {
            this.m_options = options;
            this.dirEnv = new Hashtable<String, String>(options);
            this.ctx = new InitialDirContext(this.dirEnv);
        }
        catch (Exception e) {
            logger.error("Attribute finder not initialised:" + ((Object)((Object)this)).getClass().getName(), (Throwable)e);
        }
    }

    public void init() throws AttributeFinderException {
        if (this.emptyAttributeMap()) {
            logger.warn(((Object)((Object)this)).getClass().getName() + " configured with no registered attributes");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("registering the following attributes: ");
            Iterator i$ = this.m_attributes.keySet().iterator();
            while (i$.hasNext()) {
                int desNum = (Integer)i$.next();
                for (String attrName : ((Map)this.m_attributes.get(desNum)).keySet()) {
                    logger.debug(desNum + ": " + attrName);
                }
            }
        }
        logger.info("Initialised AttributeFinder:" + ((Object)((Object)this)).getClass().getName());
    }

    @Override
    public boolean isDesignatorSupported() {
        return true;
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI subjectCategory, EvaluationCtx context, int designatorType) {
        String user = null;
        try {
            URI userId = new URI("urn:fedora:names:fedora:2.1:subject:loginId");
            URI userType = new URI("http://www.w3.org/2001/XMLSchema#string");
            URI category = new URI("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");
            EvaluationResult userER = context.getSubjectAttribute(userType, userId, category);
            if (userER == null) {
                return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
            }
            AttributeValue userAV = userER.getAttributeValue();
            if (userAV == null) {
                return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
            }
            user = userAV.encode();
            if (logger.isDebugEnabled()) {
                logger.debug("LDAPAttributeFinder: Getting info for " + user);
            }
        }
        catch (URISyntaxException use) {
            logger.error(use.getMessage());
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        String attrName = attributeId.toString();
        if (this.m_attributes.get(designatorType) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Does not know about designatorType: " + designatorType);
            }
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        Set allowedAttributes = ((Map)this.m_attributes.get(designatorType)).keySet();
        if (!allowedAttributes.contains(attrName)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Does not know about attribute: " + attrName);
            }
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        EvaluationResult result = null;
        try {
            result = this.getEvaluationResult(user, attrName, attributeType);
        }
        catch (Exception e) {
            logger.error("Error finding attribute: " + e.getMessage(), (Throwable)e);
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        return result;
    }

    private EvaluationResult getEvaluationResult(String user, String attribute, URI type) {
        String[] attrsReturned = new String[]{attribute};
        String base = this.m_options.get("searchbase");
        String filter = "(" + this.m_options.get("id-attribute") + "=" + user + ")";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setDerefLinkFlag(true);
        searchControls.setReturningObjFlag(true);
        searchControls.setReturningAttributes(attrsReturned);
        HashSet<AttributeValue> bagValues = new HashSet<AttributeValue>();
        try {
            NamingEnumeration<SearchResult> ne = this.ctx.search(base, filter, searchControls);
            while (ne.hasMore()) {
                SearchResult result = ne.next();
                Attributes attrs = result.getAttributes();
                NamingEnumeration<? extends Attribute> neas = attrs.getAll();
                while (neas.hasMoreElements()) {
                    Attribute attr = (Attribute)neas.nextElement();
                    if (!attr.getID().equals(attribute)) continue;
                    NamingEnumeration<?> nea = attr.getAll();
                    while (nea.hasMoreElements()) {
                        String value = (String)nea.nextElement();
                        if (logger.isDebugEnabled()) {
                            logger.debug(attr.getID() + ": " + value);
                        }
                        AttributeValue attributeValue = null;
                        try {
                            attributeValue = this.attributeFactory.createValue(type, value);
                        }
                        catch (Exception e) {
                            logger.error("Error creating attribute: " + e.getMessage(), (Throwable)e);
                            continue;
                        }
                        bagValues.add(attributeValue);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("AttributeValue found: [" + type.toASCIIString() + "] " + value);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error getting evaluation result", (Throwable)e);
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)type));
        }
        BagAttribute bag = new BagAttribute(type, bagValues);
        return new EvaluationResult((AttributeValue)bag);
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> test = new HashMap<String, String>();
        LDAPAttributeFinder finder = new LDAPAttributeFinder(test);
        URI type = new URI("http://www.w3.org/2001/XMLSchema#string");
        EvaluationResult result = finder.getEvaluationResult("nishen", "eduPersonEntitlement", type);
        BagAttribute bag = (BagAttribute)result.getAttributeValue();
        for (AttributeValue a : bag) {
            logger.info("value: " + a.encode());
        }
    }
}

