/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.finder.policy;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.fcrepo.server.security.xacml.pdp.MelcoePDPException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndex;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexException;
import org.fcrepo.server.security.xacml.pdp.finder.policy.PolicyManager;
import org.fcrepo.server.security.xacml.pdp.finder.policy.TopLevelPolicyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPolicyFinderModule
extends PolicyFinderModule {
    private static final Logger logger = LoggerFactory.getLogger(GenericPolicyFinderModule.class);
    private PolicyIndex m_policyIndex;
    private PolicyCombiningAlgorithm m_combiningAlg;
    private PolicyManager m_policyManager = null;

    public GenericPolicyFinderModule(PolicyIndex policyIndex, PolicyCombiningAlgorithm combiningAlg) throws PolicyIndexException, URISyntaxException {
        this.m_policyIndex = policyIndex;
        this.m_combiningAlg = combiningAlg;
    }

    public boolean isRequestSupported() {
        return true;
    }

    public void init() throws MelcoePDPException {
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        try {
            AbstractPolicy policy = this.m_policyManager.getPolicy(context);
            if (policy == null) {
                return new PolicyFinderResult();
            }
            return new PolicyFinderResult(policy);
        }
        catch (TopLevelPolicyException tlpe) {
            return new PolicyFinderResult(tlpe.getStatus());
        }
        catch (PolicyIndexException pdme) {
            if (logger.isDebugEnabled()) {
                logger.debug("problem processing policy", (Throwable)pdme);
            }
            ArrayList<String> codes = new ArrayList<String>();
            codes.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            return new PolicyFinderResult(new Status(codes, pdme.getMessage()));
        }
    }

    public void init(PolicyFinder policyFinder) {
        this.m_policyManager = new PolicyManager(this.m_policyIndex, this.m_combiningAlg, policyFinder);
    }
}

